/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import mezz.jei.config.Config;
import mezz.jei.config.OverlayToggleEvent;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.recipes.RecipeRegistry;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class GuiEventHandler {
    private final IngredientListOverlay ingredientListOverlay;
    private final RecipeRegistry recipeRegistry;
    private boolean drawnOnBackground = false;

    public GuiEventHandler(IngredientListOverlay ingredientListOverlay, RecipeRegistry recipeRegistry) {
        this.ingredientListOverlay = ingredientListOverlay;
        this.recipeRegistry = recipeRegistry;
    }

    @SubscribeEvent
    public void onOverlayToggle(OverlayToggleEvent event) {
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        this.ingredientListOverlay.updateScreen(currentScreen);
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen gui = event.getGui();
        this.ingredientListOverlay.updateScreen(gui);
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        GuiScreen gui = event.getGui();
        this.ingredientListOverlay.updateScreen(gui);
    }

    @SubscribeEvent
    public void onDrawBackgroundEventPost(GuiScreenEvent.BackgroundDrawnEvent event) {
        GuiScreen gui = event.getGui();
        this.ingredientListOverlay.updateScreen(gui);
        this.drawnOnBackground = true;
        this.ingredientListOverlay.drawScreen(gui.field_146297_k, event.getMouseX(), event.getMouseY(), gui.field_146297_k.func_184121_ak());
    }

    @SubscribeEvent
    public void onDrawForegroundEvent(GuiContainerEvent.DrawForeground event) {
        GuiContainer gui = event.getGuiContainer();
        this.ingredientListOverlay.drawOnForeground(gui, event.getMouseX(), event.getMouseY());
    }

    @SubscribeEvent
    public void onDrawScreenEventPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        GuiContainer guiContainer;
        GuiScreen gui = event.getGui();
        this.ingredientListOverlay.updateScreen(gui);
        if (!this.drawnOnBackground) {
            this.ingredientListOverlay.drawScreen(gui.field_146297_k, event.getMouseX(), event.getMouseY(), gui.field_146297_k.func_184121_ak());
        }
        this.drawnOnBackground = false;
        if (gui instanceof GuiContainer && this.recipeRegistry.getRecipeClickableArea(guiContainer = (GuiContainer)gui, event.getMouseX() - guiContainer.getGuiLeft(), event.getMouseY() - guiContainer.getGuiTop()) != null) {
            String showRecipesText = Translator.translateToLocal("jei.tooltip.show.recipes");
            TooltipRenderer.drawHoveringText(guiContainer.field_146297_k, showRecipesText, event.getMouseX(), event.getMouseY());
        }
        this.ingredientListOverlay.drawTooltips(gui.field_146297_k, event.getMouseX(), event.getMouseY());
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        this.ingredientListOverlay.handleTick();
    }

    @SubscribeEvent
    public void onPotionShiftEvent(GuiScreenEvent.PotionShiftEvent event) {
        if (Config.isOverlayEnabled()) {
            event.setCanceled(true);
        }
    }
}

