/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.worldportal.storage;

import java.io.Serializable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class BlockData
implements Serializable {
    public int state = 0;
    public int lightLevel = 0;
    public String nbtTag;
    public int blockMetaData = 0;
    public transient NBTTagCompound compound;
    public transient IBlockState blockState;
    public transient TileEntity tileEntity;

    public BlockData() {
    }

    public BlockData(IBlockState state, TileEntity tileEntity, int lightLevel) {
        this.setState(state);
        this.setLightLevel(lightLevel);
        if (tileEntity != null) {
            this.blockMetaData = tileEntity.func_145832_p();
            this.nbtTag = tileEntity.serializeNBT().toString();
        }
    }

    public void setLightLevel(int lightLevel) {
        this.lightLevel = lightLevel;
    }

    public void setTileEntity(TileEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    public void setState(IBlockState state) {
        this.state = Block.func_176210_f((IBlockState)state);
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public NBTTagCompound getCompound() {
        if (this.compound == null && this.nbtTag != null && !this.nbtTag.equals("")) {
            try {
                this.compound = JsonToNBT.func_180713_a((String)this.nbtTag);
            }
            catch (NBTException e) {
                e.printStackTrace();
            }
        }
        return this.compound;
    }

    public IBlockState getState() {
        if (this.blockState == null) {
            this.blockState = Block.func_176220_d((int)this.state);
        }
        return this.blockState;
    }
}

