/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.commands;

import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tileentity.tardis.perms.TardisPermission;
import com.swdteam.utils.EnumDefaultResponse;
import com.swdteam.utils.PlayerUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.server.command.CommandTreeBase;

public class CommandTardisInteraction
extends CommandTreeBase {
    public String func_71517_b() {
        return "tardis-perms";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " [owner/companions/everyone]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            if (player.func_130014_f_().field_73011_w.getDimension() != DMDimensions.DIM_TARDIS_ID) {
                PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.CANNOT_EXECUTE_IN_DIMENSION);
                return;
            }
            TardisData data = DMTardis.getTardis(player.func_180425_c());
            if (data != null) {
                if (data.getCurrentOwner() != null) {
                    if (!data.getCurrentOwner().equals(player.func_110124_au())) {
                        PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.NOT_YOUR_TARDIS);
                        return;
                    }
                } else {
                    return;
                }
                if (args.length > 0) {
                    String perm = args[0].toLowerCase();
                    if (perm.equals("owner") || perm.equals("companions") || perm.equals("everyone")) {
                        data.setTardisPermissions(TardisPermission.getFromString(perm));
                        TardisSaveHandler.saveTardis(data);
                        PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.GREEN + "Updated Tardis perms to: " + perm);
                    } else {
                        PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.INVALID_COMMAND_PARAMS);
                    }
                } else {
                    PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.GREEN + "Current Tardis permissions: " + (Object)((Object)data.getTardisPermissions()));
                }
            } else {
                PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.TARDIS_DOES_NOT_EXIST);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        switch (args.length) {
            case 1: {
                return CommandTardisInteraction.func_71530_a((String[])args, (String[])new String[]{"everyone", "companions", "owner"});
            }
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

