/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.network.packets;

import com.swdteam.client.data.ClientTardisCache;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.network.packets.AbstractTwoWayMessageHandler;
import com.swdteam.network.packets.PacketHandler;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class Packet_RequestTardisDataSync
implements IMessage {
    public int tardisID;
    public TardisData data;

    public Packet_RequestTardisDataSync() {
    }

    public Packet_RequestTardisDataSync(int tardisID) {
        this.tardisID = tardisID;
        this.data = null;
    }

    public Packet_RequestTardisDataSync(TardisData data) {
        this.tardisID = 0;
        this.data = data;
    }

    public void fromBytes(ByteBuf buf) {
        this.tardisID = buf.readInt();
        if (buf.readableBytes() > 0) {
            PacketBuffer pb = new PacketBuffer(buf);
            ByteArrayInputStream ins = new ByteArrayInputStream(pb.func_179251_a());
            try {
                ObjectInputStream ois = new ObjectInputStream(ins);
                Object o = ois.readObject();
                if (o instanceof TardisData) {
                    this.data = (TardisData)o;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.data = null;
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.tardisID);
        if (this.data != null) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(this.data);
                oos.close();
                PacketBuffer pb = new PacketBuffer(buf);
                pb.func_179250_a(bos.toByteArray());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class Handler
    extends AbstractTwoWayMessageHandler<Packet_RequestTardisDataSync> {
        @Override
        public IMessage handleServerMessage(final EntityPlayer player, final Packet_RequestTardisDataSync message, MessageContext ctx) {
            player.func_184102_h().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    PacketHandler.INSTANCE.sendTo((IMessage)new Packet_RequestTardisDataSync(DMTardis.getTardis(message.tardisID)), (EntityPlayerMP)player);
                }
            });
            return null;
        }

        @Override
        public IMessage handleClientMessage(EntityPlayer player, Packet_RequestTardisDataSync message, MessageContext ctx) {
            if (message.data != null) {
                ClientTardisCache.requestCallback(message.data);
            }
            return null;
        }
    }
}

