/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.network.packets;

import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.network.packets.AbstractServerMessageHandler;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.Vector3;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class Packet_UpdateTardisDataField
implements IMessage {
    public String field;
    public String data;
    public int tardis;

    public Packet_UpdateTardisDataField() {
    }

    public Packet_UpdateTardisDataField(int tardis, String fieldName, String data) {
        this.field = fieldName;
        this.data = data;
        this.tardis = tardis;
    }

    public void fromBytes(ByteBuf buf) {
        this.field = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.data = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.tardis = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.field);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.data);
        buf.writeInt(this.tardis);
    }

    public static class Handler
    extends AbstractServerMessageHandler<Packet_UpdateTardisDataField> {
        @Override
        public IMessage handleServerMessage(final EntityPlayer player, final Packet_UpdateTardisDataField message, MessageContext ctx) {
            player.func_184102_h().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EnumActionResult RESULT = EnumActionResult.SUCCESS;
                    int tardisID = message.tardis;
                    TardisData tData = DMTardis.getTardis(tardisID);
                    String FIELD = message.field;
                    String DATA = message.data;
                    if (DMTardis.hasPermission(tData, player)) {
                        if (FIELD.equals("tardisDIM")) {
                            if (DMDimensions.getPlanets().containsKey(Integer.parseInt(DATA))) {
                                tData.setTardisDestinationDimension(Integer.parseInt(DATA));
                            } else {
                                PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.RED + "This planet does not exist on this server");
                                RESULT = EnumActionResult.FAIL;
                            }
                        }
                        if (FIELD.equals("exterior")) {
                            int exteriorID = 0;
                            try {
                                exteriorID = Integer.parseInt(DATA);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (tData.getUnlockedExteriors().contains(exteriorID) || player.func_184812_l_()) {
                                tData.setExteriorID(exteriorID);
                            } else {
                                PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.RED + "You have not unlocked this skin yet");
                            }
                        }
                        if (FIELD.equals("position")) {
                            int[] pos = new int[3];
                            String[] s = DATA.split(":");
                            for (int i = 0; i < 3; ++i) {
                                pos[i] = Integer.parseInt(s[i].replaceAll(" ", ""));
                            }
                            if (s.length > 3) {
                                tData.setTravelRotation(Float.parseFloat(s[3].replaceAll(" ", "")));
                            }
                            if (pos[1] < 1) {
                                pos[1] = 1;
                            }
                            if (pos[1] > 255) {
                                pos[1] = 255;
                            }
                            tData.setTravelToLocation(new Vector3(pos[0], pos[1], pos[2]));
                        }
                        if (RESULT == EnumActionResult.SUCCESS) {
                            TardisSaveHandler.saveTardis(tData);
                        }
                    }
                }
            });
            return null;
        }
    }
}

