/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.init.skinpacks.skinpack;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@SideOnly(value=Side.CLIENT)
public class ModelSkinpackBase
extends ModelBase {
    public static final List<String> cubeTypes = Arrays.asList("d9e621f7-957f-4b77-b1ae-20dcd0da7751", "de81aa14-bd60-4228-8d8d-5238bcd3caaa");
    private String fileName;
    private Map<String, byte[]> zipContents = new HashMap<String, byte[]>();
    public Map<String, ModelRenderer> parts = new LinkedHashMap<String, ModelRenderer>();
    public BufferedImage image;
    private String texture = null;
    public boolean isAiming;

    public ModelSkinpackBase() {
    }

    public ModelSkinpackBase(ResourceLocation resource) throws Exception {
        this.fileName = resource.toString();
        IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(resource);
        this.loadTechneModel(res.func_110527_b());
        res.close();
    }

    public ModelSkinpackBase(InputStream stream) throws Exception {
        this.loadTechneModel(stream);
    }

    public void loadTechneModel(InputStream stream) throws Exception {
        try {
            ZipEntry entry;
            ZipInputStream zipInput = new ZipInputStream(stream);
            while ((entry = zipInput.getNextEntry()) != null) {
                byte[] data = new byte[(int)entry.getSize()];
                int i = 0;
                while (zipInput.available() > 0 && i < data.length) {
                    data[i++] = (byte)zipInput.read();
                }
                this.zipContents.put(entry.getName(), data);
            }
            byte[] modelXml = this.zipContents.get("model.xml");
            if (modelXml == null) {
                throw new Exception("Model " + this.fileName + " contains no model.xml file");
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(modelXml));
            NodeList nodeListTechne = document.getElementsByTagName("Techne");
            if (nodeListTechne.getLength() < 1) {
                throw new Exception("Model " + this.fileName + " contains no Techne tag");
            }
            NodeList nodeListModel = document.getElementsByTagName("Model");
            if (nodeListModel.getLength() < 1) {
                throw new Exception("Model " + this.fileName + " contains no Model tag");
            }
            NamedNodeMap modelAttributes = nodeListModel.item(0).getAttributes();
            if (modelAttributes == null) {
                throw new Exception("Model " + this.fileName + " contains a Model tag with no attributes");
            }
            Node modelTexture = modelAttributes.getNamedItem("texture");
            if (modelTexture != null) {
                this.texture = modelTexture.getTextContent();
            }
            NodeList textureSize = document.getElementsByTagName("TextureSize");
            for (int i = 0; i < textureSize.getLength(); ++i) {
                String size = textureSize.item(i).getTextContent();
                String[] textureDimensions = size.split(",");
                this.field_78090_t = Integer.parseInt(textureDimensions[0]);
                this.field_78089_u = Integer.parseInt(textureDimensions[1]);
            }
            NodeList shapes = document.getElementsByTagName("Shape");
            for (int i = 0; i < shapes.getLength(); ++i) {
                Node shape = shapes.item(i);
                NamedNodeMap shapeAttributes = shape.getAttributes();
                if (shapeAttributes == null) {
                    throw new Exception("Shape #" + (i + 1) + " in " + this.fileName + " has no attributes");
                }
                Node name = shapeAttributes.getNamedItem("name");
                String shapeName = null;
                if (name != null) {
                    shapeName = name.getNodeValue();
                }
                if (shapeName == null) {
                    shapeName = "Shape #" + (i + 1);
                }
                String shapeType = null;
                Node type = shapeAttributes.getNamedItem("type");
                if (type != null) {
                    shapeType = type.getNodeValue();
                }
                if (shapeType != null && !cubeTypes.contains(shapeType)) {
                    FMLLog.warning((String)("Model shape [" + shapeName + "] in " + this.fileName + " is not a cube, ignoring"), (Object[])new Object[0]);
                    continue;
                }
                try {
                    boolean mirrored = false;
                    String[] offset = new String[3];
                    String[] position = new String[3];
                    String[] rotation = new String[3];
                    String[] size = new String[3];
                    String[] textureOffset = new String[2];
                    NodeList shapeChildren = shape.getChildNodes();
                    for (int j = 0; j < shapeChildren.getLength(); ++j) {
                        Node shapeChild = shapeChildren.item(j);
                        String shapeChildName = shapeChild.getNodeName();
                        String shapeChildValue = shapeChild.getTextContent();
                        if (shapeChildValue == null) continue;
                        shapeChildValue = shapeChildValue.trim();
                        if (shapeChildName.equals("IsMirrored")) {
                            mirrored = !shapeChildValue.equals("False");
                            continue;
                        }
                        if (shapeChildName.equals("Offset")) {
                            offset = shapeChildValue.split(",");
                            continue;
                        }
                        if (shapeChildName.equals("Position")) {
                            position = shapeChildValue.split(",");
                            continue;
                        }
                        if (shapeChildName.equals("Rotation")) {
                            rotation = shapeChildValue.split(",");
                            continue;
                        }
                        if (shapeChildName.equals("Size")) {
                            size = shapeChildValue.split(",");
                            continue;
                        }
                        if (!shapeChildName.equals("TextureOffset")) continue;
                        textureOffset = shapeChildValue.split(",");
                    }
                    ModelRenderer cube = new ModelRenderer((ModelBase)this, shapeName);
                    cube.func_78784_a(Integer.parseInt(textureOffset[0]), Integer.parseInt(textureOffset[1]));
                    cube.field_78809_i = mirrored;
                    cube.func_78789_a(Float.parseFloat(offset[0]), Float.parseFloat(offset[1]), Float.parseFloat(offset[2]), Integer.parseInt(size[0]), Integer.parseInt(size[1]), Integer.parseInt(size[2]));
                    cube.func_78793_a(Float.parseFloat(position[0]), Float.parseFloat(position[1]) - 16.0f, Float.parseFloat(position[2]));
                    cube.field_78795_f = (float)Math.toRadians(Float.parseFloat(rotation[0]));
                    cube.field_78796_g = (float)Math.toRadians(Float.parseFloat(rotation[1]));
                    cube.field_78808_h = (float)Math.toRadians(Float.parseFloat(rotation[2]));
                    if (this.parts.containsKey(shapeName)) {
                        this.parts.put(shapeName + System.nanoTime(), cube);
                        continue;
                    }
                    this.parts.put(shapeName, cube);
                    continue;
                }
                catch (NumberFormatException e) {
                    FMLLog.warning((String)("Model shape [" + shapeName + "] in " + this.fileName + " contains malformed integers within its data, ignoring"), (Object[])new Object[0]);
                    e.printStackTrace();
                }
            }
        }
        catch (ZipException e) {
            throw new Exception("Model " + this.fileName + " is not a valid zip file");
        }
        catch (IOException e) {
            throw new Exception("Model " + this.fileName + " could not be read", e);
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException e) {
            throw new Exception("Model " + this.fileName + " contains invalid XML", e);
        }
        this.setTexture();
    }

    private void setTexture() throws Exception {
        if (this.texture != null) {
            try {
                byte[] textureEntry = this.zipContents.get(this.texture);
                this.image = textureEntry == null ? null : ImageIO.read(new ByteArrayInputStream(textureEntry));
            }
            catch (ZipException e) {
                throw new Exception("Model " + this.fileName + " is not a valid zip file");
            }
            catch (IOException e) {
                throw new Exception("Texture for model " + this.fileName + " could not be read", e);
            }
        }
    }

    private void setup() {
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
    }

    public void func_78088_a(Entity entity, float par1, float par2, float par3, float par4, float par5, float par6) {
        float var8 = this.field_78095_p;
        float i = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)var8) * (float)Math.PI * 2.0f)) * 0.2f;
        float headX = par4 / 57.295776f;
        float headY = par5 / 57.295776f;
        this.field_78093_q = entity.func_184218_aH();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-1.2f, (float)0.0f);
        this.setup();
        if (entity instanceof EntityPlayer) {
            ItemStack itemstack = ((EntityPlayer)entity).field_71071_by.func_70448_g();
            EnumAction enumaction = itemstack == null ? null : itemstack.func_77975_n();
            this.isAiming = enumaction != null && enumaction == EnumAction.BOW;
        }
        for (String partName : this.parts.keySet()) {
            float var9;
            ModelRenderer part = this.parts.get(partName);
            if (partName.contains("_head")) {
                part.field_78796_g = par4 / 57.295776f;
                part.field_78795_f = par5 / 57.295776f;
                if (entity.func_70093_af()) {
                    part.field_78797_d = 1.0f;
                    part.field_78797_d = 1.0f;
                } else {
                    part.field_78797_d = 0.0f;
                    part.field_78797_d = 0.0f;
                }
            }
            if (partName.contains("_body")) {
                part.field_78796_g = this.field_78095_p > -9990.0f ? MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)var8) * (float)Math.PI * 2.0f)) * 0.2f : 0.0f;
            }
            if (partName.contains("_leftLeg")) {
                part.field_78795_f = MathHelper.func_76134_b((float)(par1 * 0.6662f + (float)Math.PI)) * 1.4f * par2;
                part.field_78796_g = 0.0f;
                if (this.field_78093_q) {
                    part.field_78795_f = -1.2566371f;
                    part.field_78796_g = -0.31415927f;
                }
                if (entity.func_70093_af()) {
                    part.field_78798_e = 4.0f;
                    part.field_78797_d = 9.0f;
                } else {
                    part.field_78798_e = 0.1f;
                    part.field_78797_d = 12.0f;
                }
            }
            if (partName.contains("_RightLeg")) {
                part.field_78795_f = MathHelper.func_76134_b((float)(par1 * 0.6662f)) * 1.4f * par2;
                part.field_78796_g = 0.0f;
                if (this.field_78093_q) {
                    part.field_78795_f = -1.2566371f;
                    part.field_78796_g = 0.31415927f;
                }
                if (entity.func_70093_af()) {
                    part.field_78798_e = 4.0f;
                    part.field_78797_d = 9.0f;
                } else {
                    part.field_78798_e = 0.1f;
                    part.field_78797_d = 12.0f;
                }
            }
            if (partName.contains("_leftArm")) {
                part.field_78795_f = MathHelper.func_76134_b((float)(par1 * 0.6662f)) * 2.0f * par2 * 0.5f;
                part.field_78808_h = 0.0f;
                if (this.field_78093_q) {
                    part.field_78795_f += -0.62831855f;
                }
                part.field_78796_g = 0.0f;
                if (this.field_78095_p > -9990.0f) {
                    part.field_78798_e = -MathHelper.func_76126_a((float)i) * 5.0f;
                    part.field_78800_c = MathHelper.func_76134_b((float)i) * 5.0f;
                    part.field_78796_g += i;
                    part.field_78795_f += i;
                }
                if (entity.func_70093_af()) {
                    i = 0.5f;
                    part.field_78795_f += 0.4f;
                } else {
                    i = 0.0f;
                }
                part.field_78808_h -= MathHelper.func_76134_b((float)(par3 * 0.09f)) * 0.05f + 0.05f;
                part.field_78795_f -= MathHelper.func_76126_a((float)(par3 * 0.067f)) * 0.05f;
                var8 = 0.0f;
                var9 = 0.0f;
                part.field_78808_h = 0.0f;
                part.field_78796_g = 0.1f - var8 * 0.6f + headY + 0.4f;
                part.field_78795_f = -1.5707964f + headX;
                part.field_78795_f -= var8 * 1.2f - var9 * 0.4f;
                part.field_78808_h -= MathHelper.func_76134_b((float)(par3 * 0.09f)) * 0.05f + 0.05f;
                part.field_78795_f -= MathHelper.func_76126_a((float)(par3 * 0.067f)) * 0.05f;
            }
            if (partName.contains("_rightArm")) {
                part.field_78795_f = MathHelper.func_76134_b((float)(par1 * 0.6662f + (float)Math.PI)) * 2.0f * par2 * 0.5f;
                part.field_78808_h = 0.0f;
                if (this.field_78093_q) {
                    part.field_78795_f += -0.62831855f;
                }
                part.field_78796_g = 0.0f;
                if (this.field_78095_p > -9990.0f) {
                    part.field_78798_e = MathHelper.func_76126_a((float)i) * 5.0f;
                    part.field_78800_c = -MathHelper.func_76134_b((float)i) * 5.0f;
                    part.field_78796_g += i;
                    var8 = 1.0f - this.field_78095_p;
                    var8 *= var8;
                    var8 *= var8;
                    var8 = 1.0f - var8;
                    var9 = MathHelper.func_76126_a((float)(var8 * (float)Math.PI));
                    float var10 = MathHelper.func_76126_a((float)(this.field_78095_p * (float)Math.PI)) * -(headX - 0.7f) * 0.75f;
                    part.field_78795_f = (float)((double)part.field_78795_f - ((double)var9 * 1.2 + (double)var10));
                    part.field_78796_g += i * 2.0f;
                    part.field_78808_h = MathHelper.func_76126_a((float)(this.field_78095_p * (float)Math.PI)) * -0.4f;
                }
                if (entity.func_70093_af()) {
                    i = 0.5f;
                    part.field_78795_f += 0.4f;
                } else {
                    i = 0.0f;
                }
                part.field_78808_h += MathHelper.func_76134_b((float)(par3 * 0.09f)) * 0.05f + 0.05f;
                part.field_78795_f += MathHelper.func_76126_a((float)(par3 * 0.067f)) * 0.05f;
                if (this.isAiming) {
                    var8 = 0.0f;
                    var9 = 0.0f;
                    part.field_78808_h = 0.0f;
                    part.field_78796_g = -(0.1f - var8 * 0.6f) + headY;
                    part.field_78795_f = -1.5707964f + headX;
                    part.field_78795_f -= var8 * 1.2f - var9 * 0.4f;
                    part.field_78808_h += MathHelper.func_76134_b((float)(par3 * 0.09f)) * 0.05f + 0.05f;
                    part.field_78795_f += MathHelper.func_76126_a((float)(par3 * 0.067f)) * 0.05f;
                }
            }
            part.func_78791_b(par6);
        }
        GlStateManager.func_179121_F();
        super.func_78088_a(entity, par1, par2, par3, par4, par5, par6);
    }
}

