/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.entity;

import com.swdteam.common.entity.ai.DalekLaserAttack;
import com.swdteam.common.entity.dalek.EntityDalek;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityHoverbout
extends EntityFlying
implements IMob {
    public EntityHoverbout(World worldIn) {
        super(worldIn);
        this.func_70105_a(3.0f, 0.8f);
        this.field_70178_ae = true;
        this.field_70728_aV = 5;
        this.field_70765_h = new HoverboutMoveHelper(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AILookAround(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AILaserAttack(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityDalek dalek;
            if (this.func_184188_bt() != null && this.func_184188_bt().size() <= 0) {
                dalek = new EntityDalek(this.func_130014_f_());
                dalek.func_82149_j((Entity)this);
                dalek.func_94061_f(true);
                this.field_70170_p.func_72838_d((Entity)dalek);
                dalek.func_184205_a((Entity)this, true);
            }
            dalek = (EntityDalek)((Object)this.func_184188_bt().get(0));
            dalek.func_82149_j((Entity)this);
            dalek.field_70759_as = this.field_70759_as;
            dalek.field_70125_A = this.field_70125_A;
            dalek.field_70177_z = this.field_70177_z;
        }
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public void func_70030_z() {
        super.func_70030_z();
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        Entity e = damageSrc.func_76346_g();
        if (e != null && this.func_180425_c().func_177954_c(e.field_70165_t, e.field_70163_u, e.field_70161_v) > 5.0) {
            this.field_70765_h.func_75642_a(e.field_70165_t, e.field_70163_u, e.field_70161_v, 1.0);
            if (e instanceof EntityLivingBase) {
                this.func_70624_b((EntityLivingBase)e);
            }
        }
        super.func_70665_d(damageSrc, damageAmount);
    }

    public boolean func_82171_bF() {
        return false;
    }

    public boolean func_184186_bw() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(256.0);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187602_cF;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public int func_70641_bl() {
        return 3;
    }

    public void func_70106_y() {
        List riding = this.func_184188_bt();
        if (riding != null && riding.size() > 0 && riding.get(0) instanceof EntityDalek) {
            ((Entity)riding.get(0)).func_70106_y();
        }
        super.func_70106_y();
    }

    public static void registerFixesHoverbout(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityHoverbout.class);
    }

    static class AILaserAttack
    extends EntityAIBase {
        private final EntityHoverbout parentEntity;
        public int attackTimer;

        public AILaserAttack(EntityHoverbout entityHoverbout) {
            this.parentEntity = entityHoverbout;
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            double d0 = 64.0;
            if (this.attackTimer == 10) {
                this.parentEntity.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.0);
            }
            if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 1024.0 && this.parentEntity.func_70685_l((Entity)entitylivingbase)) {
                World world = this.parentEntity.field_70170_p;
                ++this.attackTimer;
                if (this.attackTimer == 20) {
                    List riding = this.parentEntity.func_184188_bt();
                    if (riding != null && riding.size() > 0 && riding.get(0) instanceof EntityDalek) {
                        EntityDalek dalek = (EntityDalek)((Object)riding.get(0));
                        double dd0 = dalek.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
                        float f = MathHelper.func_76133_a((double)dd0) / ((DalekLaserAttack)dalek.aiLaserAttack).attackRadius;
                        float lvt_5_1_ = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
                        if (dalek.getDalekData() != null) {
                            dalek.getDalekData().onLaserAttack(dalek, entitylivingbase, lvt_5_1_);
                        }
                    }
                    this.attackTimer = -40;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
        }
    }

    static class HoverboutMoveHelper
    extends EntityMoveHelper {
        private final EntityHoverbout parentEntity;
        private int courseChangeCooldown;

        public HoverboutMoveHelper(EntityHoverbout cd) {
            super((EntityLiving)cd);
            this.parentEntity = cd;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                double d1 = this.field_75647_c - this.parentEntity.field_70163_u;
                double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                    if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                        this.parentEntity.field_70159_w += d0 / d3 * 0.1;
                        this.parentEntity.field_70181_x += d1 / d3 * 0.1;
                        this.parentEntity.field_70179_y += d2 / d3 * 0.1;
                    } else {
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - this.parentEntity.field_70165_t) / p_179926_7_;
            double d1 = (y - this.parentEntity.field_70163_u) / p_179926_7_;
            double d2 = (z - this.parentEntity.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class AIRandomFly
    extends EntityAIBase {
        private final EntityHoverbout parentEntity;

        public AIRandomFly(EntityHoverbout Hoverbout) {
            this.parentEntity = Hoverbout;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }

    static class AILookAround
    extends EntityAIBase {
        private final EntityHoverbout parentEntity;

        public AILookAround(EntityHoverbout Hoverbout) {
            this.parentEntity = Hoverbout;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)this.parentEntity.field_70159_w, (double)this.parentEntity.field_70179_y)) * 57.295776f;
            } else {
                EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
                double d0 = 64.0;
                if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4096.0) {
                    double d1 = entitylivingbase.field_70165_t - this.parentEntity.field_70165_t;
                    double d2 = entitylivingbase.field_70161_v - this.parentEntity.field_70161_v;
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }
}

