/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.item;

import com.swdteam.common.capability.CapabilityRegeneration;
import com.swdteam.common.capability.interfaces.IRegenerationCapability;
import com.swdteam.utils.PlayerUtils;
import java.awt.TextField;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemFobWatch
extends Item {
    public ItemFobWatch() {
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        IRegenerationCapability capa = (IRegenerationCapability)playerIn.getCapability(CapabilityRegeneration.REGEN_CAP, null);
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("regen_fob_storage", 0);
        }
        int fob = stack.func_77978_p().func_74762_e("regen_fob_storage");
        int response = 7;
        if (capa.getTicksExisted() <= 0) {
            if (!playerIn.func_70093_af()) {
                if (capa.canPlayerRegenerate() && capa.getRegenAmount() != 0) {
                    if (fob == 0) {
                        fob = capa.getRegenAmount();
                        capa.setRegenCount(0);
                        response = 0;
                    } else if (fob < 12) {
                        ++fob;
                        if (capa.getRegenAmount() - 1 >= 0) {
                            capa.setRegenCount(capa.getRegenAmount() - 1);
                        }
                        response = 1;
                    } else {
                        response = 2;
                    }
                }
            } else {
                if (capa.getRegenAmount() == 12) {
                    response = 3;
                }
                if (capa.getRegenAmount() == 0) {
                    capa.setCanRegen(true);
                    capa.setRegenCount(fob);
                    fob = 0;
                    response = 4;
                }
                if (capa.canPlayerRegenerate() && fob > 0 && capa.getRegenAmount() != 12) {
                    capa.setRegenCount(capa.getRegenAmount() + 1);
                    --fob;
                    response = 5;
                }
                if (fob == 0) {
                    response = 6;
                }
                if (fob >= 0 && !capa.canPlayerRegenerate()) {
                    capa.setCanRegen(true);
                }
            }
            capa.syncToPlayer();
            PlayerUtils.Messaging.sendStatusTranslationMessageToPlayer(playerIn, this.getResponse(response), true);
            stack.func_77978_p().func_74768_a("regen_fob_storage", fob);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private String getResponse(int response) {
        switch (response) {
            case 0: {
                return "message.fob.storedall";
            }
            case 1: {
                return "message.fob.transfertofob";
            }
            case 2: {
                return "message.fob.full";
            }
            case 3: {
                return "message.fob.regenerationfull";
            }
            case 4: {
                return "message.fob.alltransfered";
            }
            case 5: {
                return "message.fob.addedregen";
            }
            case 6: {
                return "message.fob.empty";
            }
            case 7: {
                return "";
            }
        }
        return "";
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int fob = 0;
        if (stack.func_77942_o()) {
            fob = stack.func_77978_p().func_74762_e("regen_fob_storage");
        }
        tooltip.add(new TextField("Stored: " + fob).getText());
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean func_179215_a(NBTTagCompound nbt) {
        return super.func_179215_a(nbt);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }
}

