/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.world.gen.biomes;

import com.swdteam.common.init.DMBlocks;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMelon;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenVines;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeGenAlienJungle
extends Biome {
    private static final IBlockState JUNGLE_LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
    private static final IBlockState JUNGLE_LEAF = DMBlocks.varos_leaves.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private static final IBlockState OAK_LEAF = DMBlocks.varos_leaves.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));

    public BiomeGenAlienJungle(Biome.BiomeProperties properties) {
        super(properties);
        this.field_76760_I.field_76832_z = 50;
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.modSpawnableLists.clear();
    }

    public int func_180627_b(BlockPos pos) {
        return this.getModdedBiomeGrassColor(15884085);
    }

    public int func_180625_c(BlockPos pos) {
        return this.getModdedBiomeFoliageColor(15884085);
    }

    public List<Biome.SpawnListEntry> func_76747_a(EnumCreatureType creatureType) {
        switch (creatureType) {
            case MONSTER: {
                return this.field_76762_K;
            }
            case CREATURE: {
                return this.field_76762_K;
            }
            case WATER_CREATURE: {
                return this.field_76762_K;
            }
            case AMBIENT: {
                return this.field_76762_K;
            }
        }
        return this.field_76762_K;
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        if (rand.nextInt(10) == 0) {
            return field_76758_O;
        }
        if (rand.nextInt(2) == 0) {
            return new WorldGenShrub(JUNGLE_LOG, OAK_LEAF);
        }
        return rand.nextInt(3) == 0 ? new WorldGenMegaJungle(false, 10, 20, JUNGLE_LOG, JUNGLE_LEAF) : new WorldGenTrees(false, 4 + rand.nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, true);
    }

    public WorldGenerator func_76730_b(Random rand) {
        return rand.nextInt(4) == 0 ? new WorldGenTallGrass(BlockTallGrass.EnumType.FERN) : new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        int k;
        super.func_180624_a(worldIn, rand, pos);
        int i = rand.nextInt(16) + 8;
        int j = rand.nextInt(16) + 8;
        int height = worldIn.func_175645_m(pos.func_177982_a(i, 0, j)).func_177956_o() * 2;
        if (height < 1) {
            height = 1;
        }
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (BlockPos)pos.func_177982_a(i, k = rand.nextInt(height), j), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.PUMPKIN)) {
            new WorldGenMelon().func_180709_b(worldIn, rand, pos.func_177982_a(i, k, j));
        }
        WorldGenVines worldgenvines = new WorldGenVines();
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS)) {
            for (int j1 = 0; j1 < 50; ++j1) {
                k = rand.nextInt(16) + 8;
                int l = 128;
                int i1 = rand.nextInt(16) + 8;
                worldgenvines.func_180709_b(worldIn, rand, pos.func_177982_a(k, 128, i1));
            }
        }
    }
}

