/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.gui.vortex.waypoints;

import com.swdteam.client.gui.vortex.waypoints.Waypoint;
import com.swdteam.client.gui.vortex.waypoints.packets.Packet_RequestVMWaypoints;
import com.swdteam.client.gui.vortex.waypoints.packets.Packet_VMActions;
import com.swdteam.main.TheDalekMod;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.utils.DataManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.FMLInjectionData;

public class WaypointInformation {
    public List<Waypoint> waypoints = new ArrayList<Waypoint>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WaypointInformation initWaypoints(String name) throws IOException {
        WaypointInformation waypointInformation = new WaypointInformation();
        File file = new File(((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/VM_Data/Waypoints/" + name + "/");
        if (!file.exists()) {
            file.mkdirs();
        }
        for (File fileEntry : file.listFiles()) {
            if (fileEntry.isDirectory() || !fileEntry.getName().toLowerCase().endsWith(".wpt")) continue;
            String content = "";
            try (BufferedReader br = new BufferedReader(new FileReader(fileEntry.getAbsoluteFile()));){
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                while (true) {
                    if (line == null) {
                        content = sb.toString();
                        break;
                    }
                    sb.append(line);
                    sb.append("\n");
                    line = br.readLine();
                }
            }
            try {
                Waypoint point = new Waypoint();
                point.setName(DataManager.getTag(content, "name"));
                point.setDimension(Integer.parseInt(DataManager.getTag(content, "dimension")));
                point.setX(Integer.parseInt(DataManager.getTag(content, "x")));
                point.setY(Integer.parseInt(DataManager.getTag(content, "y")));
                point.setZ(Integer.parseInt(DataManager.getTag(content, "z")));
                point.setBiome(DataManager.getTag(content, "biome"));
                point.setCreated(DataManager.getTag(content, "created"));
                point.setFileLocation(fileEntry);
                waypointInformation.waypoints.add(point);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return waypointInformation;
    }

    public static void requestWaypointInfo() {
        PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_RequestVMWaypoints());
    }

    public static void sendActionToServer(String action, String arg) {
        PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_VMActions(action, arg));
    }

    public static void addWaypoint(Waypoint point) {
        WaypointInformation.addWaypoint(point.getName(), point.getUser(), point.getX(), point.getY(), point.getZ(), point.getDimension(), point.getCreated(), point.getBiome());
    }

    public static void addWaypoint(String pointName, String uuid, int x, int y, int z, int dimID, String created, String biome) {
        File file2;
        File file = new File(((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/VM_Data/Waypoints/" + uuid + "/");
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file2 = new File(file.getAbsolutePath() + "/waypoint-" + (file.listFiles().length + 1) + ".wpt")).exists()) {
            try {
                file2.createNewFile();
            }
            catch (IOException var12) {
                var12.printStackTrace();
            }
        }
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file.getAbsoluteFile() + "/" + file2.getName(), true)));
            out.println("<waypoint>");
            out.println("<name>" + pointName + "</name>");
            out.println("<dimension>" + dimID + "</dimension>");
            out.println("<x>" + x + "</x>");
            out.println("<y>" + y + "</y>");
            out.println("<z>" + z + "</z>");
            out.println("<created>" + created + "</created>");
            out.println("<biome>" + biome + "</biome>");
            out.println("</waypoint>");
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

