/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.worldportal.packet;

import com.swdteam.client.worldportal.CustomWorldClient;
import com.swdteam.client.worldportal.IWorldPortal;
import com.swdteam.client.worldportal.WorldPortal;
import com.swdteam.client.worldportal.WorldRender;
import com.swdteam.client.worldportal.WorldRenderData;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketWorldPortal
implements IMessage {
    public BlockPos pos;
    public WorldRender worldPortal;

    public PacketWorldPortal() {
    }

    public PacketWorldPortal(WorldRender portal, BlockPos blockPos) {
        this.pos = blockPos;
        this.worldPortal = portal;
    }

    @SideOnly(value=Side.CLIENT)
    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        if (buf.readableBytes() > 0) {
            PacketBuffer pb = new PacketBuffer(buf);
            ByteArrayInputStream ins = new ByteArrayInputStream(pb.func_179251_a());
            try {
                ObjectInputStream ois = new ObjectInputStream(ins);
                Object o = ois.readObject();
                if (o instanceof WorldRenderData) {
                    this.worldPortal = new WorldRender();
                    this.worldPortal.setRenderData((WorldRenderData)o);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.worldPortal = null;
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        if (this.worldPortal != null) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(this.worldPortal.renderData);
                oos.close();
                PacketBuffer pb = new PacketBuffer(buf);
                pb.func_179250_a(bos.toByteArray());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class Handler
    implements IMessageHandler<PacketWorldPortal, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(final PacketWorldPortal message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    WorldClient world;
                    TileEntity tileEntity;
                    if (message.worldPortal != null && (tileEntity = (world = Minecraft.func_71410_x().field_71441_e).func_175625_s(message.pos)) != null && tileEntity instanceof IWorldPortal) {
                        IWorldPortal worldPortal = (IWorldPortal)tileEntity;
                        if (message.worldPortal.client == null) {
                            message.worldPortal.client = new CustomWorldClient(Minecraft.func_71410_x().field_71441_e, worldPortal.getDimension(), message.worldPortal.renderData.worldTime);
                        }
                        message.worldPortal.finalize(message.pos);
                        WorldPortal.initTiles(message.worldPortal);
                        worldPortal.setWorldRender(message.worldPortal);
                        tileEntity.func_70296_d();
                    }
                }
            });
            return null;
        }
    }
}

