/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.entity;

import com.swdteam.common.entity.DMEntityUtils;
import com.swdteam.common.init.DMItems;
import com.swdteam.common.init.DMSounds;
import com.swdteam.utils.DMUtils;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityJudoon
extends EntityZombie {
    public static final DataParameter<Boolean> HELMET = EntityDataManager.func_187226_a(EntityJudoon.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final UUID ATTACK_SPEED_BOOST_MODIFIER_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier ATTACK_SPEED_BOOST_MODIFIER = new AttributeModifier(ATTACK_SPEED_BOOST_MODIFIER_UUID, "Attacking speed boost", 0.05, 0).func_111168_a(false);
    private int angerLevel;
    private int randomSoundDelay;
    private UUID angerTargetUUID;

    public EntityJudoon(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
    }

    public void func_70604_c(@Nullable EntityLivingBase livingBase) {
        super.func_70604_c(livingBase);
        if (livingBase != null) {
            this.angerTargetUUID = livingBase.func_110124_au();
        }
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        this.func_145779_a(DMItems.iAMMO, this.func_70681_au().nextInt(6));
        if (DMUtils.RANDOM.nextInt(3) == 1) {
            this.func_145779_a(DMItems.radiationPill, 1);
        }
        DMEntityUtils.dropRareItem((EntityLiving)this, DMItems.JUDOON_BLASTER, 30, 2);
        super.func_70628_a(wasRecentlyHit, lootingModifier);
    }

    protected boolean func_146066_aG() {
        return true;
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIHurtByAggressor(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AITargetAggressor(this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(field_110186_bp).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    protected void func_70619_bc() {
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (this.isAngry()) {
            if (!this.func_70631_g_() && !iattributeinstance.func_180374_a(ATTACK_SPEED_BOOST_MODIFIER)) {
                iattributeinstance.func_111121_a(ATTACK_SPEED_BOOST_MODIFIER);
            }
            --this.angerLevel;
        } else if (iattributeinstance.func_180374_a(ATTACK_SPEED_BOOST_MODIFIER)) {
            iattributeinstance.func_111124_b(ATTACK_SPEED_BOOST_MODIFIER);
        }
        if (this.randomSoundDelay > 0 && --this.randomSoundDelay == 0) {
            this.func_184185_a(DMSounds.judoon_2, this.func_70599_aP() * 2.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 1.8f);
        }
        if (this.angerLevel > 0 && this.angerTargetUUID != null && this.func_70643_av() == null) {
            EntityPlayer entityplayer = this.field_70170_p.func_152378_a(this.angerTargetUUID);
            this.func_70604_c((EntityLivingBase)entityplayer);
            this.field_70717_bb = entityplayer;
            this.field_70718_bc = this.func_142015_aE();
        }
        super.func_70619_bc();
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74777_a("Anger", (short)this.angerLevel);
        if (this.angerTargetUUID != null) {
            compound.func_74778_a("HurtBy", this.angerTargetUUID.toString());
        } else {
            compound.func_74778_a("HurtBy", "");
        }
        compound.func_74757_a("helmet", ((Boolean)this.func_184212_Q().func_187225_a(HELMET)).booleanValue());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.angerLevel = compound.func_74765_d("Anger");
        String s = compound.func_74779_i("HurtBy");
        if (!s.isEmpty()) {
            this.angerTargetUUID = UUID.fromString(s);
            EntityPlayer entityplayer = this.field_70170_p.func_152378_a(this.angerTargetUUID);
            this.func_70604_c((EntityLivingBase)entityplayer);
            if (entityplayer != null) {
                this.field_70717_bb = entityplayer;
                this.field_70718_bc = this.func_142015_aE();
            }
        }
        if (compound.func_74764_b("helmet")) {
            this.func_184212_Q().func_187227_b(HELMET, (Object)compound.func_74767_n("helmet"));
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityPlayer) {
            this.becomeAngryAt(entity);
        }
        return super.func_70097_a(source, amount);
    }

    private void becomeAngryAt(Entity p_70835_1_) {
        this.angerLevel = 400 + this.field_70146_Z.nextInt(400);
        this.randomSoundDelay = this.field_70146_Z.nextInt(60);
        if (p_70835_1_ instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)p_70835_1_);
        }
    }

    public boolean isAngry() {
        return this.angerLevel > 0;
    }

    protected SoundEvent func_184639_G() {
        return DMSounds.judoon_2;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return DMSounds.judoon_1;
    }

    protected SoundEvent func_184615_bR() {
        return DMSounds.judoon_3;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return false;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151010_B));
    }

    public boolean func_191990_c(EntityPlayer playerIn) {
        return this.isAngry();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(HELMET, (Object)false);
        this.field_70180_af.func_187227_b(HELMET, (Object)this.field_70170_p.field_73012_v.nextBoolean());
    }

    static class AITargetAggressor
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        public AITargetAggressor(EntityJudoon p_i45829_1_) {
            super((EntityCreature)p_i45829_1_, EntityPlayer.class, true);
        }

        public boolean func_75250_a() {
            return ((EntityJudoon)this.field_75299_d).isAngry() && super.func_75250_a();
        }
    }

    static class AIHurtByAggressor
    extends EntityAIHurtByTarget {
        public AIHurtByAggressor(EntityJudoon p_i45828_1_) {
            super((EntityCreature)p_i45828_1_, true, new Class[0]);
        }

        protected void func_179446_a(EntityCreature creatureIn, EntityLivingBase entityLivingBaseIn) {
            super.func_179446_a(creatureIn, entityLivingBaseIn);
            if (creatureIn instanceof EntityJudoon) {
                ((EntityJudoon)creatureIn).becomeAngryAt((Entity)entityLivingBaseIn);
            }
        }
    }
}

