/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.gui.tardis;

import com.swdteam.client.data.ClientTardisCache;
import com.swdteam.client.gui.elements.GuiButtonImage;
import com.swdteam.client.gui.tardis.GuiElementNote;
import com.swdteam.client.gui.tardis.screens.ITardisScreen;
import com.swdteam.client.gui.tardis.screens.TardisScreenAddWaypoint;
import com.swdteam.client.gui.tardis.screens.TardisScreenCompanions;
import com.swdteam.client.gui.tardis.screens.TardisScreenCoordTravel;
import com.swdteam.client.gui.tardis.screens.TardisScreenEditWaypoint;
import com.swdteam.client.gui.tardis.screens.TardisScreenSettings;
import com.swdteam.client.gui.tardis.screens.TardisScreenSkinSelection;
import com.swdteam.client.gui.tardis.screens.TardisScreenStatus;
import com.swdteam.client.gui.tardis.screens.TardisScreenWaypointSelection;
import com.swdteam.common.init.DMSounds;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tileentity.tardis.TileEntityMonitorBase;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_SaveNotes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiTardisMonitorNew
extends GuiScreen {
    public TardisMonitorScreen currentScreen = TardisMonitorScreen.STATUS;
    public TardisData data;
    public float notePickupOffsetX;
    public float notePickupOffsetY;
    public static GuiElementNote EDITING_NOTE;
    public static GuiElementNote SELECTED_NOTE;
    public static List<GuiElementNote> NOTES;
    public static TardisMonitorFrame MONITOR_FRAME;
    public List<String> tooltips = new ArrayList<String>();
    public int frame = 0;
    public static ResourceLocation STAR_BG;
    private TileEntityMonitorBase tile;

    public GuiTardisMonitorNew(TileEntityMonitorBase tile) {
        NOTES.clear();
        MONITOR_FRAME = tile.getFrame();
        this.tile = tile;
        for (int i = 0; i < tile.notes.size(); ++i) {
            TileEntityMonitorBase.StickyNote note = tile.notes.get(i);
            NOTES.add(new GuiElementNote(note.lines, note.x, note.y));
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.setupButtons();
        this.currentScreen.screen.init(this);
    }

    public void setupButtons() {
        this.field_146292_n.add(new GuiButtonImage(0, this.field_146294_l / 2 - 110, this.field_146295_m / 2 + 50, 20, 96).setTooltip("TARDIS Status"));
        this.field_146292_n.add(new GuiButtonImage(1, this.field_146294_l / 2 - 86, this.field_146295_m / 2 + 50, 40, 96).setTooltip("Coordinate Travel"));
        this.field_146292_n.add(new GuiButtonImage(2, this.field_146294_l / 2 - 62, this.field_146295_m / 2 + 50, 60, 96).setTooltip("Chameleon Circuit"));
        this.field_146292_n.add(new GuiButtonImage(3, this.field_146294_l / 2 - 38, this.field_146295_m / 2 + 50, 0, 96).setTooltip("Waypoints"));
        this.field_146292_n.add(new GuiButtonImage(4, this.field_146294_l / 2 - 14, this.field_146295_m / 2 + 50, 80, 96).setTooltip("Settings"));
        this.field_146292_n.add(new GuiButtonImage(5, this.field_146294_l - 24, 4, 160, 40).setTooltip("Add Sticky Note"));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i;
        this.data = ClientTardisCache.getTardisData(this.field_146297_k.field_71439_g.func_180425_c());
        this.func_146276_q_();
        this.field_146297_k.field_71446_o.func_110577_a(STAR_BG);
        GuiTardisMonitorNew.func_146110_a((int)(this.field_146294_l / 2 - 120), (int)(this.field_146295_m / 2 - 80), (float)(this.frame % 7 * 240), (float)(this.frame / 7 * 160), (int)240, (int)160, (float)1680.0f, (float)1120.0f);
        this.currentScreen.screen.render(this, mouseX, mouseY, partialTicks);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        this.field_146297_k.field_71446_o.func_110577_a(GuiTardisMonitorNew.MONITOR_FRAME.texture);
        GuiTardisMonitorNew.func_146110_a((int)(this.field_146294_l / 2 - GuiTardisMonitorNew.MONITOR_FRAME.width / 2), (int)(this.field_146295_m / 2 - GuiTardisMonitorNew.MONITOR_FRAME.height / 2), (float)0.0f, (float)0.0f, (int)GuiTardisMonitorNew.MONITOR_FRAME.width, (int)GuiTardisMonitorNew.MONITOR_FRAME.height, (float)GuiTardisMonitorNew.MONITOR_FRAME.width, (float)GuiTardisMonitorNew.MONITOR_FRAME.height);
        GL11.glDisable((int)3042);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton button = (GuiButton)this.field_146292_n.get(i);
            if (!(button instanceof GuiButtonImage) || !button.func_146115_a()) continue;
            this.tooltips.add(((GuiButtonImage)button).getToolTip());
        }
        if (SELECTED_NOTE != null) {
            GuiTardisMonitorNew.SELECTED_NOTE.renderX = (float)(mouseX - this.field_146294_l / 2) + this.notePickupOffsetX;
            GuiTardisMonitorNew.SELECTED_NOTE.renderY = (float)(mouseY - this.field_146295_m / 2) + this.notePickupOffsetY;
        }
        for (i = 0; i < NOTES.size(); ++i) {
            NOTES.get(i).render(mouseX, mouseY, this);
        }
        this.func_146283_a(this.tooltips, mouseX, mouseY);
        this.tooltips.clear();
    }

    public void func_73876_c() {
        this.frame = this.frame + 1 >= 49 ? 0 : ++this.frame;
        for (int i = 0; i < NOTES.size(); ++i) {
            NOTES.get(i).update(this);
        }
        this.currentScreen.screen.update(this);
        this.currentScreen.screen.btnTick();
        super.func_73876_c();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 5) {
            if (NOTES.size() < 10) {
                NOTES.add(new GuiElementNote(new String[0], -64 + this.field_146297_k.field_71441_e.field_73012_v.nextInt(128), -64 + this.field_146297_k.field_71441_e.field_73012_v.nextInt(128)));
                this.field_146297_k.field_71441_e.func_184148_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71439_g.field_70165_t, this.field_146297_k.field_71439_g.field_70163_u, this.field_146297_k.field_71439_g.field_70161_v, DMSounds.PAPER_PICKUP, SoundCategory.MASTER, 1.0f, 1.0f);
            } else {
                this.field_146297_k.field_71439_g.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Maximum number of notes reached"), false);
            }
        }
        if (button.field_146127_k == 0) {
            this.changeScreen(TardisMonitorScreen.STATUS);
        }
        if (button.field_146127_k == 1) {
            this.changeScreen(TardisMonitorScreen.COORD_TRAVEL);
        }
        if (button.field_146127_k == 2) {
            this.changeScreen(TardisMonitorScreen.SKIN);
        }
        if (button.field_146127_k == 3) {
            this.changeScreen(TardisMonitorScreen.WAYPOINTS);
        }
        if (button.field_146127_k == 4) {
            this.changeScreen(TardisMonitorScreen.SETTINGS);
        }
        if (this.currentScreen.screen.getWait() >= 5) {
            this.currentScreen.screen.actionPerformed(this, button);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        boolean notesClicked = false;
        boolean notesEditClick = false;
        for (int i = NOTES.size() - 1; i >= 0; --i) {
            GuiElementNote note = NOTES.get(i);
            if (!((float)mouseX > (float)(this.field_146294_l / 2) + note.posX) || !((float)mouseX < (float)(this.field_146294_l / 2) + note.posX + 64.0f) || !((float)mouseY > (float)(this.field_146295_m / 2) + note.posY) || !((float)mouseY < (float)(this.field_146295_m / 2) + note.posY + 64.0f)) continue;
            if (mouseButton == 0) {
                NOTES.remove(i);
                NOTES.add(note);
                this.field_146297_k.field_71441_e.func_184148_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71439_g.field_70165_t, this.field_146297_k.field_71439_g.field_70163_u, this.field_146297_k.field_71439_g.field_70161_v, DMSounds.PAPER_PICKUP, SoundCategory.MASTER, 1.0f, 1.0f);
                this.notePickupOffsetX = (float)(this.field_146294_l / 2) + note.posX - (float)mouseX;
                this.notePickupOffsetY = (float)(this.field_146295_m / 2) + note.posY - (float)mouseY;
                SELECTED_NOTE = note;
                notesClicked = true;
                break;
            }
            if (mouseButton == 1) {
                boolean bl = note.editMode = !note.editMode;
                if (note.editMode) {
                    if (EDITING_NOTE != null) {
                        GuiTardisMonitorNew.EDITING_NOTE.editMode = false;
                        GuiTardisMonitorNew.EDITING_NOTE.editingLine = 0;
                    }
                    EDITING_NOTE = note;
                } else {
                    EDITING_NOTE = null;
                }
                NOTES.remove(i);
                NOTES.add(note);
                this.saveNotes();
                notesClicked = true;
                notesEditClick = true;
                break;
            }
            if (mouseButton != 2) continue;
            NOTES.remove(i);
            this.field_146297_k.field_71441_e.func_184148_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71439_g.field_70165_t, this.field_146297_k.field_71439_g.field_70163_u, this.field_146297_k.field_71439_g.field_70161_v, DMSounds.PAPER_PLACE, SoundCategory.MASTER, 1.0f, 1.0f);
            notesClicked = true;
            this.saveNotes();
        }
        if (!notesClicked && EDITING_NOTE != null) {
            if (EDITING_NOTE != null) {
                GuiTardisMonitorNew.EDITING_NOTE.editMode = false;
            }
            EDITING_NOTE = null;
            this.saveNotes();
        }
        if (!notesEditClick) {
            this.currentScreen.screen.mouseClicked(this, mouseButton, mouseX, mouseY);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (SELECTED_NOTE != null) {
            GuiTardisMonitorNew.SELECTED_NOTE.posX = GuiTardisMonitorNew.SELECTED_NOTE.renderX;
            GuiTardisMonitorNew.SELECTED_NOTE.posY = GuiTardisMonitorNew.SELECTED_NOTE.renderY;
            SELECTED_NOTE = null;
            this.field_146297_k.field_71441_e.func_184148_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71439_g.field_70165_t, this.field_146297_k.field_71439_g.field_70163_u, this.field_146297_k.field_71439_g.field_70161_v, DMSounds.PAPER_PLACE, SoundCategory.MASTER, 1.0f, 1.0f);
            this.saveNotes();
        }
        this.currentScreen.screen.mouseReleased(this, state, mouseX, mouseY);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (EDITING_NOTE != null) {
            EDITING_NOTE.keyTyped(this, typedChar, keyCode);
        }
        this.currentScreen.screen.keyTyped(typedChar, keyCode);
        super.func_73869_a(typedChar, keyCode);
    }

    public void saveNotes() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagCompound tag = new NBTTagCompound();
        for (int i = 0; i < NOTES.size(); ++i) {
            GuiElementNote n = NOTES.get(i);
            NBTTagCompound note = new NBTTagCompound();
            for (int j = 0; j < n.text.length; ++j) {
                if (n.text[j] == null) {
                    n.text[j] = "";
                }
                note.func_74778_a("l" + j, n.text[j]);
            }
            note.func_74776_a("x", n.posX);
            note.func_74776_a("y", n.posY);
            tag.func_74782_a("note_" + i, (NBTBase)note);
        }
        compound.func_74782_a("notes", (NBTBase)tag);
        PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_SaveNotes(this.tile.func_174877_v(), compound));
    }

    public void changeScreen(TardisMonitorScreen s) {
        this.currentScreen = s;
        this.currentScreen.screen.show(this);
        this.func_73866_w_();
    }

    public boolean func_73868_f() {
        return false;
    }

    public List<GuiButton> getButtonList() {
        return this.field_146292_n;
    }

    static {
        NOTES = new ArrayList<GuiElementNote>();
        MONITOR_FRAME = TardisMonitorFrame.DEFAULT;
        STAR_BG = new ResourceLocation("thedalekmod", "textures/gui/monitor/star_bg.png");
    }

    public static enum TardisMonitorScreen {
        STATUS(new TardisScreenStatus()),
        COORD_TRAVEL(new TardisScreenCoordTravel()),
        SKIN(new TardisScreenSkinSelection()),
        WAYPOINTS(new TardisScreenWaypointSelection()),
        WAYPOINT_EDIT(new TardisScreenEditWaypoint()),
        WAYPOINT_ADD(new TardisScreenAddWaypoint()),
        SETTINGS(new TardisScreenSettings()),
        COMPANIONS(new TardisScreenCompanions());

        public ITardisScreen screen;

        private TardisMonitorScreen(ITardisScreen screen) {
            this.screen = screen;
        }
    }

    public static enum TardisMonitorFrame {
        DEFAULT(285, 204, "frame_default"),
        DR_8TH(285, 204, "border_8th_doc", "bg_8th_doc"),
        CHRONOTIS(285, 204, "border_chronotis", "bg_chronotis"),
        CLASSIC(285, 204, "border_classic", "bg_classic"),
        COPPER_A(285, 204, "border_copper_a", "bg_copper_a"),
        COPPER_B(285, 204, "border_copper_b", "bg_copper_b"),
        CORAL(285, 204, "border_coral", "bg_coral"),
        TOYOTA(285, 204, "border_toyota", "bg_toyota");

        public ResourceLocation texture;
        public ResourceLocation background;
        public int width;
        public int height;

        private TardisMonitorFrame(int width, int height, String tex, String backgroundTex) {
            this.texture = new ResourceLocation("thedalekmod", "textures/gui/monitor/frames/" + tex + ".png");
            this.background = new ResourceLocation("thedalekmod", "textures/gui/monitor/frames/backgrounds/" + backgroundTex + ".png");
            this.width = width;
            this.height = height;
        }

        private TardisMonitorFrame(int width, int height, String tex) {
            this.texture = new ResourceLocation("thedalekmod", "textures/gui/monitor/frames/" + tex + ".png");
            this.background = null;
            this.width = width;
            this.height = height;
        }
    }
}

