/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDirectional8Way
extends Block {
    public AxisAlignedBB bounds;
    public static final PropertyEnum<MultiDirection> DIRECTION = PropertyEnum.func_177709_a((String)"direction", MultiDirection.class);

    public BlockDirectional8Way(Material materialIn) {
        super(materialIn);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(DIRECTION, (Comparable)((Object)MultiDirection.NORTH)));
        this.bounds = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public BlockDirectional8Way(Material materialIn, AxisAlignedBB bb) {
        super(materialIn);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(DIRECTION, (Comparable)((Object)MultiDirection.NORTH)));
        this.bounds = bb;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DIRECTION});
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return ((MultiDirection)((Object)state.func_177229_b(DIRECTION))).meta;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState s = this.func_176223_P().func_177226_a(DIRECTION, (Comparable)((Object)MultiDirection.getEnumForMeta(meta)));
        return s;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(DIRECTION, (Comparable)((Object)MultiDirection.getEnumForRotation(MathHelper.func_76128_c((double)placer.field_70177_z))));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.bounds;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return super.func_180646_a(blockState, worldIn, pos);
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return super.func_180640_a(state, worldIn, pos);
    }

    public static enum MultiDirection implements IStringSerializable
    {
        NORTH("n", 0),
        NORTH_EAST("ne", 1),
        EAST("e", 2),
        SOUTH_EAST("se", 3),
        SOUTH("s", 4),
        SOUTH_WEST("sw", 5),
        WEST("w", 6),
        NORTH_WEST("nw", 7);

        private final String name;
        private int meta;

        private MultiDirection(String name, int meta) {
            this.name = name;
            this.meta = meta;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static MultiDirection getEnumForMeta(int id) {
            for (MultiDirection e : MultiDirection.values()) {
                if (e.meta != id) continue;
                return e;
            }
            return NORTH;
        }

        public static float getRotationForEnum(MultiDirection md) {
            switch (md) {
                case NORTH: {
                    return 0.0f;
                }
                case NORTH_EAST: {
                    return 45.0f;
                }
                case EAST: {
                    return 90.0f;
                }
                case SOUTH_EAST: {
                    return 135.0f;
                }
                case SOUTH: {
                    return 180.0f;
                }
                case SOUTH_WEST: {
                    return 225.0f;
                }
                case WEST: {
                    return 270.0f;
                }
                case NORTH_WEST: {
                    return 315.0f;
                }
            }
            return 0.0f;
        }

        public static MultiDirection getEnumForRotation(float rotation) {
            int i = (int)rotation % 360;
            if (i < 0) {
                i += 360;
            }
            int a = i / 45 * 45;
            int b = a + 45;
            int difA = Math.abs(a - i);
            int difB = Math.abs(b - i);
            int k = b;
            if (difA < difB) {
                k = a;
            }
            switch (k) {
                case 0: {
                    return NORTH;
                }
                case 45: {
                    return NORTH_EAST;
                }
                case 90: {
                    return EAST;
                }
                case 135: {
                    return SOUTH_EAST;
                }
                case 180: {
                    return SOUTH;
                }
                case 225: {
                    return SOUTH_WEST;
                }
                case 270: {
                    return WEST;
                }
                case 315: {
                    return NORTH_WEST;
                }
            }
            return NORTH;
        }
    }
}

