/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.init;

import com.swdteam.common.init.HandlesCommandRegistry;
import com.swdteam.common.tardis.command.CommandProcessor;
import com.swdteam.dmapi.DMApiHandler;
import com.swdteam.dmapi.command.IHandlesCommand;
import com.swdteam.dmapi.command.ITardisCommand;
import com.swdteam.dmapi.plugin.DMPlugin;
import com.swdteam.main.TheDalekMod;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraftforge.fml.common.Loader;

public class DMPlugins {
    public static Map<String, Long> LOADED_PLUGINS_FILES = new HashMap<String, Long>();
    public static Map<String, DMPlugin> LOADED_PLUGINS = new HashMap<String, DMPlugin>();

    public static void init() throws Exception {
        File f2 = new File("mods/Dalek Mod/plugins/");
        if (!f2.exists()) {
            f2.mkdirs();
        }
        if (f2.listFiles().length != 0) {
            for (File f : f2.listFiles()) {
                if (!f.isFile() || !f.getName().endsWith(".jar")) continue;
                if (LOADED_PLUGINS_FILES.containsKey(f.getName())) {
                    if (LOADED_PLUGINS_FILES.get(f.getName()).longValue() != f.length()) {
                        LOADED_PLUGINS_FILES.remove(f.getName());
                    } else {
                        TheDalekMod.LOG.info(f.getName() + " is already loaded. Skipping...");
                        continue;
                    }
                }
                JarFile jarFile = new JarFile(f);
                Enumeration<JarEntry> e = jarFile.entries();
                URL[] urls = new URL[]{new URL("jar:file:" + f.getAbsolutePath() + "!/")};
                URLClassLoader cl = URLClassLoader.newInstance(urls, Loader.class.getClassLoader());
                while (e.hasMoreElements()) {
                    JarEntry je = e.nextElement();
                    if (je.isDirectory() || !je.getName().endsWith(".class")) continue;
                    String className = je.getName().substring(0, je.getName().length() - 6);
                    className = className.replace('/', '.');
                    Class<?> c = cl.loadClass(className);
                    try {
                        if (!c.isAnnotationPresent(DMPlugin.class)) continue;
                        Object cc = c.newInstance();
                        DMPlugin plugin = c.getAnnotation(DMPlugin.class);
                        if (plugin.getPluginName() != null && plugin.getPluginName().length() > 0) {
                            if (Arrays.asList(DMApiHandler.ACCEPTED_VERSIONS).containsAll(Arrays.asList(plugin.getAcceptedMCVersions()))) {
                                if (cc instanceof IHandlesCommand) {
                                    HandlesCommandRegistry.registerCommand((IHandlesCommand)cc);
                                }
                                if (cc instanceof ITardisCommand) {
                                    CommandProcessor.registerCommand((ITardisCommand)cc);
                                }
                                TheDalekMod.LOG.info("Loaded plugin: " + c.getAnnotation(DMPlugin.class).getPluginName());
                                LOADED_PLUGINS.put(plugin.getPluginName(), plugin);
                            } else {
                                TheDalekMod.LOG.info("Plugin: " + c.getAnnotation(DMPlugin.class).getPluginName() + ", is not compatible with this version");
                            }
                        }
                        LOADED_PLUGINS_FILES.put(f.getName(), f.length());
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                cl.close();
                jarFile.close();
            }
        }
    }
}

