/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.regeneration.skinchanging.packet;

import com.swdteam.common.capability.CapabilityRegeneration;
import com.swdteam.common.capability.interfaces.IRegenerationCapability;
import com.swdteam.common.regeneration.skinchanging.SkinChangingHandler;
import com.swdteam.common.regeneration.skinchanging.packet.Packet_RemovePlayerRegen;
import com.swdteam.network.packets.PacketHandler;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class Packet_RegenSkinSettings
implements IMessage {
    public String action;
    public String[] data;
    public String uuid;

    public Packet_RegenSkinSettings() {
    }

    public Packet_RegenSkinSettings(String action, EntityPlayer player, String ... datas) {
        this.action = action;
        this.data = datas;
        this.uuid = player.func_110124_au().toString();
    }

    public void fromBytes(ByteBuf buf) {
        this.action = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.uuid = ByteBufUtils.readUTF8String((ByteBuf)buf);
        int x = buf.readInt();
        this.data = new String[x];
        for (int i = 0; i < x; ++i) {
            this.data[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.action);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.uuid);
        buf.writeInt(this.data.length);
        for (String s : this.data) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s);
        }
    }

    public static class Handler
    implements IMessageHandler<Packet_RegenSkinSettings, IMessage> {
        public IMessage onMessage(final Packet_RegenSkinSettings message, MessageContext ctx) {
            final EntityPlayer player = ctx.getServerHandler().field_147369_b.field_70170_p.func_152378_a(UUID.fromString(message.uuid));
            if (player != null) {
                player.func_184102_h().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        IRegenerationCapability capa = (IRegenerationCapability)player.getCapability(CapabilityRegeneration.REGEN_CAP, null);
                        String action = message.action;
                        String[] data = message.data;
                        if (action.equalsIgnoreCase("can_change")) {
                            capa.canSkinChange(Boolean.parseBoolean(data[0]));
                        }
                        if (action.equalsIgnoreCase("type_skin")) {
                            capa.setPreferredType(SkinChangingHandler.SkinChoice.getSkinChoice(data[0]));
                        }
                        if (action.equalsIgnoreCase("reset_skin")) {
                            capa.getSkinData().reset();
                            PacketHandler.INSTANCE.sendToAll((IMessage)new Packet_RemovePlayerRegen(data[0], true, data[1]));
                            capa.setSkinChanged(false);
                        }
                        capa.syncToPlayer();
                    }
                });
            }
            return null;
        }
    }
}

