/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.tardis;

import java.util.HashMap;
import java.util.Map;

public class TardisFlightData {
    private static Map<Integer, FlightSequence> flights = new HashMap<Integer, FlightSequence>();

    public static void addFlight(int tardisID) {
        if (!flights.containsKey(tardisID)) {
            FlightSequence fs = new FlightSequence(tardisID);
            flights.put(tardisID, fs);
        }
    }

    public static void completeFlight(int tardisID) {
        if (flights.containsKey(tardisID)) {
            flights.remove(tardisID);
        }
    }

    public static boolean canLand(int tardisID) {
        if (flights.containsKey(tardisID)) {
            FlightSequence fs = flights.get(tardisID);
            return fs.getStartTime() + fs.getLength() < System.currentTimeMillis();
        }
        return true;
    }

    public static FlightSequence getFlight(int tardisID) {
        return flights.containsKey(tardisID) ? flights.get(tardisID) : null;
    }

    public static class FlightSequence {
        private int tardisID;
        private long startTime;
        private long length;

        public FlightSequence(int tardisID) {
            this.tardisID = tardisID;
            this.startTime = System.currentTimeMillis();
            this.length = 12000L;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getLength() {
            return this.length;
        }

        public int getTardisID() {
            return this.tardisID;
        }
    }
}

