/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.init;

import com.swdteam.client.init.DMTextures;
import com.swdteam.client.model.mdl.MDLData;
import com.swdteam.client.model.mdl.ModelBaseMDL;
import com.swdteam.client.model.mdl.ModelMDL;
import com.swdteam.client.model.mdl.ModelRendererMDL;
import com.swdteam.client.model.mdl.ModelRendererPatch;
import com.swdteam.main.TheDalekMod;
import com.swdteam.utils.model.obj.OBJLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.model.ModelRenderer;

public class DMMDLLoader {
    public static ModelMDL loadModel(String model_name) {
        return DMMDLLoader.loadModel(model_name, true);
    }

    public static ModelMDL loadModel(String model_name, boolean loadTexture) {
        DMTextures.ResourceData r = new DMTextures.ResourceData("thedalekmod:models/mdl/" + model_name + ".mdl");
        if (model_name.endsWith(".zip")) {
            r = new DMTextures.ResourceData("thedalekmod:models/mdl/" + model_name);
        }
        if (model_name.endsWith(".mdl")) {
            r = new DMTextures.ResourceData("thedalekmod:models/mdl/" + model_name);
        }
        return DMMDLLoader.loadModel(r.getStream(), loadTexture);
    }

    public static ModelMDL loadModel(InputStream inputstream, boolean loadTexture) {
        ModelMDL model = new ModelMDL();
        model.setUseTexture(loadTexture);
        ModelBaseMDL modelData = new ModelBaseMDL();
        MDLData mdld = new MDLData();
        ZipInputStream stream = new ZipInputStream(inputstream);
        try {
            ZipEntry e;
            while ((e = stream.getNextEntry()) != null) {
                if (e.getName().equalsIgnoreCase("data_mdl.json")) {
                    return null;
                }
                if (loadTexture && e.getName().endsWith(".png")) {
                    if (e.getName().contains("lm")) {
                        model.setLightMaptexture(ImageIO.read(stream));
                    }
                    if (e.getName().contains("tex")) {
                        model.setTexture(ImageIO.read(stream));
                    }
                }
                if (e.getName().endsWith(".json")) {
                    String line;
                    BufferedReader reader;
                    if (e.getName().equals("model_data.json")) {
                        reader = new BufferedReader(new InputStreamReader(stream));
                        StringBuilder model_data = new StringBuilder();
                        line = null;
                        while ((line = reader.readLine()) != null) {
                            model_data.append(line);
                        }
                        mdld = (MDLData)TheDalekMod.GSON.fromJson(model_data.toString(), MDLData.class);
                    }
                    if (e.getName().equalsIgnoreCase("model.json")) {
                        reader = new BufferedReader(new InputStreamReader(stream));
                        StringBuilder model_json = new StringBuilder();
                        line = null;
                        while ((line = reader.readLine()) != null) {
                            model_json.append(line);
                        }
                        modelData = (ModelBaseMDL)TheDalekMod.GSON.fromJson(model_json.toString(), ModelBaseMDL.class);
                    }
                }
                if (!e.getName().equals("model.obj")) continue;
                model.setObjModel(OBJLoader.INSTANCE.loadModel(stream));
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (mdld != null) {
            model.setModelData(mdld);
        } else {
            model.setModelData(new MDLData());
        }
        model.field_78090_t = modelData.texture_width;
        model.field_78089_u = modelData.texture_height;
        for (int i = 0; i < modelData.getParts().size(); ++i) {
            ModelRendererMDL m = modelData.getParts().get(i);
            ModelRendererPatch mr = new ModelRendererPatch(model, m.getTexture_offset()[0], m.getTexture_offset()[1]);
            if (m.getShapeName() == null) {
                mr.setShapeName("shape_" + i);
            } else {
                mr.setShapeName(m.getShapeName());
            }
            mr.default_offset = m.getOffset();
            mr.default_position = m.getPosition();
            mr.default_rotation = m.getRotation();
            mr.default_texture_offset = m.getTexture_offset();
            mr.field_78809_i = m.isFlipTexture();
            mr.field_78801_a = model.field_78090_t;
            mr.field_78799_b = model.field_78089_u;
            mr.func_78789_a(m.getOffset()[0], m.getOffset()[1], m.getOffset()[2], m.getDimension()[0], m.getDimension()[1], m.getDimension()[2]);
            mr.func_78793_a(m.getPosition()[0], m.getPosition()[1], m.getPosition()[2]);
            mr.func_78784_a(m.getTexture_offset()[0], m.getTexture_offset()[1]);
            mr.field_78795_f = (float)Math.toRadians(m.getRotation()[0]);
            mr.field_78796_g = (float)Math.toRadians(m.getRotation()[1]);
            mr.field_78808_h = (float)Math.toRadians(m.getRotation()[2]);
            DMMDLLoader.addChildElements(model, m, mr);
            model.addPart(mr);
        }
        return model;
    }

    public static void addChildElements(ModelMDL model, ModelRendererMDL modelMDL, ModelRenderer parent) {
        if (modelMDL.getChildElements() != null && modelMDL.getChildElements().length > 0) {
            for (int i = 0; i < modelMDL.getChildElements().length; ++i) {
                ModelRendererMDL m = modelMDL.getChildElements()[i];
                ModelRendererPatch mr = new ModelRendererPatch(model, m.getTexture_offset()[0], m.getTexture_offset()[1]);
                if (m.getShapeName() == null) {
                    mr.setShapeName("shape_" + i);
                } else {
                    mr.setShapeName(m.getShapeName());
                }
                mr.default_offset = m.getOffset();
                mr.default_position = m.getPosition();
                mr.default_rotation = m.getRotation();
                mr.default_texture_offset = m.getTexture_offset();
                mr.field_78809_i = m.isFlipTexture();
                mr.field_78801_a = model.field_78090_t;
                mr.field_78799_b = model.field_78089_u;
                mr.func_78789_a(m.getOffset()[0], m.getOffset()[1], m.getOffset()[2], m.getDimension()[0], m.getDimension()[1], m.getDimension()[2]);
                mr.func_78793_a(m.getPosition()[0], m.getPosition()[1], m.getPosition()[2]);
                mr.func_78784_a(m.getTexture_offset()[0], m.getTexture_offset()[1]);
                mr.field_78795_f = (float)Math.toRadians(m.getRotation()[0]);
                mr.field_78796_g = (float)Math.toRadians(m.getRotation()[1]);
                mr.field_78808_h = (float)Math.toRadians(m.getRotation()[2]);
                DMMDLLoader.addChildElements(model, m, mr);
                parent.func_78792_a((ModelRenderer)mr);
            }
        }
    }
}

