/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.render.tileentity;

import com.swdteam.client.image.ImageData;
import com.swdteam.client.init.DMBufferedImages;
import com.swdteam.client.render.IRenderExtender;
import com.swdteam.common.tileentity.TileEntityImage;
import com.swdteam.utils.FileUtils;
import com.swdteam.utils.Graphics;
import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderImageLoader
implements IRenderExtender {
    public ResourceLocation texture = FileUtils.newResourceLocation("thedalekmod:textures/sky/sky_box/space.png");

    @Override
    public void preRender(Object ... o) {
        TileEntity te = (TileEntity)o[0];
        if (te instanceof TileEntityImage) {
            TileEntityImage image = (TileEntityImage)te;
            GL11.glDisable((int)2884);
            if (image.doom) {
                float rot = 0.0f;
                if (o.length > 1) {
                    rot = ((Float)o[1]).floatValue();
                }
                float renderRot = Minecraft.func_71410_x().func_175598_ae().field_78735_i + 180.0f;
                GL11.glRotatef((float)(-rot + renderRot), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GL11.glTranslatef((float)0.0f, (float)1.0f, (float)(image.doom ? 0.0f : 0.495f));
            GL11.glScalef((float)image.scaleX, (float)image.scaleY, (float)1.0f);
            GL11.glTranslatef((float)image.offsetX, (float)image.offsetY, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
            this.sortOutBufferedImage(image);
            GL11.glTranslatef((float)(-image.offsetX), (float)(-image.offsetY), (float)0.0f);
            GL11.glEnable((int)2884);
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
        }
    }

    @Override
    public void postRender(Object ... o) {
    }

    @Override
    public boolean useMetaRotation() {
        return true;
    }

    public void sortOutBufferedImage(TileEntityImage e) {
        ImageData data = DMBufferedImages.getImage(e.getImageName());
        BufferedImage bi = data.getBi();
        float width = 0.0f;
        float height = 0.0f;
        float x = 0.5f;
        float y = 0.5f;
        if (bi != null) {
            if (e.isMovie) {
                int framesY;
                TileEntityImage image = e;
                image.timeOld = image.timeNew;
                image.timeNew = Minecraft.func_71386_F();
                long deltaTime = image.timeNew - image.timeOld;
                image.frame += (float)image.fps / 800.0f * (float)deltaTime;
                int framesX = bi.getWidth() / image.dimX;
                if (image.frame > (float)(framesX * (framesY = bi.getHeight() / image.dimY))) {
                    image.frame = 0.0f;
                }
                int i = (int)image.frame;
                Graphics.bindTexture(data.getTextureID());
                RenderImageLoader.drawModalRectWithCustomSizedTexture(0, 0, i % framesX, i / framesY, 1, 1, bi.getWidth() / image.dimX, bi.getHeight() / image.dimY);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
            } else {
                width = (float)bi.getWidth() / 32.0f;
                height = (float)bi.getHeight() / 32.0f;
                x = width / 2.0f - width;
                y = 0.5f;
                Graphics.bindTexture(data.getTextureID());
                Graphics.drawNoBind(0.5f - width / 2.0f, 0.0f, width, height, 0);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
            }
        } else {
            Graphics.bindTexture(TextureMap.field_174945_f);
            Graphics.drawNoBind(0.0f, 0.0f, 1.0f, 1.0f, 0);
        }
    }

    public static void drawModalRectWithCustomSizedTexture(int x, int y, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)(u * f), (double)((v + (float)height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((u + (float)width) * f), (double)((v + (float)height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((u + (float)width) * f), (double)(v * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }
}

