/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.event;

import com.google.common.collect.Lists;
import com.swdteam.common.block.BlockTardisDoorBase;
import com.swdteam.common.block.BlockTileEntityDoorBase;
import com.swdteam.common.block.tardis.BlockSotoDoor;
import com.swdteam.common.block.tardis.BlockTardis;
import com.swdteam.common.data.BlockData;
import com.swdteam.common.dimensions.world.WorldProviderTardis;
import com.swdteam.common.init.DMSchematics;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tileentity.DMTileEntityBase;
import com.swdteam.common.tileentity.TileEntityMoment;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.common.world.gen.structures.global.OreGeneration;
import com.swdteam.main.TheDalekMod;
import com.swdteam.main.config.DMConfig;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_SyncEntityFlattening;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.WorldUtils;
import com.swdteam.utils.world.SchematicUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class ServerTickEvent {
    public static List<BlockData> blockData = new ArrayList<BlockData>();
    public static Map<String, EntitySizeData> entityChangeSizes = new HashMap<String, EntitySizeData>();
    private static int bl = DMSchematics.TARDISBoundary.blocks.size();
    static boolean spawn = false;

    public static void addEntitySize(EntityLivingBase base, float size, EntitySizeData.VARIANT sizeData) {
        EntitySizeData data = new EntitySizeData(size, sizeData);
        entityChangeSizes.put(base.func_110124_au().toString(), data);
        PacketHandler.INSTANCE.sendToAll((IMessage)new Packet_SyncEntityFlattening("add", base.func_110124_au().toString(), TheDalekMod.GSON.toJson((Object)data)));
    }

    public static void addEntitySizeToServer(EntityLivingBase base, float size, EntitySizeData.VARIANT sizeData) {
        EntitySizeData data = new EntitySizeData(size, sizeData);
        PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_SyncEntityFlattening("add", base.func_110124_au().toString(), TheDalekMod.GSON.toJson((Object)data)));
    }

    public static float getSizeEntity(EntityLivingBase base) {
        if (entityChangeSizes.containsKey(base.func_110124_au().toString())) {
            return ServerTickEvent.entityChangeSizes.get((Object)base.func_110124_au().toString()).size;
        }
        return 1.0f;
    }

    public static void removeEntitySize(EntityLivingBase base) {
        PacketHandler.INSTANCE.sendToAll((IMessage)new Packet_SyncEntityFlattening("remove", base.func_110124_au().toString()));
    }

    public static void syncAllEntitySizesPlayer(EntityPlayerMP player) {
        if (entityChangeSizes.size() > 0) {
            for (Map.Entry<String, EntitySizeData> dataEntry : entityChangeSizes.entrySet()) {
                PacketHandler.INSTANCE.sendTo((IMessage)new Packet_SyncEntityFlattening("add", dataEntry.getKey(), TheDalekMod.GSON.toJson((Object)dataEntry.getValue())), player);
            }
        }
    }

    @SubscribeEvent
    public static void playerConnect(PlayerEvent.PlayerLoggedInEvent e) {
        if (!e.player.field_70170_p.field_72995_K) {
            ServerTickEvent.syncAllEntitySizesPlayer((EntityPlayerMP)e.player);
        }
    }

    @SubscribeEvent
    public static void playerDisconnect(PlayerEvent.PlayerLoggedOutEvent e) {
        if (e.player.field_70170_p.field_72995_K) {
            entityChangeSizes.clear();
        }
    }

    @SubscribeEvent
    public static void stopTARDISGrief(PlayerInteractEvent event) {
        if (DMConfig.tardis.stopTARDISGriefing && !event.getEntityPlayer().field_70170_p.field_72995_K && event.getEntityPlayer().field_70170_p.field_73011_w instanceof WorldProviderTardis) {
            EntityPlayer player = event.getEntityPlayer();
            if (event.getHand() == EnumHand.MAIN_HAND || event.getHand() == EnumHand.OFF_HAND) {
                Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
                if (block instanceof BlockTardisDoorBase || block instanceof BlockTardisDoorBase || block instanceof BlockSotoDoor || block instanceof BlockTileEntityDoorBase) {
                    return;
                }
                if (!DMTardis.hasPermission(event.getPos(), player)) {
                    PlayerUtils.Messaging.sendStatusMessageToPlayer(player, TextFormatting.RED + "Cannot Interact outside of your TARDIS", true);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent e) {
        World w = e.getWorld();
        BlockPos p = new BlockPos(e.getExplosion().getPosition().field_72450_a, e.getExplosion().getPosition().field_72448_b, e.getExplosion().getPosition().field_72449_c);
        int d = 6;
        for (BlockPos pos : BlockPos.func_191532_a((int)(p.func_177958_n() - d), (int)(p.func_177956_o() - d), (int)(p.func_177952_p() - d), (int)(p.func_177958_n() + d), (int)(p.func_177956_o() + d), (int)(p.func_177952_p() + d))) {
            TileEntityTardis tile;
            if (!(w.func_180495_p(pos).func_177230_c() instanceof BlockTardis) || !(w.func_175625_s(pos) instanceof TileEntityTardis) || (tile = (TileEntityTardis)w.func_175625_s(pos)).getTardisData() == null) continue;
            int f1 = 1;
            if (e.getExplosion().func_94613_c() instanceof EntityWither) {
                f1 = 7;
            } else if (e.getExplosion().func_94613_c() instanceof EntityCreeper) {
                f1 = ((EntityCreeper)e.getExplosion().func_94613_c()).func_70830_n() ? 6 : 3;
            } else if (e.getExplosion().func_94613_c() instanceof EntityPlayer) {
                f1 = 4;
            }
            double x = e.getExplosion().getPosition().field_72450_a - (double)tile.func_174877_v().func_177958_n();
            double y = e.getExplosion().getPosition().field_72448_b - (double)tile.func_174877_v().func_177956_o();
            double z = e.getExplosion().getPosition().field_72449_c - (double)tile.func_174877_v().func_177952_p();
            double distance = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
            int damage = (int)((double)(2000 * f1) / (distance + 1.0));
            int health = tile.getTardisData().getTardisHealth();
            if (!tile.getTardisData().areForcefieldsEnabled()) {
                tile.getTardisData().setTardisHealth(health - damage);
                continue;
            }
            tile.getTardisData().setTardisHealth(health - 3);
        }
    }

    @SubscribeEvent
    public static void onMobDrops(LivingDropsEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            EntityPlayerMP e = (EntityPlayerMP)event.getEntity();
            if (e.func_174793_f().func_70005_c_().equals("RedDash16")) {
                e.func_145779_a(Item.func_150898_a((Block)Blocks.field_150330_I), 64);
            }
            if (e.func_174793_f().func_70005_c_().equals("1WTC")) {
                e.func_145779_a(Item.func_150898_a((Block)Blocks.field_150335_W), 3);
            }
            if (e.func_174793_f().func_70005_c_().equals("Josia50")) {
                e.func_145779_a(Item.func_150898_a((Block)Blocks.field_150328_O), 1);
            }
        }
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent e) {
        for (int i = 0; i < blockData.size(); ++i) {
            TileEntity t;
            BlockData tempData = blockData.get(i);
            if (tempData.getTime() + 2500L >= System.currentTimeMillis()) continue;
            WorldServer w = TheDalekMod.FML.getMinecraftServerInstance().func_71218_a(tempData.getDimension());
            w.func_175656_a(tempData.getPos(), tempData.getBlock());
            if (tempData.getTileEntityData() != null && tempData.getPos() != null && (t = w.func_175625_s(tempData.getPos())) != null && tempData.getTileEntityData() != null) {
                t.func_145839_a(tempData.getTileEntityData());
            }
            blockData.remove(i);
        }
    }

    @SubscribeEvent
    public static void TARDISboundary(TickEvent.WorldTickEvent e) {
        if (DMSchematics.TARDIS_BOUNDARIES != null && DMSchematics.TARDIS_BOUNDARIES.size() > 0 && DMSchematics.TARDISBoundary.blocks != null && DMSchematics.TARDISBoundary.blocks.size() > 0 && DMSchematics.TARDIS_BOUNDARIES.get(0) != null) {
            if (bl > 0) {
                for (int i = 0; i < DMSchematics.TARDISBoundary.blocks.size() / 8 && bl != 0; ++i) {
                    IBlockState block = TheDalekMod.FML.getMinecraftServerInstance().func_71218_a(DMConfig.dimensionIDs.Tardis_Dimension_ID).func_180495_p(DMSchematics.TARDISBoundary.blocks.get(--bl).getPos().func_177982_a(DMSchematics.TARDIS_BOUNDARIES.get(0).func_177958_n(), DMSchematics.TARDIS_BOUNDARIES.get(0).func_177956_o(), DMSchematics.TARDIS_BOUNDARIES.get(0).func_177952_p()));
                    if (block == DMSchematics.TARDISBoundary.blocks.get(bl).getState()) continue;
                    WorldUtils.setBlockFast((World)TheDalekMod.FML.getMinecraftServerInstance().func_71218_a(DMConfig.dimensionIDs.Tardis_Dimension_ID), DMSchematics.TARDISBoundary.blocks.get(bl).getPos().func_177982_a(DMSchematics.TARDIS_BOUNDARIES.get(0).func_177958_n(), DMSchematics.TARDIS_BOUNDARIES.get(0).func_177956_o(), DMSchematics.TARDIS_BOUNDARIES.get(0).func_177952_p()), DMSchematics.TARDISBoundary.blocks.get(bl).getState(), 2);
                }
            } else {
                bl = DMSchematics.TARDISBoundary.blocks.size();
                DMSchematics.TARDIS_BOUNDARIES.remove(0);
            }
        }
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.WorldTickEvent e) {
        if (!DMConfig.serverSide.disableCustomDalekSpawner) {
            if (e.world.field_73012_v.nextInt(500) == 4) {
                spawn = false;
            }
            if (!e.world.func_82736_K().func_82766_b("doMobSpawning") && e.world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                spawn = true;
            }
            if (e.world.field_73011_w.getDimension() == 0 && !spawn) {
                if (e.world.func_72863_F() instanceof ChunkProviderServer) {
                    ChunkProviderServer chunkProvider = (ChunkProviderServer)e.world.func_72863_F();
                    for (Chunk chunk : Lists.newArrayList((Iterable)chunkProvider.func_189548_a())) {
                        if (e.world.field_73012_v.nextInt(150) != 25 || WorldUtils.getEntityLivingCountInChunk(e.world, chunk) >= 3 || WorldUtils.getPlayerCountInChunk(e.world, chunk) > 0) continue;
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h);
                    }
                }
                spawn = true;
            }
        }
        if (TileEntityMoment.waveDataList.size() > 0) {
            for (int x = 0; x < TileEntityMoment.waveDataList.size(); ++x) {
                TileEntityMoment.MomentWaveData data = TileEntityMoment.waveDataList.get(x);
                data.grow(e.world);
            }
        }
        for (SchematicUtils.GenerationQueue queue : SchematicUtils.GenerationQueue.values()) {
            if (queue.getList() == null || queue.getList().size() <= 0) continue;
            SchematicUtils.SchematicChunk chunk = queue.getList().get(0);
            WorldServer w = e.world.func_73046_m().func_71218_a(chunk.getWorld());
            for (SchematicUtils.SchematicChunk.SchematicChunkBlockState bs : chunk.getBlocks()) {
                if (bs.getBlockUpdater() != null) {
                    bs.getBlockUpdater().replaceBlock((World)w, bs.getPos());
                    continue;
                }
                if (bs.getBlock() != null && bs.getBlock().func_177230_c().func_176223_P() == w.func_180495_p(bs.getPos()).func_177230_c().func_176223_P()) continue;
                if (bs.getBlock() != null) {
                    WorldUtils.setBlockFast((World)w, bs.getPos(), bs.getBlock(), 2);
                    continue;
                }
                if (bs.getNbt() == null || bs.getNbt().length() <= 0) continue;
                TileEntity t = w.func_175625_s(bs.getPos());
                NBTTagCompound tag = new NBTTagCompound();
                try {
                    tag = JsonToNBT.func_180713_a((String)bs.getNbt());
                }
                catch (NBTException e1) {
                    TheDalekMod.LOG.error((Object)e1);
                }
                boolean setup = true;
                if (t instanceof DMTileEntityBase) {
                    boolean bl = setup = !((DMTileEntityBase)t).ignoreSetup;
                }
                if (t == null || !setup) continue;
                if (tag != null) {
                    tag.func_74768_a("x", bs.getPos().func_177958_n());
                    tag.func_74768_a("y", bs.getPos().func_177956_o());
                    tag.func_74768_a("z", bs.getPos().func_177952_p());
                    t.func_145839_a(tag);
                }
                t.func_70296_d();
                WorldUtils.markBlockForUpdate((World)w, bs.getPos());
            }
            queue.getList().remove(0);
        }
    }

    public static class EntitySizeData {
        public float size;
        public VARIANT variant;

        public EntitySizeData(float size, VARIANT variant) {
            this.size = size;
            this.variant = variant;
        }

        public static enum VARIANT {
            Y,
            X;

        }
    }
}

