/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.utils;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ITeleporter;

public class TeleportUtils {
    public static void teleportToDimension(EntityPlayerMP player, int dimension, double xPos, double yPos, double zPos, float facing, float pitch) {
        try {
            DimensionManager.createProviderFor((int)dimension);
            BlockPos pos = new BlockPos(xPos, yPos, zPos);
            Entity e = TeleportUtils.teleportPlayerToDimension(player.field_71133_b, (Entity)player, dimension);
            if (e instanceof EntityPlayerMP) {
                EntityPlayerMP p = (EntityPlayerMP)e;
                p.func_71121_q().func_72863_F().func_186028_c(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
                p.field_71135_a.func_147364_a(xPos + 0.5, yPos, zPos + 0.5, facing, pitch);
                p.func_70012_b(xPos + 0.5, yPos, zPos + 0.5, facing, pitch);
                p.func_71121_q().func_72866_a((Entity)p, true);
                p.func_82242_a(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void teleportToDimension(Entity player, int dimension, double xPos, double yPos, double zPos, float facing, float pitch) {
        if (player instanceof EntityMinecartContainer) {
            ((EntityMinecartContainer)player).field_94112_b = false;
        }
        BlockPos pos = new BlockPos(xPos, yPos, zPos);
        Entity e = TeleportUtils.teleportEntityDim(player, pos, dimension);
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP p = (EntityPlayerMP)player;
            p.func_71121_q().func_72863_F().func_186028_c(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            p.field_71135_a.func_147364_a(xPos + 0.5, yPos, zPos + 0.5, facing, pitch);
        } else if (e instanceof Entity) {
            Entity entity = e;
            entity.func_70012_b(xPos + 0.5, yPos, zPos + 0.5, facing, pitch);
        }
    }

    public static void teleportVortexManipulator(EntityPlayer p, int dimension, double xPos, double yPos, double zPos, float facing, float pitch) {
        if (!p.field_70170_p.field_72995_K && p instanceof EntityPlayerMP) {
            WorldServer worldserver = p.field_70170_p.func_73046_m().func_71218_a(dimension);
            EntityPlayerMP playerMP = (EntityPlayerMP)p;
            if (worldserver.func_180495_p(new BlockPos(xPos, yPos, zPos)).func_177230_c() != Blocks.field_150350_a || worldserver.func_180495_p(new BlockPos(xPos, yPos - 1.0, zPos)).func_177230_c() == Blocks.field_150350_a) {
                yPos = worldserver.func_175672_r(new BlockPos(xPos, 0.0, zPos)).func_177956_o();
            }
            if (dimension != playerMP.field_71093_bK && p.func_184187_bx() == null && p.func_184187_bx() == null) {
                TeleportUtils.teleportToDimension(playerMP, dimension, xPos, yPos, zPos, playerMP.func_174811_aO().func_185119_l(), playerMP.field_70726_aT);
            } else if (dimension == playerMP.field_71093_bK && p.func_184187_bx() == null && p.func_184187_bx() == null) {
                TeleportUtils.teleportToDimension(playerMP, p.field_71093_bK, xPos, yPos, zPos, playerMP.func_174811_aO().func_185119_l(), playerMP.field_70726_aT);
            }
        }
    }

    private static BlockPos calculateSafeYPos(double yPos, double xPos, double zPos, EntityPlayer p) {
        if (p.field_70170_p.func_180495_p(new BlockPos(xPos, yPos, zPos)).func_177230_c() != Blocks.field_150350_a) {
            int startNum = 255;
            int timesLooped = 0;
            for (int i = startNum; i >= 0; --i) {
                BlockPos bp = new BlockPos(xPos, (double)i, zPos);
                if (p.field_70170_p.func_180495_p(bp).func_177230_c() == Blocks.field_150350_a && p.field_70170_p.func_180495_p(bp.func_177982_a(0, -1, 0)).func_177230_c() != Blocks.field_150350_a) {
                    return bp;
                }
                if (i != 0 || timesLooped != 0) continue;
                i = 255;
                ++timesLooped;
            }
        }
        return new BlockPos(xPos, yPos, zPos);
    }

    public static void teleportToDimensionFlightPanel(EntityPlayerMP player, int dimension, double xPos, double yPos, double zPos, float facing, float pitch) {
        try {
            Entity e = TeleportUtils.teleportPlayerToDimension(player.field_71133_b, (Entity)player, dimension);
            if (e instanceof EntityPlayerMP) {
                EntityPlayerMP p = (EntityPlayerMP)e;
                p.field_71135_a.func_147364_a(xPos + 0.5, yPos + 1.0, zPos + 0.5, facing, pitch);
                p.field_71075_bZ.field_75100_b = true;
                p.field_71075_bZ.field_75099_e = false;
                p.field_71075_bZ.field_75101_c = true;
                p.field_71075_bZ.field_75102_a = true;
                p.func_70012_b(xPos + 0.5, yPos + 1.0, zPos + 0.5, facing, pitch);
                p.func_184189_br();
                p.func_71121_q().func_72866_a((Entity)p, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Entity teleportPlayerToDimension(MinecraftServer server, Entity entity, int dimension) {
        if (entity instanceof EntityPlayerMP) {
            if (entity.field_70170_p.field_73011_w.getDimension() != dimension) {
                server.func_184103_al().transferPlayerToDimension((EntityPlayerMP)entity, dimension, (ITeleporter)new TeleporterSimple());
            }
            return entity;
        }
        return null;
    }

    public static Entity teleportEntityDim(Entity entity, BlockPos pos, int targetDim) {
        int from;
        if (entity.func_130014_f_().field_72995_K || !entity.func_70089_S()) {
            return null;
        }
        EntityPlayerMP player = null;
        if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
        }
        if ((from = entity.field_71093_bK) != targetDim) {
            MinecraftServer server = player == null ? entity.func_184102_h() : player.field_71133_b;
            WorldServer fromDim = server.func_71218_a(from);
            WorldServer toDim = server.func_71218_a(targetDim);
            TeleporterSimple teleporter = new TeleporterSimple();
            if (player != null) {
                toDim.func_175726_f(pos).func_177446_d(true);
                if (!toDim.func_175667_e(pos)) {
                    toDim.func_175726_f(pos);
                }
                server.func_184103_al().transferPlayerToDimension(player, targetDim, (ITeleporter)teleporter);
                if (from == 1 && entity.func_70089_S()) {
                    toDim.func_72838_d(entity);
                    toDim.func_72866_a(entity, false);
                }
            } else {
                try {
                    NBTTagCompound tagCompound = entity.serializeNBT();
                    float rotationYaw = entity.field_70177_z;
                    float rotationPitch = entity.field_70125_A;
                    fromDim.func_72900_e(entity);
                    Entity newEntity = EntityList.func_75615_a((NBTTagCompound)tagCompound, (World)toDim);
                    if (newEntity != null) {
                        toDim.func_175726_f(pos);
                        newEntity.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), rotationYaw, rotationPitch);
                        newEntity.field_98038_p = true;
                        toDim.func_72838_d(newEntity);
                        newEntity.field_98038_p = false;
                        return newEntity;
                    }
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (!entity.field_70170_p.func_175667_e(pos)) {
            entity.field_70170_p.func_175726_f(pos);
        }
        if (player != null && player.field_71135_a != null) {
            player.field_71135_a.func_147364_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
            player.func_82242_a(0);
        }
        entity.field_70143_R = 0.0f;
        return entity;
    }

    public static class TeleporterSimple
    implements ITeleporter {
        public void placeEntity(World world, Entity entity, float yaw) {
        }
    }
}

