/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import com.google.common.collect.ImmutableList;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.IIngredientListOverlay;
import mezz.jei.api.IItemListOverlay;
import mezz.jei.api.gui.IGuiProperties;
import mezz.jei.config.Config;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.ghost.GhostIngredientDragManager;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.ConfigButton;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.gui.overlay.IngredientGridAll;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.input.GuiTextFieldFilter;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.util.CommandUtil;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class IngredientListOverlay
implements IItemListOverlay,
IIngredientListOverlay,
IMouseHandler,
IShowsRecipeFocuses {
    private static final int BORDER_PADDING = 2;
    private static final int BUTTON_SIZE = 20;
    private static final int SEARCH_HEIGHT = 20;
    private final IngredientFilter ingredientFilter;
    private final NonNullList<ItemStack> highlightedStacks = NonNullList.func_191196_a();
    private final ConfigButton configButton;
    private final IngredientGridAll contents;
    private final GuiTextFieldFilter searchField;
    private final GhostIngredientDragManager ghostIngredientDragManager;
    private Rectangle displayArea = new Rectangle();
    @Nullable
    private IGuiProperties guiProperties;

    private static boolean hasRoom(IGuiProperties guiProperties) {
        Rectangle displayArea = IngredientListOverlay.getDisplayArea(guiProperties);
        return displayArea.width >= IngredientListOverlay.getMinWidth();
    }

    private static int getMinWidth() {
        return Math.max(80, 4 * IngredientGrid.INGREDIENT_WIDTH);
    }

    private static boolean isSearchBarCentered(IGuiProperties guiProperties) {
        return Config.isCenterSearchBarEnabled() && guiProperties.getGuiTop() + guiProperties.getGuiYSize() + 20 < guiProperties.getScreenHeight();
    }

    public IngredientListOverlay(IngredientFilter ingredientFilter) {
        this.ingredientFilter = ingredientFilter;
        this.contents = new IngredientGridAll(ingredientFilter);
        this.searchField = new GuiTextFieldFilter(0, ingredientFilter);
        this.configButton = new ConfigButton(this);
        this.ghostIngredientDragManager = new GhostIngredientDragManager(this.contents);
        this.setKeyboardFocus(false);
    }

    public void rebuildItemFilter() {
        Log.get().info("Updating ingredient filter...");
        long start_time = System.currentTimeMillis();
        this.ingredientFilter.modesChanged();
        Log.get().info("Updated  ingredient filter in {} ms", (Object)(System.currentTimeMillis() - start_time));
        this.updateLayout(true);
    }

    @Override
    public String getFilterText() {
        return Config.getFilterText();
    }

    @Override
    public ImmutableList<ItemStack> getFilteredStacks() {
        List<IIngredientListElement> elements = this.ingredientFilter.getIngredientList();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IIngredientListElement element : elements) {
            Object ingredient = element.getIngredient();
            if (!(ingredient instanceof ItemStack)) continue;
            builder.add((Object)((ItemStack)ingredient));
        }
        return builder.build();
    }

    @Override
    public void highlightStacks(Collection<ItemStack> stacks) {
        this.highlightedStacks.clear();
        this.highlightedStacks.addAll(stacks);
    }

    public boolean isListDisplayed() {
        return Config.isOverlayEnabled() && this.guiProperties != null && IngredientListOverlay.hasRoom(this.guiProperties);
    }

    private static boolean areGuiPropertiesEqual(IGuiProperties guiProperties1, IGuiProperties guiProperties2) {
        return guiProperties1.getGuiClass().equals(guiProperties2.getGuiClass()) && guiProperties1.getGuiLeft() == guiProperties2.getGuiLeft() && guiProperties1.getGuiXSize() == guiProperties2.getGuiXSize() && guiProperties1.getScreenWidth() == guiProperties2.getScreenWidth() && guiProperties1.getScreenHeight() == guiProperties2.getScreenHeight();
    }

    private static Rectangle getDisplayArea(IGuiProperties guiProperties) {
        int x = guiProperties.getGuiLeft() + guiProperties.getGuiXSize() + 2;
        int y = 2;
        int width = guiProperties.getScreenWidth() - x - 2;
        int height = guiProperties.getScreenHeight() - 2 - 2;
        return new Rectangle(x, 2, width, height);
    }

    public void updateScreen(@Nullable GuiScreen guiScreen) {
        JeiRuntime runtime = Internal.getRuntime();
        if (runtime == null) {
            return;
        }
        boolean wasDisplayed = this.isListDisplayed();
        IGuiProperties guiProperties = runtime.getGuiProperties(guiScreen);
        if (guiProperties == null) {
            if (this.guiProperties != null) {
                this.guiProperties = null;
                this.setKeyboardFocus(false);
                this.ghostIngredientDragManager.stopDrag();
            }
        } else if (this.guiProperties == null || !IngredientListOverlay.areGuiPropertiesEqual(this.guiProperties, guiProperties)) {
            this.guiProperties = guiProperties;
            this.displayArea = IngredientListOverlay.getDisplayArea(guiProperties);
            boolean searchBarCentered = IngredientListOverlay.isSearchBarCentered(guiProperties);
            int searchHeight = searchBarCentered ? 0 : 22;
            Rectangle availableContentsArea = new Rectangle(this.displayArea.x, this.displayArea.y, this.displayArea.width, this.displayArea.height - searchHeight);
            int minWidth = IngredientListOverlay.getMinWidth();
            this.contents.updateBounds(availableContentsArea, minWidth);
            Rectangle contentsArea = this.contents.getArea();
            this.displayArea.x = contentsArea.x;
            this.displayArea.width = contentsArea.width;
            if (searchBarCentered && this.isListDisplayed()) {
                this.searchField.updateBounds(new Rectangle(guiProperties.getGuiLeft(), guiProperties.getScreenHeight() - 20 - 2, guiProperties.getGuiXSize() - 20, 20));
            } else {
                this.searchField.updateBounds(new Rectangle(this.displayArea.x, this.displayArea.y + this.displayArea.height - 20 - 2, this.displayArea.width - 20, 20));
            }
            this.configButton.updateBounds(new Rectangle(this.searchField.field_146209_f + this.searchField.field_146218_h, this.searchField.field_146210_g, 20, 20));
            this.updateLayout(false);
        }
        if (wasDisplayed && !this.isListDisplayed()) {
            Config.saveFilterText();
        }
    }

    public void updateLayout(boolean filterChanged) {
        this.contents.updateLayout(filterChanged);
        this.searchField.update();
    }

    public void drawScreen(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.guiProperties != null) {
            if (this.isListDisplayed()) {
                GlStateManager.func_179140_f();
                this.searchField.func_146194_f();
                this.contents.draw(minecraft, mouseX, mouseY, partialTicks);
                this.configButton.draw(minecraft, mouseX, mouseY, partialTicks);
            } else {
                this.configButton.draw(minecraft, mouseX, mouseY, partialTicks);
            }
        }
    }

    public void drawTooltips(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            this.configButton.drawTooltips(minecraft, mouseX, mouseY, true);
            this.ghostIngredientDragManager.drawTooltips(minecraft, mouseX, mouseY);
            this.contents.drawTooltips(minecraft, mouseX, mouseY);
        } else if (this.guiProperties != null) {
            this.configButton.drawTooltips(minecraft, mouseX, mouseY, false);
        }
    }

    public void drawOnForeground(GuiContainer gui, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-gui.getGuiLeft()), (float)(-gui.getGuiTop()), (float)0.0f);
            this.ghostIngredientDragManager.drawOnForeground(gui.field_146297_k, mouseX, mouseY);
            GlStateManager.func_179121_F();
        }
    }

    public void handleTick() {
        if (this.isListDisplayed()) {
            this.searchField.func_146178_a();
        }
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            if (Config.isCenterSearchBarEnabled() && this.searchField.isMouseOver(mouseX, mouseY)) {
                return true;
            }
            return this.displayArea.contains(mouseX, mouseY);
        }
        if (this.guiProperties != null) {
            return this.configButton.isMouseOver(mouseX, mouseY);
        }
        return false;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(int mouseX, int mouseY) {
        IClickedIngredient<?> clicked;
        if (this.isListDisplayed() && (clicked = this.contents.getIngredientUnderMouse(mouseX, mouseY)) != null) {
            clicked.setOnClickHandler(() -> this.setKeyboardFocus(false));
            return clicked;
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return this.isListDisplayed() && this.contents.canSetFocusWithMouse();
    }

    @Override
    public boolean handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.isListDisplayed()) {
            IClickedIngredient<?> clicked;
            if (this.ghostIngredientDragManager.handleMouseClicked(mouseX, mouseY)) {
                return true;
            }
            if (this.configButton.handleMouseClick(mouseX, mouseY)) {
                return true;
            }
            if (!this.isMouseOver(mouseX, mouseY)) {
                this.setKeyboardFocus(false);
                return false;
            }
            if (this.contents.handleMouseClicked(mouseX, mouseY, mouseButton)) {
                this.setKeyboardFocus(false);
                return true;
            }
            boolean searchClicked = this.searchField.isMouseOver(mouseX, mouseY);
            this.setKeyboardFocus(searchClicked);
            if (searchClicked) {
                boolean updated = this.searchField.handleMouseClicked(mouseX, mouseY, mouseButton);
                if (updated) {
                    this.updateLayout(false);
                }
                return true;
            }
            Minecraft minecraft = Minecraft.func_71410_x();
            GuiScreen currentScreen = minecraft.field_71462_r;
            if (currentScreen != null && !(currentScreen instanceof RecipesGui) && (mouseButton == 0 || mouseButton == 1 || minecraft.field_71474_y.field_74322_I.isActiveAndMatches(mouseButton - 100)) && (clicked = this.getIngredientUnderMouse(mouseX, mouseY)) != null) {
                if (Config.isCheatItemsEnabled()) {
                    ItemStack itemStack = clicked.getCheatItemStack();
                    if (!itemStack.func_190926_b()) {
                        CommandUtil.giveStack(itemStack, mouseButton);
                    }
                    clicked.onClickHandled();
                    return true;
                }
                ItemStack mouseItem = minecraft.field_71439_g.field_71071_by.func_70445_o();
                if (mouseItem.func_190926_b() && this.ghostIngredientDragManager.handleClickGhostIngredient(currentScreen, clicked)) {
                    return true;
                }
            }
        } else if (this.guiProperties != null) {
            return this.configButton.handleMouseClick(mouseX, mouseY);
        }
        return false;
    }

    @Override
    public boolean handleMouseScrolled(int mouseX, int mouseY, int scrollDelta) {
        return this.isListDisplayed() && this.isMouseOver(mouseX, mouseY) && this.contents.handleMouseScrolled(mouseX, mouseY, scrollDelta);
    }

    @Override
    public boolean hasKeyboardFocus() {
        return this.isListDisplayed() && this.searchField.func_146206_l();
    }

    public void setKeyboardFocus(boolean keyboardFocus) {
        this.searchField.func_146195_b(keyboardFocus);
    }

    public boolean onGlobalKeyPressed(int eventKey) {
        if (this.isListDisplayed()) {
            if (KeyBindings.toggleCheatMode.isActiveAndMatches(eventKey)) {
                Config.toggleCheatItemsEnabled();
                return true;
            }
            if (KeyBindings.focusSearch.isActiveAndMatches(eventKey)) {
                this.setKeyboardFocus(true);
                return true;
            }
        }
        return false;
    }

    public boolean onKeyPressed(char typedChar, int eventKey) {
        if (this.isListDisplayed()) {
            if (this.hasKeyboardFocus() && this.searchField.func_146201_a(typedChar, eventKey)) {
                boolean changed = Config.setFilterText(this.searchField.func_146179_b());
                if (changed) {
                    this.updateLayout(true);
                }
                return true;
            }
            return this.contents.onKeyPressed(typedChar, eventKey);
        }
        return false;
    }

    @Override
    @Nullable
    public ItemStack getStackUnderMouse() {
        Object ingredient = this.getIngredientUnderMouse();
        if (ingredient instanceof ItemStack) {
            return (ItemStack)ingredient;
        }
        return null;
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse() {
        IIngredientListElement elementUnderMouse;
        if (this.isListDisplayed() && (elementUnderMouse = this.contents.getElementUnderMouse()) != null) {
            return elementUnderMouse.getIngredient();
        }
        return null;
    }

    @Override
    public void setFilterText(String filterText) {
        ErrorUtil.checkNotNull(filterText, "filterText");
        if (Config.setFilterText(filterText)) {
            this.onSetFilterText(filterText);
        }
    }

    public void onSetFilterText(String filterText) {
        this.searchField.func_146180_a(filterText);
        this.updateLayout(true);
    }

    @Override
    public ImmutableList<ItemStack> getVisibleStacks() {
        if (this.isListDisplayed()) {
            ImmutableList.Builder visibleStacks = ImmutableList.builder();
            List<IIngredientListElement> visibleElements = this.contents.getVisibleElements();
            for (IIngredientListElement element : visibleElements) {
                Object ingredient = element.getIngredient();
                if (!(ingredient instanceof ItemStack)) continue;
                visibleStacks.add((Object)((ItemStack)ingredient));
            }
            return visibleStacks.build();
        }
        return ImmutableList.of();
    }

    @Override
    public ImmutableList<Object> getVisibleIngredients() {
        if (this.isListDisplayed()) {
            ImmutableList.Builder visibleIngredients = ImmutableList.builder();
            List<IIngredientListElement> visibleElements = this.contents.getVisibleElements();
            for (IIngredientListElement element : visibleElements) {
                Object ingredient = element.getIngredient();
                visibleIngredients.add(ingredient);
            }
            return visibleIngredients.build();
        }
        return ImmutableList.of();
    }
}

