/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.block;

import com.google.common.base.Predicate;
import com.swdteam.common.tileentity.DMTileEntityBase;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDMTileEntityBase
extends Block {
    public Supplier<TileEntity> tileEntity;
    private AxisAlignedBB bounds;
    private boolean noCollision = false;
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockDMTileEntityBase(Supplier<TileEntity> tClass) {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.tileEntity = tClass;
    }

    public BlockDMTileEntityBase(final Class<? extends TileEntity> tClass) {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.tileEntity = new Supplier<TileEntity>(){

            @Override
            public TileEntity get() {
                try {
                    return (TileEntity)tClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.tileEntity.get();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)state.func_177230_c());
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (placer.func_70093_af()) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof DMTileEntityBase) {
                int i = MathHelper.func_76128_c((double)((double)placer.field_70177_z + 180.0));
                if ((i = 45 * Math.round(i / 45)) < 0) {
                    i = 360 + i;
                }
                ((DMTileEntityBase)te).rotation = i;
            }
        } else {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof DMTileEntityBase) {
                int i = MathHelper.func_76128_c((double)placer.field_70177_z);
                if (i < 0) {
                    i += 360;
                }
                float snapRot = 0.0f;
                if (i <= 360) {
                    snapRot = 360.0f;
                }
                if (i <= 315) {
                    snapRot = 270.0f;
                }
                if (i <= 225) {
                    snapRot = 180.0f;
                }
                if (i <= 135) {
                    snapRot = 90.0f;
                }
                if (i <= 45) {
                    snapRot = 0.0f;
                }
                if (i <= -45) {
                    snapRot = -90.0f;
                }
                if (i <= -135) {
                    snapRot = -180.0f;
                }
                if (i == 0) {
                    snapRot = 360.0f;
                }
                ((DMTileEntityBase)te).rotation = snapRot + 180.0f;
            }
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getStateForEntityRender(IBlockState state) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public Block setNoCollision(boolean noCollision) {
        this.noCollision = noCollision;
        return this;
    }

    public boolean noCollision() {
        return this.noCollision;
    }

    public void setBlockBounds(AxisAlignedBB bounds) {
        this.bounds = bounds;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.bounds != null) {
            return this.bounds;
        }
        return super.func_185496_a(state, source, pos);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        if (this.noCollision) {
            return field_185506_k;
        }
        if (this.bounds != null) {
            return this.bounds;
        }
        return super.func_180646_a(blockState, worldIn, pos);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

