/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.mdl;

import com.swdteam.mdl.IPortalSetup;
import com.swdteam.mdl.graphics.Graphics;
import com.swdteam.mdl.obj.Model;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opengl.GL11;

public class MDL {
    public BufferedImage MDLIcon;
    private Model[] models;
    private Map<String, Integer> modelIndexes = new HashMap<String, Integer>();
    public int[] displayLists;
    public int[] textures;
    public BufferedImage[] textureFiles;
    public boolean[] loadingTextures;
    public boolean blending;
    public static IPortalSetup portalSetup;
    public MDLTransform transform = new MDLTransform();
    public boolean portalRender;

    public MDL() {
        this.transform.rotate(180.0, 0.0, 0.0);
        this.transform.offset(0.0, -1.5, 0.0);
        this.blending = true;
    }

    public void render(Model part) {
        if (part == null) {
            return;
        }
        if (this.models != null) {
            GL11.glPushMatrix();
            this.blending();
            this.transform.transform();
            int previousTexture = GL11.glGetInteger((int)32873);
            int lastShade = GL11.glGetInteger((int)2900);
            part.renderAll(this);
            Graphics.bindTexture(previousTexture);
            GL11.glShadeModel((int)lastShade);
            GL11.glPopMatrix();
        }
    }

    public void render() {
        if (this.models != null) {
            GL11.glPushMatrix();
            this.blending();
            this.transform.transform();
            int previousTexture = GL11.glGetInteger((int)32873);
            int lastShade = GL11.glGetInteger((int)2900);
            for (Model m1 : this.models) {
                if (m1.isChild || m1.hidden) continue;
                m1.renderAll(this);
            }
            Graphics.bindTexture(previousTexture);
            GL11.glShadeModel((int)lastShade);
            GL11.glPopMatrix();
        }
    }

    public int createDisplayList(Model model) {
        int displayList = GL11.glGenLists((int)1);
        GL11.glNewList((int)displayList, (int)4864);
        model.render(this);
        GL11.glEndList();
        return displayList;
    }

    public Model[] getModels() {
        return this.models;
    }

    public Model getPart(String s) {
        if (this.modelIndexes.containsKey(s)) {
            return this.models[this.modelIndexes.get(s)];
        }
        for (int i = 0; i < this.models.length; ++i) {
            if (!this.models[i].objName.equalsIgnoreCase(s)) continue;
            this.modelIndexes.put(s, i);
            return this.models[i];
        }
        return null;
    }

    public void setModels(Model[] models) {
        this.models = models;
        this.displayLists = new int[models.length];
        for (int i = 0; i < models.length; ++i) {
            this.displayLists[i] = -1;
        }
    }

    public void setTextures(BufferedImage[] imgs) {
        this.textureFiles = imgs;
        this.textures = new int[imgs.length];
        this.loadingTextures = new boolean[imgs.length];
        for (int i = 0; i < imgs.length; ++i) {
            this.textures[i] = -1;
            this.loadingTextures[i] = false;
        }
    }

    public void enableBlending(boolean var) {
        this.blending = var;
    }

    private void blending() {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }

    public static void definePortal() {
        if (portalSetup != null) {
            portalSetup.definePortal();
        }
    }

    public static void openPortal() {
        if (portalSetup != null) {
            portalSetup.openPortal();
        }
    }

    public static void preOverlay() {
        if (portalSetup != null) {
            portalSetup.predrawOverlay();
        }
    }

    public static void closePortal() {
        if (portalSetup != null) {
            portalSetup.closePortal();
        }
    }

    public class MDLTransform {
        double tx = 0.0;
        double ty = 0.0;
        double tz = 0.0;
        double rx = 0.0;
        double ry = 0.0;
        double rz = 0.0;
        double ox = 0.0;
        double oy = 0.0;
        double oz = 0.0;
        double sx = 1.0;
        double sy = 1.0;
        double sz = 1.0;

        public void move(double x, double y, double z) {
            this.tx = x;
            this.ty = y;
            this.tz = z;
        }

        public void rotate(double x, double y, double z) {
            this.rx = x;
            this.ry = y;
            this.rz = z;
        }

        public void offset(double x, double y, double z) {
            this.ox = x;
            this.oy = y;
            this.oz = z;
        }

        public void scale(double x, double y, double z) {
            this.sx = x;
            this.sy = y;
            this.sz = z;
        }

        public void reset() {
            this.tx = 0.0;
            this.ty = 0.0;
            this.tz = 0.0;
            this.rx = 0.0;
            this.ry = 0.0;
            this.rz = 0.0;
            this.ox = 0.0;
            this.oy = 0.0;
            this.oz = 0.0;
            this.sx = 1.0;
            this.sy = 1.0;
            this.sz = 1.0;
        }

        public void transform() {
            GL11.glTranslated((double)this.tx, (double)this.ty, (double)this.tz);
            GL11.glScaled((double)this.sx, (double)this.sy, (double)this.sz);
            GL11.glRotated((double)this.rz, (double)0.0, (double)0.0, (double)1.0);
            GL11.glRotated((double)this.ry, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)this.rx, (double)1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)this.ox, (double)this.oy, (double)this.oz);
        }

        public void transformInverse() {
            GL11.glTranslated((double)(-this.ox), (double)(-this.oy), (double)(-this.oz));
            GL11.glRotated((double)(-this.rx), (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)(-this.ry), (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(-this.rz), (double)0.0, (double)0.0, (double)1.0);
            GL11.glScaled((double)(-this.sx), (double)(-this.sy), (double)(-this.sz));
            GL11.glTranslated((double)(-this.tx), (double)(-this.ty), (double)(-this.tz));
        }
    }
}

