/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.network.packets;

import com.swdteam.common.tileentity.TileEntityMobPlinth;
import com.swdteam.network.packets.AbstractServerMessageHandler;
import com.swdteam.utils.PlayerUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class Packet_SendPlinthNBT
implements IMessage {
    public NBTTagCompound tag;
    public String entityName;
    public BlockPos pos;

    public Packet_SendPlinthNBT() {
    }

    public Packet_SendPlinthNBT(BlockPos pos, String name, NBTTagCompound NBT2) {
        this.pos = pos;
        this.entityName = name;
        this.tag = NBT2;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entityName);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
    }

    public void fromBytes(ByteBuf buf) {
        this.entityName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public static class Handler
    extends AbstractServerMessageHandler<Packet_SendPlinthNBT> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, Packet_SendPlinthNBT message, MessageContext ctx) {
            WorldServer world = (WorldServer)player.field_70170_p;
            world.func_152344_a(() -> {
                TileEntity tile = world.func_175625_s(message.pos);
                if (tile != null && tile instanceof TileEntityMobPlinth) {
                    TileEntityMobPlinth plinth = (TileEntityMobPlinth)tile;
                    if (!plinth.locked) {
                        plinth.entityID = message.entityName;
                        plinth.JSON = message.tag;
                        plinth.refreshed = false;
                        plinth.func_189518_D_();
                        plinth.sendUpdates();
                    } else {
                        PlayerUtils.Messaging.sendMessageToPlayer(player, (ITextComponent)new TextComponentString(TextFormatting.RED + "This block has been locked. Unlock with /blockdata"));
                    }
                }
            });
            return null;
        }
    }
}

