/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.utils;

import java.lang.reflect.Field;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;

public class PlayerModelUtils {
    public static void createNewLimb(ModelPlayer model, float x, float y, float z, Field modelRendererField) {
        try {
            ModelRenderer modelRenderer = (ModelRenderer)modelRendererField.get(model);
            Field textureOffsetXField = ModelRenderer.class.getDeclaredFields()[2];
            Field textureOffsetYField = ModelRenderer.class.getDeclaredFields()[3];
            textureOffsetXField.setAccessible(true);
            textureOffsetYField.setAccessible(true);
            int textureOffsetX = textureOffsetXField.getInt(modelRenderer);
            int textureOffsetY = textureOffsetYField.getInt(modelRenderer);
            CustomModelRenderer newModelRenderer = new CustomModelRenderer((ModelBase)model, textureOffsetX, textureOffsetY, modelRenderer, modelRendererField);
            newModelRenderer.field_78804_l = modelRenderer.field_78804_l;
            newModelRenderer.func_78793_a(modelRenderer.field_78800_c, modelRenderer.field_78797_d, modelRenderer.field_78798_e);
            newModelRenderer.setAngles(x, y, z);
            modelRendererField.set(model, (Object)newModelRenderer);
            textureOffsetXField.setAccessible(false);
            textureOffsetYField.setAccessible(false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static void hidePlayerModel(ModelPlayer model, Field modelRendererField) {
        try {
            ModelRenderer modelRenderer = (ModelRenderer)modelRendererField.get(model);
            BlankModelRenderer newModelRenderer = new BlankModelRenderer((ModelBase)model, modelRenderer, modelRendererField);
            newModelRenderer.field_78804_l = modelRenderer.field_78804_l;
            modelRendererField.set(model, (Object)newModelRenderer);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static class CustomModelRenderer
    extends ModelRenderer {
        private float actualX;
        private float actualY;
        private float actualZ;
        private boolean changeAngles = false;
        private ModelPlayer modelPlayer;
        private final ModelRenderer old;
        private final Field f;

        private CustomModelRenderer(ModelBase model, int texOffX, int texOffY, ModelRenderer old, Field field) {
            super(model, "");
            if (model instanceof ModelPlayer) {
                this.modelPlayer = (ModelPlayer)model;
            }
            this.old = old;
            this.func_78784_a(texOffX, texOffY);
            this.f = field;
        }

        public void func_78785_a(float scale) {
            if (this.changeAngles) {
                this.field_78795_f = this.actualX;
                this.field_78796_g = this.actualY;
                this.field_78808_h = this.actualZ;
            }
            super.func_78785_a(scale);
        }

        public void reset() {
            if (this.f != null) {
                try {
                    this.f.set(this.modelPlayer, this.old);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }

        void setAnglesRadians(float x, float y, float z) {
            this.actualX = x;
            this.actualY = y;
            this.actualZ = z;
            this.changeAngles = true;
        }

        private void setAngles(float x, float y, float z) {
            this.setAnglesRadians((float)Math.toRadians(x), (float)Math.toRadians(y), (float)Math.toRadians(z));
        }
    }

    public static class BlankModelRenderer
    extends ModelRenderer {
        private ModelPlayer modelPlayer;
        private final ModelRenderer old;
        private final Field f;

        private BlankModelRenderer(ModelBase model, ModelRenderer old, Field field) {
            super(model, "");
            if (model instanceof ModelPlayer) {
                this.modelPlayer = (ModelPlayer)model;
            }
            this.old = old;
            this.f = field;
            this.field_78807_k = true;
        }

        public void reset() {
            if (this.f != null) {
                try {
                    this.f.set(this.modelPlayer, this.old);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

