/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.worldportal;

import com.swdteam.client.worldportal.CustomWorldClient;
import com.swdteam.client.worldportal.IWorldPortal;
import com.swdteam.client.worldportal.WorldRender;
import com.swdteam.client.worldportal.packet.PacketWorldPortal;
import com.swdteam.client.worldportal.sky.SkyEnd;
import com.swdteam.client.worldportal.storage.BlockData;
import com.swdteam.common.tileentity.TileEntityBotiPainting;
import com.swdteam.common.tileentity.TileEntityBrachiInteriorDoor;
import com.swdteam.common.tileentity.TileEntityGallifreyFallsPainting;
import com.swdteam.common.tileentity.TileEntityTardisFlightPanel;
import com.swdteam.common.tileentity.TileEntityUntemperedSchism;
import com.swdteam.main.TheDalekMod;
import com.swdteam.main.config.DMConfig;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.utils.Graphics;
import com.swdteam.utils.math.Vector2f;
import com.swdteam.utils.misc.ReflectionHelper;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BlockFluidRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class WorldPortal {
    public static HashMap<Long, BufferBuilder.State> worldrenders = new HashMap();
    public static List<String> tileEntities_ignore = new ArrayList<String>();
    public static BlockFluidRenderer blockFluidRenderer;
    private static long f382;
    private static long f383;

    public static void init() {
        WorldPortal.tilesToIgnore();
        try {
            blockFluidRenderer = new BlockFluidRenderer(BlockColors.func_186723_a());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void tilesToIgnore() {
        tileEntities_ignore.add(TileEntityBeacon.class.getSimpleName());
        tileEntities_ignore.add(TileEntityGallifreyFallsPainting.class.getSimpleName());
        tileEntities_ignore.add(TileEntityUntemperedSchism.class.getSimpleName());
        tileEntities_ignore.add(TileEntityTardisFlightPanel.class.getSimpleName());
        tileEntities_ignore.add(TileEntityBrachiInteriorDoor.class.getSimpleName());
        tileEntities_ignore.add(TileEntityBotiPainting.class.getSimpleName());
    }

    @SideOnly(value=Side.CLIENT)
    public static void render(IWorldPortal world, double x, double y, double z, float rot) {
        if (DMConfig.clientSide.renderBoti) {
            if (world != null && world.getWorldRender() != null) {
                GlStateManager.func_179094_E();
                GL11.glShadeModel((int)7425);
                if (world.getWorldRender().client != null) {
                    CustomWorldClient worldClient = world.getWorldRender().client;
                    if (worldClient != null && ((WorldClient)worldClient).field_73011_w != null && ((WorldClient)worldClient).field_73011_w.getSkyRenderer() != null) {
                        ((WorldClient)worldClient).field_73011_w.getSkyRenderer().render(Minecraft.func_71410_x().func_184121_ak(), (WorldClient)worldClient, Minecraft.func_71410_x());
                    } else {
                        switch (world.getWorldRender().renderData.dimension) {
                            case 1: {
                                SkyEnd.render();
                                break;
                            }
                            default: {
                                GlStateManager.func_179094_E();
                                GlStateManager.func_179140_f();
                                GlStateManager.func_179109_b((float)0.0f, (float)5.0f, (float)0.0f);
                                Minecraft.func_71410_x().field_71438_f.func_174976_a(Minecraft.func_71410_x().func_184121_ak(), 2);
                                Minecraft.func_71410_x().field_71438_f.func_180447_b(Minecraft.func_71410_x().func_184121_ak(), 2, 10.0, 10.0, 10.0);
                                GlStateManager.func_179109_b((float)0.0f, (float)-5.0f, (float)0.0f);
                                GlStateManager.func_179145_e();
                                GlStateManager.func_179121_F();
                            }
                        }
                    }
                } else {
                    world.getWorldRender().client = new CustomWorldClient(Minecraft.func_71410_x().field_71441_e, world.getDimension(), world.getWorldRender().renderData.worldTime);
                    WorldPortal.markTileBotiUpdate(x, y, z);
                }
                if (world.getWorldRender().client != null && world.getWorldRender().client.blocks != null && world.getWorldRender().client.blocks.size() > 0) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.5);
                    GlStateManager.func_179114_b((float)((int)rot), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
                    GlStateManager.func_179137_b((double)0.0, (double)-1.5, (double)0.0);
                    WorldPortal.renderBlocks(world);
                    GlStateManager.func_179121_F();
                } else {
                    world.requestRender();
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    public static void setRenderGlobal(WorldClient customWorldClient) {
        ObfuscationReflectionHelper.setPrivateValue(RenderGlobal.class, (Object)Minecraft.func_71410_x().field_71438_f, (Object)customWorldClient, (String)"world");
    }

    public static BlockPos setRenderOffsets(BlockPos selfPos, BlockPos pos, BlockPos renderPosition, boolean entity) {
        BlockPos altered = pos.func_177982_a(selfPos.func_177958_n() - renderPosition.func_177958_n(), selfPos.func_177956_o() - renderPosition.func_177956_o(), selfPos.func_177952_p() - renderPosition.func_177952_p());
        BlockPos finalPos = altered.func_177982_a(-selfPos.func_177958_n(), -selfPos.func_177956_o(), -selfPos.func_177952_p());
        return entity ? altered : finalPos;
    }

    public static void drawOutline(Vector2f s) {
        GlStateManager.func_179094_E();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)((float)Color.BLACK.getRed() / 255.0f), (float)((float)Color.BLACK.getGreen() / 255.0f), (float)((float)Color.BLACK.getBlue() / 255.0f), (float)((float)Color.BLACK.getAlpha() / 255.0f));
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(0.0, (double)s.y, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b((double)s.x, (double)s.y, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b((double)s.x, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        tes.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GlStateManager.func_179121_F();
    }

    public static void initTiles(WorldRender render) {
        if (render.client != null) {
            render.renderData.tileEntities = new ArrayList<TileEntity>();
            for (Map.Entry<BlockPos, BlockData> dataEntry : render.client.blocks.entrySet()) {
                if (dataEntry.getValue().getCompound() == null) continue;
                BlockPos pos = dataEntry.getKey();
                NBTTagCompound compound = dataEntry.getValue().getCompound();
                compound.func_74768_a("x", pos.func_177958_n());
                compound.func_74768_a("y", pos.func_177956_o());
                compound.func_74768_a("z", pos.func_177952_p());
                TileEntity tileEntity = TileEntity.func_190200_a((World)render.client, (NBTTagCompound)compound);
                tileEntity.func_145834_a((World)render.client);
                dataEntry.getValue().setTileEntity(tileEntity);
                try {
                    Class c = ReflectionHelper.getClassFromSuperClasses(tileEntity, TileEntity.class);
                    if (c != null) {
                        Field f = c.getDeclaredField(ReflectionHelper.doesFieldExist(TileEntity.class, "field_145847_g") ? "field_145847_g" : "blockMetadata");
                        f.setAccessible(true);
                        f.set(tileEntity, dataEntry.getValue().blockMetaData);
                        f.setAccessible(false);
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
                render.renderData.tileEntities.add(tileEntity);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderBlocks(IWorldPortal portal) {
        WorldRender world = portal.getWorldRender();
        if (System.currentTimeMillis() - f383 >= 10000L) {
            f383 = System.currentTimeMillis();
            worldrenders.clear();
        }
        if (!worldrenders.containsKey(world.renderData.identifier) || worldrenders.get(world.renderData.identifier) == null) {
            if (portal.getWorldRender().client != null) {
                GlStateManager.func_179094_E();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder vertexBuffer = tessellator.func_178180_c();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                HashMap<BlockPos, BlockData> see_Trough_blocks = null;
                Graphics.bindTexture(TextureMap.field_110575_b);
                CustomWorldClient customWorld = portal.getWorldRender().client;
                if (customWorld != null && customWorld.blocks != null) {
                    BlockPos blockPos;
                    IBlockState block;
                    for (Map.Entry<BlockPos, BlockData> entry : customWorld.blocks.entrySet()) {
                        block = entry.getValue().getState();
                        blockPos = entry.getKey();
                        if (blockPos == null || block == null || customWorld.func_175623_d(blockPos) || block == null) continue;
                        if (block.func_177230_c().func_180664_k() == BlockRenderLayer.TRANSLUCENT || block.func_185901_i() == EnumBlockRenderType.LIQUID || !block.func_185913_b() || !block.func_185914_p()) {
                            if (see_Trough_blocks == null) {
                                see_Trough_blocks = new HashMap<BlockPos, BlockData>();
                            }
                            see_Trough_blocks.put(blockPos, entry.getValue());
                            continue;
                        }
                        Minecraft.func_71410_x().func_175602_ab().func_175018_a(block, blockPos, (IBlockAccess)portal.getWorldRender().client, vertexBuffer);
                    }
                    if (see_Trough_blocks != null && see_Trough_blocks.size() > 0) {
                        for (Map.Entry<Object, BlockData> entry : see_Trough_blocks.entrySet()) {
                            block = entry.getValue().getState();
                            blockPos = (BlockPos)entry.getKey();
                            if (blockPos == null || block == null || customWorld.func_175623_d(blockPos) || block == null) continue;
                            if (block.func_185901_i() == EnumBlockRenderType.LIQUID) {
                                blockPos = blockPos.func_177984_a();
                                blockFluidRenderer.func_178270_a((IBlockAccess)customWorld, block, blockPos, vertexBuffer);
                                continue;
                            }
                            Minecraft.func_71410_x().func_175602_ab().func_175018_a(block, blockPos, (IBlockAccess)portal.getWorldRender().client, vertexBuffer);
                        }
                        see_Trough_blocks.clear();
                    }
                    worldrenders.put(world.renderData.identifier, vertexBuffer.func_181672_a());
                    tessellator.func_78381_a();
                    GlStateManager.func_179121_F();
                }
            }
        } else {
            GlStateManager.func_179094_E();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexBuffer = tessellator.func_178180_c();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            Graphics.bindTexture(TextureMap.field_110575_b);
            vertexBuffer.func_178993_a(worldrenders.get(world.renderData.identifier));
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
        if (portal.getWorldRender().client != null) {
            WorldPortal.renderTiles(portal, portal.getWorldRender().client);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderTiles(IWorldPortal portal, CustomWorldClient client) {
        GlStateManager.func_179094_E();
        Graphics.bindTexture(TextureMap.field_110575_b);
        ArrayList<TileEntity> tileRemoval = null;
        int pass = MinecraftForgeClient.getRenderPass();
        if (portal != null && portal.getWorldRender() != null && portal.getWorldRender().renderData.tileEntities != null) {
            for (int i = 0; i < portal.getWorldRender().renderData.tileEntities.size(); ++i) {
                TileEntity tileEntity = portal.getWorldRender().renderData.tileEntities.get(i);
                if (tileEntity == null || tileEntities_ignore.contains(tileEntity.getClass().getSimpleName()) || tileEntity.func_174877_v().func_177986_g() == portal.getPosToRender().func_177986_g() || !tileEntity.shouldRenderInPass(pass)) continue;
                if (tileEntity.func_145831_w() == null && client != null) {
                    tileEntity.func_145834_a((World)client);
                }
                try {
                    if (tileEntity instanceof ITickable && System.currentTimeMillis() - f382 >= 50L) {
                        f382 = System.currentTimeMillis();
                        ((ITickable)tileEntity).func_73660_a();
                    }
                    TileEntityRendererDispatcher.field_147556_a.func_147547_b(tileEntity).func_192841_a(tileEntity, (double)tileEntity.func_174877_v().func_177958_n(), (double)tileEntity.func_174877_v().func_177956_o(), (double)tileEntity.func_174877_v().func_177952_p(), 0.0f, -1, 1.0f);
                    if (GL11.glGetError() == 0) continue;
                    throw new Exception("Failed Render: " + tileEntity.getClass().getSimpleName());
                }
                catch (Exception e) {
                    if (tileEntities_ignore.contains(tileEntity.getClass().getSimpleName())) continue;
                    if (tileRemoval == null) {
                        tileRemoval = new ArrayList<TileEntity>();
                    }
                    tileRemoval.add(tileEntity);
                    tileEntities_ignore.add(tileEntity.getClass().getSimpleName());
                    TheDalekMod.LOG.warn(tileEntity.getClass().getSimpleName() + " couldn't be rendered!");
                }
            }
            if (tileRemoval != null) {
                portal.getWorldRender().renderData.tileEntities.removeAll(tileRemoval);
            }
            GlStateManager.func_179121_F();
        }
    }

    public static void markTileBotiUpdate(double x, double y, double z) {
        TileEntity tileEntity = Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos(x, y, z));
        if (tileEntity != null && tileEntity instanceof IWorldPortal) {
            ((IWorldPortal)tileEntity).requestRender();
        }
    }

    static {
        f382 = System.currentTimeMillis();
        f383 = System.currentTimeMillis();
    }

    public static class WorldPortalServer {
        public static void getWorldRender(final World world, final BlockPos posToRender, final int dimensiontorender, final BlockPos pos, final float rot, final boolean boti) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    world.func_73046_m().func_152344_a(new Runnable(){

                        @Override
                        public void run() {
                            WorldServer renderworld;
                            if (!world.field_72995_K && DimensionManager.isDimensionRegistered((int)dimensiontorender) && world.func_175726_f(pos).func_150802_k() && (renderworld = world.func_73046_m().func_71218_a(dimensiontorender)) != null && posToRender.func_177986_g() != 0L) {
                                WorldRender worlds = new WorldRender(posToRender);
                                int r = boti ? DMConfig.tardis.blockMapSizeBoti : DMConfig.tardis.blockMapSizeSoto;
                                worlds.renderData.setDimension(dimensiontorender);
                                worlds.renderData.setIdentifier(System.currentTimeMillis() + posToRender.func_177986_g());
                                worlds.renderData.setRotation(rot);
                                BlockPos renderpos = worlds.renderData.getRenderPos();
                                for (BlockPos p : BlockPos.func_177980_a((BlockPos)renderpos.func_177973_b(new Vec3i(r, 10, r)), (BlockPos)renderpos.func_177971_a(new Vec3i(r, 15, r)))) {
                                    IBlockState state = renderworld.func_180495_p(p);
                                    if (state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() == Blocks.field_180401_cv) continue;
                                    BlockData bl = new BlockData(state, renderworld.func_175625_s(p), renderworld.func_175699_k(p));
                                    double ba = Math.cos(-((double)(rot + 90.0f) * 0.0174533) + Math.atan2(p.func_177952_p() - posToRender.func_177952_p(), p.func_177958_n() - posToRender.func_177958_n())) + (double)0.1f;
                                    if (!(ba > 0.0) && (p.func_177952_p() != posToRender.func_177952_p() || p.func_177958_n() != posToRender.func_177958_n()) || p.func_177986_g() == renderpos.func_177986_g()) continue;
                                    worlds.renderData.blocks.put(p.func_177986_g(), bl);
                                }
                                for (BlockPos p : BlockPos.func_177980_a((BlockPos)renderpos.func_177973_b(new Vec3i(1, 0, 1)), (BlockPos)renderpos.func_177971_a(new Vec3i(1, 1, 1)))) {
                                    worlds.renderData.blocks.remove(p.func_177986_g());
                                }
                                if (worlds.renderData.blocks.size() > 0) {
                                    PacketHandler.INSTANCE.sendToAllAround(new PacketWorldPortal(worlds, pos), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 16.0));
                                }
                            }
                        }
                    });
                }
            }, "Boti").start();
        }

        public static WorldRender getWorldRenderSave(World world, BlockPos posToRender, BlockPos pos1, BlockPos pos2, int dimensiontorender, float rot) {
            WorldServer renderworld;
            if (world != null && !world.field_72995_K && (renderworld = world.func_73046_m().func_71218_a(dimensiontorender)) != null) {
                WorldRender worlds = new WorldRender(posToRender);
                worlds.renderData.setDimension(dimensiontorender);
                worlds.renderData.setIdentifier(System.currentTimeMillis() + posToRender.func_177986_g());
                worlds.renderData.setRotation(rot);
                worlds.renderData.setWorldTime(renderworld.func_72820_D());
                for (BlockPos p : BlockPos.func_177980_a((BlockPos)pos1, (BlockPos)pos2)) {
                    IBlockState state = renderworld.func_180495_p(p);
                    if (state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() == Blocks.field_180401_cv) continue;
                    BlockData bl = new BlockData(state, renderworld.func_175625_s(p), renderworld.func_175699_k(p));
                    double ba = Math.cos(-((double)(rot + 270.0f) * 0.0174533) + Math.atan2(p.func_177952_p() - posToRender.func_177952_p(), p.func_177958_n() - posToRender.func_177958_n())) + (double)0.1f;
                    if (!(ba > 0.0) && (p.func_177952_p() != posToRender.func_177952_p() || p.func_177958_n() != posToRender.func_177958_n())) continue;
                    worlds.renderData.blocks.put(p.func_177986_g(), bl);
                }
                return worlds;
            }
            return null;
        }

        public static WorldRender sendWorldRenderToClient(World world, BlockPos pos, WorldRender render) {
            if (!world.field_72995_K) {
                PacketHandler.INSTANCE.sendToAllAround(new PacketWorldPortal(render, pos), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 16.0));
            }
            return render;
        }

        public static WorldRender readWorldRenderSend(World world, BlockPos pos, String worldrender, boolean send) {
            if (world != null && !world.field_72995_K && !worldrender.equalsIgnoreCase("")) {
                WorldRender render = (WorldRender)TheDalekMod.GSON.fromJson(worldrender, WorldRender.class);
                if (render != null && render.renderData.blocks.size() > 0 && send) {
                    PacketHandler.INSTANCE.sendToAllAround(new PacketWorldPortal(render, pos), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 16.0));
                    return render;
                }
                if (render != null && !send) {
                    return render;
                }
            }
            return null;
        }

        public static void writeWorldRenderFile(WorldRender render, String name) {
            File file = new File("mods/Dalek Mod/cdn/paintings/");
            String file_dir = "/" + name + ".bp";
            if (!file.exists()) {
                file.mkdirs();
            }
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(file.getAbsolutePath() + file_dir));
                writer.write(render.toString());
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

