/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.world.gen.biomes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.init.Blocks;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenDoublePlant;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DeferredBiomeDecorator;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BiomeDM
extends IForgeRegistryEntry.Impl<BiomeDM> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final IBlockState STONE = Blocks.field_150348_b.func_176223_P();
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    protected static final IBlockState GRAVEL = Blocks.field_150351_n.func_176223_P();
    protected static final IBlockState RED_SANDSTONE = Blocks.field_180395_cM.func_176223_P();
    protected static final IBlockState SANDSTONE = Blocks.field_150322_A.func_176223_P();
    protected static final IBlockState ICE = Blocks.field_150432_aD.func_176223_P();
    protected static final IBlockState WATER = Blocks.field_150355_j.func_176223_P();
    public static final ObjectIntIdentityMap<BiomeDM> MUTATION_TO_BASE_ID_MAP = new ObjectIntIdentityMap();
    protected static final NoiseGeneratorPerlin TEMPERATURE_NOISE = new NoiseGeneratorPerlin(new Random(1234L), 1);
    protected static final NoiseGeneratorPerlin GRASS_COLOR_NOISE = new NoiseGeneratorPerlin(new Random(2345L), 1);
    protected static final WorldGenDoublePlant DOUBLE_PLANT_GENERATOR = new WorldGenDoublePlant();
    protected static final WorldGenTrees TREE_FEATURE = new WorldGenTrees(false);
    protected static final WorldGenBigTree BIG_TREE_FEATURE = new WorldGenBigTree(false);
    protected static final WorldGenSwamp SWAMP_FEATURE = new WorldGenSwamp();
    public static final RegistryNamespaced<ResourceLocation, BiomeDM> REGISTRY = GameData.getWrapper(BiomeDM.class);
    private final String biomeName;
    private final float baseHeight;
    private final float heightVariation;
    private final float temperature;
    private final float rainfall;
    private final int waterColor;
    private final boolean enableSnow;
    private final boolean enableRain;
    @Nullable
    private final String baseBiomeRegName;
    public IBlockState topBlock = Blocks.field_150349_c.func_176223_P();
    public IBlockState fillerBlock = Blocks.field_150346_d.func_176223_P();
    public BiomeDecorator decorator;
    protected List<SpawnListEntry> spawnableMonsterList = Lists.newArrayList();
    protected List<SpawnListEntry> spawnableCreatureList = Lists.newArrayList();
    protected List<SpawnListEntry> spawnableWaterCreatureList = Lists.newArrayList();
    protected List<SpawnListEntry> spawnableCaveCreatureList = Lists.newArrayList();
    protected Map<EnumCreatureType, List<SpawnListEntry>> modSpawnableLists = Maps.newHashMap();
    protected List<FlowerEntry> flowers = new ArrayList<FlowerEntry>();

    public static int getIdForBiome(BiomeDM biome) {
        return REGISTRY.func_148757_b((Object)biome);
    }

    @Nullable
    public static BiomeDM getBiomeForId(int id) {
        return (BiomeDM)((Object)REGISTRY.func_148754_a(id));
    }

    @Nullable
    public static BiomeDM getMutationForBiome(BiomeDM biome) {
        return (BiomeDM)((Object)MUTATION_TO_BASE_ID_MAP.func_148745_a(BiomeDM.getIdForBiome(biome)));
    }

    public BiomeDM(BiomeProperties properties) {
        this.biomeName = properties.biomeName;
        this.baseHeight = properties.baseHeight;
        this.heightVariation = properties.heightVariation;
        this.temperature = properties.temperature;
        this.rainfall = properties.rainfall;
        this.waterColor = properties.waterColor;
        this.enableSnow = properties.enableSnow;
        this.enableRain = properties.enableRain;
        this.baseBiomeRegName = properties.baseBiomeRegName;
        this.decorator = this.createBiomeDecorator();
        this.spawnableCreatureList.add(new SpawnListEntry(EntitySheep.class, 12, 4, 4));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityPig.class, 10, 4, 4));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityChicken.class, 10, 4, 4));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityCow.class, 8, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySpider.class, 100, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityZombie.class, 95, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityZombieVillager.class, 5, 1, 1));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySkeleton.class, 100, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityCreeper.class, 100, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySlime.class, 100, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityEnderman.class, 10, 1, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityWitch.class, 5, 1, 1));
        this.spawnableWaterCreatureList.add(new SpawnListEntry(EntitySquid.class, 10, 4, 4));
        this.spawnableCaveCreatureList.add(new SpawnListEntry(EntityBat.class, 10, 8, 8));
        this.addDefaultFlowers();
    }

    public BiomeDecorator createBiomeDecorator() {
        return this.getModdedBiomeDecorator(new BiomeDecorator());
    }

    public boolean isMutation() {
        return this.baseBiomeRegName != null;
    }

    public WorldGenAbstractTree getRandomTreeFeature(Random rand) {
        return rand.nextInt(10) == 0 ? BIG_TREE_FEATURE : TREE_FEATURE;
    }

    public WorldGenerator getRandomWorldGenForGrass(Random rand) {
        return new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    }

    public BlockFlower.EnumFlowerType pickRandomFlower(Random rand, BlockPos pos) {
        return rand.nextInt(3) > 0 ? BlockFlower.EnumFlowerType.DANDELION : BlockFlower.EnumFlowerType.POPPY;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSkyColorByTemp(float currentTemperature) {
        currentTemperature /= 3.0f;
        currentTemperature = MathHelper.func_76131_a((float)currentTemperature, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - currentTemperature * 0.05f), (float)(0.5f + currentTemperature * 0.1f), (float)1.0f);
    }

    public List<SpawnListEntry> getSpawnableList(EnumCreatureType creatureType) {
        switch (creatureType) {
            case MONSTER: {
                return this.spawnableMonsterList;
            }
            case CREATURE: {
                return this.spawnableCreatureList;
            }
            case WATER_CREATURE: {
                return this.spawnableWaterCreatureList;
            }
            case AMBIENT: {
                return this.spawnableCaveCreatureList;
            }
        }
        if (!this.modSpawnableLists.containsKey(creatureType)) {
            this.modSpawnableLists.put(creatureType, Lists.newArrayList());
        }
        return this.modSpawnableLists.get(creatureType);
    }

    public boolean getEnableSnow() {
        return this.isSnowyBiome();
    }

    public boolean canRain() {
        return this.isSnowyBiome() ? false : this.enableRain;
    }

    public boolean isHighHumidity() {
        return this.getRainfall() > 0.85f;
    }

    public float getSpawningChance() {
        return 0.1f;
    }

    public final float getTemperature(BlockPos pos) {
        if (pos.func_177956_o() > 64) {
            float f = (float)(TEMPERATURE_NOISE.func_151601_a((double)((float)pos.func_177958_n() / 8.0f), (double)((float)pos.func_177952_p() / 8.0f)) * 4.0);
            return this.getDefaultTemperature() - (f + (float)pos.func_177956_o() - 64.0f) * 0.05f / 30.0f;
        }
        return this.getDefaultTemperature();
    }

    public final void generateBiomeTerrainDM(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = 70;
        IBlockState iblockstate = this.topBlock;
        IBlockState iblockstate1 = this.fillerBlock;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 <= rand.nextInt(5)) {
                chunkPrimerIn.func_177855_a(i1, j1, l, BEDROCK);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != Blocks.field_150348_b) continue;
            if (j == -1) {
                if (k <= 0) {
                    iblockstate = AIR;
                    iblockstate1 = STONE;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    iblockstate = this.topBlock;
                    iblockstate1 = this.fillerBlock;
                }
                if (j1 < i && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                    iblockstate = this.getTemperature((BlockPos)blockpos$mutableblockpos.func_181079_c(x, j1, z)) < 0.15f ? ICE : WATER;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    iblockstate = AIR;
                    iblockstate1 = STONE;
                    chunkPrimerIn.func_177855_a(i1, j1, l, GRAVEL);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
                continue;
            }
            if (j <= 0) continue;
            chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
            if (--j != 0 || iblockstate1.func_177230_c() != Blocks.field_150354_m || k <= 1) continue;
            j = rand.nextInt(4) + Math.max(0, j1 - 63);
            iblockstate1 = iblockstate1.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? RED_SANDSTONE : SANDSTONE;
        }
    }

    public Class<? extends BiomeDM> getBiomeClass() {
        return ((Object)((Object)this)).getClass();
    }

    public TempCategory getTempCategory() {
        if ((double)this.getDefaultTemperature() < 0.2) {
            return TempCategory.COLD;
        }
        return (double)this.getDefaultTemperature() < 1.0 ? TempCategory.MEDIUM : TempCategory.WARM;
    }

    @Nullable
    public static BiomeDM getBiome(int id) {
        return BiomeDM.getBiome(id, null);
    }

    public static BiomeDM getBiome(int biomeId, BiomeDM fallback) {
        BiomeDM biome = BiomeDM.getBiomeForId(biomeId);
        return biome == null ? fallback : biome;
    }

    public boolean ignorePlayerSpawnSuitability() {
        return false;
    }

    public final float getBaseHeight() {
        return this.baseHeight;
    }

    public final float getRainfall() {
        return this.rainfall;
    }

    @SideOnly(value=Side.CLIENT)
    public final String getBiomeName() {
        return this.biomeName;
    }

    public final float getHeightVariation() {
        return this.heightVariation;
    }

    public final float getDefaultTemperature() {
        return this.temperature;
    }

    public final boolean isSnowyBiome() {
        return this.enableSnow;
    }

    public BiomeDecorator getModdedBiomeDecorator(BiomeDecorator original) {
        return new DeferredBiomeDecorator(original);
    }

    public void addDefaultFlowers() {
        this.addFlower(Blocks.field_150327_N.func_176223_P().func_177226_a(Blocks.field_150327_N.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.DANDELION), 20);
        this.addFlower(Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.POPPY), 10);
    }

    public void addFlower(IBlockState state, int weight) {
        this.flowers.add(new FlowerEntry(state, weight));
    }

    public void plantFlower(World world, Random rand, BlockPos pos) {
        if (this.flowers.isEmpty()) {
            return;
        }
        FlowerEntry flower = (FlowerEntry)WeightedRandom.func_76271_a((Random)rand, this.flowers);
        if (flower == null || flower.state == null || flower.state.func_177230_c() instanceof BlockBush && !((BlockBush)flower.state.func_177230_c()).func_180671_f(world, pos, flower.state)) {
            return;
        }
        world.func_180501_a(pos, flower.state, 3);
    }

    public static void registerBiome(int id, String name, BiomeDM biome) {
        REGISTRY.func_177775_a(id, (Object)new ResourceLocation(name), (Object)biome);
        if (biome.isMutation()) {
            MUTATION_TO_BASE_ID_MAP.func_148746_a((Object)biome, BiomeDM.getIdForBiome((BiomeDM)((Object)REGISTRY.func_82594_a((Object)new ResourceLocation(biome.baseBiomeRegName)))));
        }
    }

    public static enum TempCategory {
        OCEAN,
        COLD,
        MEDIUM,
        WARM;

    }

    public static class SpawnListEntry
    extends WeightedRandom.Item {
        public Class<? extends EntityLiving> entityClass;
        public int minGroupCount;
        public int maxGroupCount;

        public SpawnListEntry(Class<? extends EntityLiving> entityclassIn, int weight, int groupCountMin, int groupCountMax) {
            super(weight);
            this.entityClass = entityclassIn;
            this.minGroupCount = groupCountMin;
            this.maxGroupCount = groupCountMax;
        }

        public String toString() {
            return this.entityClass.getSimpleName() + "*(" + this.minGroupCount + "-" + this.maxGroupCount + "):" + this.field_76292_a;
        }

        public EntityLiving newInstance(World world) throws Exception {
            EntityEntry entry = EntityRegistry.getEntry(this.entityClass);
            if (entry != null) {
                return (EntityLiving)entry.newInstance(world);
            }
            return this.entityClass.getConstructor(World.class).newInstance(world);
        }
    }

    public static class BiomeProperties {
        private final String biomeName;
        private float baseHeight = 0.1f;
        private float heightVariation = 0.2f;
        private float temperature = 0.5f;
        private float rainfall = 0.5f;
        private int waterColor = 0xFFFFFF;
        private boolean enableSnow;
        private boolean enableRain = true;
        @Nullable
        private String baseBiomeRegName;

        public BiomeProperties(String nameIn) {
            this.biomeName = nameIn;
        }

        public BiomeProperties setTemperature(float temperatureIn) {
            if (temperatureIn > 0.1f && temperatureIn < 0.2f) {
                throw new IllegalArgumentException("Please avoid temperatures in the range 0.1 - 0.2 because of snow");
            }
            this.temperature = temperatureIn;
            return this;
        }

        public BiomeProperties setRainfall(float rainfallIn) {
            this.rainfall = rainfallIn;
            return this;
        }

        public BiomeProperties setBaseHeight(float baseHeightIn) {
            this.baseHeight = baseHeightIn;
            return this;
        }

        public BiomeProperties setHeightVariation(float heightVariationIn) {
            this.heightVariation = heightVariationIn;
            return this;
        }

        public BiomeProperties setRainDisabled() {
            this.enableRain = false;
            return this;
        }

        public BiomeProperties setSnowEnabled() {
            this.enableSnow = true;
            return this;
        }

        public BiomeProperties setWaterColor(int waterColorIn) {
            this.waterColor = waterColorIn;
            return this;
        }

        public BiomeProperties setBaseBiome(String nameIn) {
            this.baseBiomeRegName = nameIn;
            return this;
        }
    }

    public static class FlowerEntry
    extends WeightedRandom.Item {
        public final IBlockState state;

        public FlowerEntry(IBlockState state, int weight) {
            super(weight);
            this.state = state;
        }
    }
}

