/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.world.gen.structures.global;

import com.google.common.base.Predicate;
import com.swdteam.common.entity.EntityBaseModelID;
import com.swdteam.common.entity.EntityCyberMat;
import com.swdteam.common.entity.EntityCyberman;
import com.swdteam.common.entity.EntityDavros;
import com.swdteam.common.entity.EntityKaled;
import com.swdteam.common.entity.dalek.EntityDalek;
import com.swdteam.common.init.DMBiomes;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.init.DMSchematics;
import com.swdteam.common.world.gen.structures.classic.WorldGenClassicTree;
import com.swdteam.common.world.gen.structures.gallifrey.WorldGenGallifreyTrees;
import com.swdteam.common.world.gen.structures.gallifrey.WorldGenWeanskrike;
import com.swdteam.common.world.gen.structures.global.WorldGenComet;
import com.swdteam.common.world.gen.structures.global.WorldGenMoonOrePile;
import com.swdteam.common.world.gen.structures.mondas.WorldGenMondasTree;
import com.swdteam.common.world.gen.structures.moon.WorldGenCyberHut;
import com.swdteam.common.world.gen.structures.skaro.WorldGenObsidianHorizontal;
import com.swdteam.common.world.gen.structures.skaro.WorldGenObsidianVerticalX;
import com.swdteam.common.world.gen.structures.skaro.WorldGenObsidianVerticalZ;
import com.swdteam.common.world.gen.structures.skaro.WorldGenOrePile;
import com.swdteam.common.world.gen.structures.skaro.WorldGenSkaroLakes;
import com.swdteam.common.world.gen.structures.skaro.WorldGenSkaroTrees;
import com.swdteam.common.world.gen.structures.skaro.WorldGenSkaroTreesShort;
import com.swdteam.common.world.gen.structures.trenzalore.TrenzaloreGrave;
import com.swdteam.common.world.gen.structures.trenzalore.TrenzaloreWorldGenTrees;
import com.swdteam.common.world.gen.structures.vortis.WorldGenCrystaline;
import com.swdteam.main.config.DMConfig;
import com.swdteam.utils.world.Schematic;
import com.swdteam.utils.world.SchematicUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreGeneration
implements IWorldGenerator {
    private final WorldGenGallifreyTrees trees = new WorldGenGallifreyTrees();
    private final WorldGenOrePile orePile = new WorldGenOrePile(DMBlocks.SkaroSand, DMBlocks.dalekaniumOre);
    private final WorldGenMoonOrePile orePileMoon = new WorldGenMoonOrePile();
    private final WorldGenComet oreMeteor = new WorldGenComet();
    private final WorldGenCyberHut cyHut = new WorldGenCyberHut();

    private void generateOre(IBlockState ore, World world, Random random, int x, int z, int minY, int maxY, int size, int chances) {
        int deltaY = maxY - minY;
        for (int i = 0; i < chances; ++i) {
            BlockPos pos = new BlockPos(x + random.nextInt(16), minY + random.nextInt(deltaY), z + random.nextInt(16));
            WorldGenMinable generator = new WorldGenMinable(ore, size);
            generator.func_180709_b(world, random, pos);
        }
    }

    private void generatePlant(IBlockState plant, World world, Random random, int x, int z, int minY, int maxY, int chances, Block ground) {
        for (int i = 0; i < chances; ++i) {
            int randPosX = x + 1 + random.nextInt(14);
            int randPosZ = z + 1 + random.nextInt(14);
            int randPosY = world.func_175672_r(new BlockPos(randPosX, 0, randPosZ)).func_177956_o();
            BlockPos pos = new BlockPos(randPosX, randPosY, randPosZ);
            if (randPosY <= minY || randPosY >= maxY || world.func_180495_p(new BlockPos(randPosX, randPosY - 1, randPosZ)).func_177230_c() != ground) continue;
            world.func_175656_a(pos, plant);
        }
    }

    private void generateLandmines(IBlockState plant, World world, Random random, int x, int z, int minY, int maxY, int chances, Block ground) {
        for (int i = 0; i < chances; ++i) {
            int randPosX = x + random.nextInt(16);
            int randPosZ = z + random.nextInt(16);
            int randPosY = world.func_175672_r(new BlockPos(randPosX, 0, randPosZ)).func_177956_o();
            BlockPos pos = new BlockPos(randPosX, randPosY, randPosZ);
            if (randPosY <= minY || randPosY >= maxY || world.func_180495_p(new BlockPos(randPosX, randPosY - 1, randPosZ)).func_177230_c() != ground) continue;
            world.func_175656_a(pos, plant);
            if (random.nextInt(15) != 1) continue;
            world.func_175656_a(pos.func_177982_a(0, -2, 0), DMBlocks.landmineexplosive.func_176223_P());
        }
    }

    private void generateOreDIM(IBlockState ore, World world, Random random, int x, int z, int minY, int maxY, int size, int chances, Block blk) {
        int deltaY = maxY - minY;
        Predicate predicate = input -> input.func_177230_c() == blk;
        for (int i = 0; i < chances; ++i) {
            BlockPos pos = new BlockPos(x + random.nextInt(16), minY + random.nextInt(deltaY), z + random.nextInt(16));
            WorldGenMinable generator = new WorldGenMinable(ore, size, predicate);
            generator.func_180709_b(world, random, pos);
        }
    }

    public static void spawnDaleks(World world, Random rand, int chunkX, int chunkZ, int maindalek, int leaderdalek, boolean dospecial, int specialdalek) {
        if (rand.nextInt(6) == 2) {
            int randPosX = chunkX * 16 + rand.nextInt(15);
            int randPosY = 70;
            int randPosZ = chunkZ * 16 + rand.nextInt(15);
            BlockPos pos = new BlockPos(randPosX, randPosY, randPosZ);
            pos = world.func_175672_r(pos);
            EntityDalek dalek = new EntityDalek(world);
            dalek.func_70012_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), world.field_73012_v.nextInt(360), 0.0f);
            if (rand.nextInt(30) == 2) {
                dalek.setDalekID(leaderdalek);
            } else if (dospecial && rand.nextInt(100) == 2) {
                dalek.setDalekID(specialdalek);
            } else {
                dalek.setDalekID(maindalek);
            }
            world.func_72838_d((Entity)dalek);
        }
    }

    public static void spawnMonster(World world, Random rand, int chunkX, int chunkZ, Entity monster, int maindalek, int leaderdalek, boolean dospecial, int specialdalek) {
        if (rand.nextInt(6) == 2) {
            int randPosX = chunkX * 16 + rand.nextInt(15);
            int randPosY = 70;
            int randPosZ = chunkZ * 16 + rand.nextInt(15);
            BlockPos pos = new BlockPos(randPosX, randPosY, randPosZ);
            pos = world.func_175672_r(pos);
            monster.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (float)world.field_73012_v.nextInt(360), 0.0f);
            if (rand.nextInt(10) == 2) {
                ((EntityBaseModelID)monster).setSubEntityID(leaderdalek);
            } else if (dospecial && rand.nextInt(100) == 2) {
                ((EntityBaseModelID)monster).setSubEntityID(specialdalek);
            } else {
                ((EntityBaseModelID)monster).setSubEntityID(maindalek);
            }
            world.func_72838_d(monster);
        }
    }

    private void generateClassicTrees(World world, Random rand, int chunkX, int chunkZ) {
        int randPosZ;
        int randPosY;
        int randPosX;
        if (rand.nextBoolean() && world.func_180495_p(new BlockPos(randPosX = chunkX + rand.nextInt(8) + 4, randPosY = world.func_175672_r(new BlockPos(randPosX, 0, randPosZ = chunkZ + rand.nextInt(8) + 4)).func_177956_o() - 1, randPosZ)).func_177230_c() == DMBlocks.classic_grass) {
            new WorldGenClassicTree().generate(world, rand, randPosX, randPosY + 1, randPosZ);
        }
    }

    private void generateSkaroLakes(World world, Random rand, int chunkX, int chunkZ) {
        if (rand.nextBoolean()) {
            int randPosX = chunkX + rand.nextInt(8) + 4;
            int randPosZ = chunkZ + rand.nextInt(8) + 4;
            int randPosY = world.func_175672_r(new BlockPos(randPosX, 0, randPosZ)).func_177956_o() - 1;
            BlockPos poslake = new BlockPos(randPosX, randPosY, randPosZ);
            new WorldGenSkaroLakes(DMBlocks.toxic_waste).func_180709_b(world, rand, poslake);
        }
    }

    private void generateGraves(World world, Random rand, int chunkX, int chunkZ, int chance) {
        for (int i = 0; i < chance; ++i) {
            int randPosZ;
            int randPosY;
            int randPosX = chunkX + rand.nextInt(16);
            if (world.func_180495_p(new BlockPos(randPosX, randPosY = world.func_175672_r(new BlockPos(randPosX, 0, randPosZ = chunkZ + rand.nextInt(12) + 2)).func_177956_o() - 1, randPosZ)).func_177230_c() != DMBlocks.Granite || !world.field_73012_v.nextBoolean()) continue;
            TrenzaloreGrave.generate(world, rand, randPosX, randPosY + 1, randPosZ);
        }
    }

    private void generateTrenzaloreTrees(World world, Random rand, int chunkX, int chunkZ, int chance) {
        for (int i = 0; i < chance; ++i) {
            int randPosZ;
            int randPosY;
            int randPosX = chunkX + rand.nextInt(9) + 3;
            if (world.func_180495_p(new BlockPos(randPosX, randPosY = world.func_175672_r(new BlockPos(randPosX, 0, randPosZ = chunkZ + rand.nextInt(9) + 3)).func_177956_o() - 1, randPosZ)).func_177230_c() != Blocks.field_150349_c) continue;
            new TrenzaloreWorldGenTrees().generate(world, rand, randPosX, randPosY + 1, randPosZ);
        }
    }

    private void generateSkaroTrees(World world, Random rand, int chunkX, int chunkZ, int chance) {
        for (int i = 0; i < chance; ++i) {
            int randPosZ;
            int randPosY;
            int randPosX = chunkX + rand.nextInt(10) + 3;
            if (world.func_180495_p(new BlockPos(randPosX, randPosY = world.func_175672_r(new BlockPos(randPosX, 0, randPosZ = chunkZ + rand.nextInt(10) + 3)).func_177956_o() - 1, randPosZ)).func_177230_c() != DMBlocks.skaro_grass) continue;
            if (rand.nextBoolean()) {
                new WorldGenSkaroTrees().generate(world, rand, randPosX, randPosY + 1, randPosZ);
                continue;
            }
            new WorldGenSkaroTreesShort().generate(world, rand, randPosX, randPosY + 1, randPosZ);
        }
    }

    private void generateMondasTrees(World world, Random rand, int chunkX, int chunkZ, int chance) {
        for (int i = 0; i < chance; ++i) {
            int randPosZ;
            int randPosY;
            int randPosX;
            if (!rand.nextBoolean() || world.func_180495_p(new BlockPos(randPosX = chunkX + rand.nextInt(13) + 1, randPosY = world.func_175672_r(new BlockPos(randPosX, 0, randPosZ = chunkZ + rand.nextInt(13) + 1)).func_177956_o() - 1, randPosZ)).func_177230_c() != Blocks.field_150433_aE) continue;
            new WorldGenMondasTree().generate(world, rand, randPosX, randPosY + 1, randPosZ);
        }
    }

    private void generateCrystaline(World world, Random rand, int chunkX, int chunkZ, int chance) {
        for (int i = 0; i < chance; ++i) {
            int randPosX = chunkX + rand.nextInt(14) + 1;
            int randPosZ = chunkZ + rand.nextInt(14) + 1;
            int randPosY = 15 + rand.nextInt(45);
            if (world.func_180495_p(new BlockPos(randPosX, randPosY, randPosZ)).func_177230_c() != Blocks.field_150350_a) continue;
            new WorldGenCrystaline().generate(world, rand, randPosX, randPosY, randPosZ);
        }
    }

    private void generateWeanskrike(World world, Random rand, int chunkX, int chunkZ, int chance) {
        for (int i = 0; i < chance; ++i) {
            int randPosZ;
            int randPosY;
            int randPosX;
            if (!rand.nextBoolean() || world.func_180495_p(new BlockPos(randPosX = chunkX + rand.nextInt(13) + 1, randPosY = world.func_175672_r(new BlockPos(randPosX, 0, randPosZ = chunkZ + rand.nextInt(13) + 1)).func_177956_o() - 1, randPosZ)).func_177230_c() != DMBlocks.GallifreySand) continue;
            new WorldGenWeanskrike().generate(world, rand, randPosX, randPosY + 1, randPosZ);
        }
    }

    private void generateMondasHouse(World world, Random rand, int chunkX, int chunkZ, Schematic house) {
        int randPosX = chunkX;
        int randPosZ = chunkZ;
        boolean gen = true;
        int randPosY = world.func_175672_r(new BlockPos(randPosX, 0, randPosZ)).func_177956_o() - 1;
        BlockPos pastePos = new BlockPos(randPosX, randPosY, randPosZ);
        if (world.func_180495_p(pastePos).func_177230_c() == Blocks.field_150433_aE) {
            for (BlockPos pos : BlockPos.func_191532_a((int)randPosX, (int)(randPosY + 1), (int)randPosZ, (int)(randPosX + 7), (int)(randPosY + 2), (int)(randPosZ + 7))) {
                if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a) continue;
                gen = false;
            }
        }
        if (randPosY <= 70 && randPosY >= 61 && gen) {
            SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pastePos, house, SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.MONDAS_LOOT});
        }
    }

    private void generateStructure(World world, Random rand, int chunkX, int chunkZ, Schematic ship, int height, int size, SchematicUtils.IReplaceBlockSpawn[] blockReplace, Block block, boolean pasteair, boolean randomplace) {
        int randPosX = chunkX;
        int randPosZ = chunkZ;
        if (randomplace) {
            randPosX += rand.nextInt(11);
            randPosZ += rand.nextInt(11);
        }
        boolean gen = true;
        int randPosY = world.func_175672_r(new BlockPos(randPosX, 0, randPosZ)).func_177956_o() - 1;
        BlockPos pastePos = new BlockPos(randPosX, randPosY, randPosZ);
        if (world.func_180495_p(pastePos).func_177230_c() == block) {
            for (BlockPos pos : BlockPos.func_191532_a((int)randPosX, (int)(randPosY + 1), (int)randPosZ, (int)(randPosX + size), (int)(randPosY + 5), (int)(randPosZ + size))) {
                if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a) continue;
                gen = false;
            }
        }
        if (randPosY <= 75 && randPosY >= 59 && gen) {
            if (pasteair) {
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pastePos.func_177982_a(0, -height, 0), ship, SchematicUtils.BlockMap.DM_1_12_2, null, null, blockReplace);
            } else {
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pastePos.func_177982_a(0, -height, 0), ship, SchematicUtils.BlockMap.DM_1_12_2, new IBlockState[]{Blocks.field_150350_a.func_176223_P()}, null, blockReplace);
            }
        }
    }

    private void generateSpaceship1(World world, Random rand, int chunkX, int chunkZ, Schematic ship, int height, int size, SchematicUtils.IReplaceBlockSpawn[] blockReplace) {
        int randPosX = chunkX;
        int randPosZ = chunkZ;
        boolean gen = true;
        int randPosY = world.func_175672_r(new BlockPos(randPosX, 0, randPosZ)).func_177956_o() - 1;
        BlockPos pastePos = new BlockPos(randPosX, randPosY, randPosZ);
        if (world.func_180495_p(pastePos).func_177230_c() == Blocks.field_150349_c || world.func_180495_p(pastePos).func_177230_c() == DMBlocks.moon_rock_2 || world.func_180495_p(pastePos).func_177230_c() == DMBlocks.moon_rock) {
            for (BlockPos pos : BlockPos.func_191532_a((int)(randPosX + 3), (int)(randPosY + 2), (int)(randPosZ + 3), (int)(randPosX + size), (int)(randPosY + 5), (int)(randPosZ + size))) {
                if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a) continue;
                gen = false;
            }
        }
        if (randPosY <= 75 && randPosY >= 59 && gen) {
            SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pastePos.func_177982_a(0, -height, 0), ship, SchematicUtils.BlockMap.DM_1_12_2, new IBlockState[]{Blocks.field_150350_a.func_176223_P()}, null, blockReplace);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        EntityMob c;
        BlockPos posbiome;
        BlockPos pos;
        int dimID = world.field_73011_w.getDimension();
        if (dimID == DMConfig.dimensionIDs.Moon_Dimension_ID) {
            this.generateOreDIM(DMBlocks.bTitaniumOre.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 16, 64, 3 + random.nextInt(2), 15, DMBlocks.moon_rock);
            this.generateOreDIM(DMBlocks.eggShellBlock.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 16, 60, 8 + random.nextInt(10), 20, DMBlocks.moon_rock);
            this.generateOreDIM(DMBlocks.bcrystaline_ore.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 15, 66, 5 + random.nextInt(2), 15, DMBlocks.moon_rock);
            this.generateOreDIM(DMBlocks.cheeseOre.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 16, 24, 2 + random.nextInt(5), 20, DMBlocks.moon_rock);
            this.generateOreDIM(Blocks.field_150348_b.func_176203_a(4), world, random, chunkX * 16, chunkZ * 16, 30, 50, 5 + random.nextInt(5), 20, DMBlocks.moon_rock);
            this.generateOreDIM(Blocks.field_150348_b.func_176203_a(5), world, random, chunkX * 16, chunkZ * 16, 5, 30, 4 + random.nextInt(5), 10, DMBlocks.moon_rock);
            this.generateOreDIM(Blocks.field_192444_dS.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 20, 50, 3 + random.nextInt(3), 3, DMBlocks.moon_rock);
        }
        if (dimID == DMConfig.dimensionIDs.Trenzalore_Dimension_ID) {
            this.generateOreDIM(DMBlocks.rock_Trenz.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 20, 42, 5 + random.nextInt(10), 1, DMBlocks.Granite);
            this.generateOreDIM(DMBlocks.granitesteel.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 10, 60, 2 + random.nextInt(5), 10, DMBlocks.Granite);
            this.generateOreDIM(DMBlocks.graniteiron.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 10, 45, 3 + random.nextInt(5), 15, DMBlocks.Granite);
            this.generateOreDIM(DMBlocks.granitegold.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 10, 55, 2 + random.nextInt(5), 10, DMBlocks.Granite);
            this.generateOreDIM(DMBlocks.granitediamond.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 8, 20, 2 + random.nextInt(3), 1, DMBlocks.Granite);
            this.generateOreDIM(Blocks.field_192444_dS.func_176203_a(15), world, random, chunkX * 16, chunkZ * 16, 20, 40, 3 + random.nextInt(3), 3, DMBlocks.Granite);
            pos = new BlockPos(chunkX * 16, 62, chunkZ * 16);
            if (chunkX == -2 && chunkZ == 20) {
                BlockPos ch1 = new BlockPos(-48, 62, 320);
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, ch1, DMSchematics.CHRISTMAS1, SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.VILLAGER_SPAWN});
            }
            if (chunkX == -7 && chunkZ == 22) {
                BlockPos ch2 = new BlockPos(-127, 61, 352);
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.CITADEL, world, ch2, DMSchematics.CHRISTMAS2, SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.VILLAGER_SPAWN, DMSchematics.IRONGOLEM_SPAWN});
            }
            if (chunkX == -7 && chunkZ == 20) {
                BlockPos ch3 = new BlockPos(-127, 61, 320);
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, ch3, DMSchematics.CHRISTMAS3, SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.VILLAGER_SPAWN, DMSchematics.IRONGOLEM_SPAWN});
            }
            if (chunkX == -7 && chunkZ == 25) {
                BlockPos ch4 = new BlockPos(-127, 61, 400);
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, ch4, DMSchematics.CHRISTMAS4, SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.VILLAGER_SPAWN});
            }
            if (world.func_180494_b(pos) == DMBiomes.BIOME_TRENZALOREPLAINS) {
                this.generatePlant(Blocks.field_150362_t.func_176203_a(1), world, random, chunkX * 16, chunkZ * 16, 40, 80, 1, (Block)Blocks.field_150349_c);
                int housegen = random.nextInt(90);
                if (housegen >= 60 && chunkX % 2 == 0 && chunkZ % 2 == 0) {
                    this.generateTrenzaloreTrees(world, random, chunkX * 16, chunkZ * 16, 1);
                }
                if (housegen == 0 && chunkX % 4 == 0 && chunkZ % 4 == 0) {
                    this.generateSpaceship1(world, random, chunkX * 16, chunkZ * 16, DMSchematics.SHIP2, 4, 15, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.TRENZALORE_LOOT});
                }
                if (housegen == 1 && chunkX % 4 == 0 && chunkZ % 4 == 0) {
                    this.generateSpaceship1(world, random, chunkX * 16, chunkZ * 16, DMSchematics.SHIP3, 2, 15, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.CYBERAID_SPAWN, DMSchematics.TRENZALORE_LOOT});
                }
                if (housegen == 2 && chunkX % 4 == 0 && chunkZ % 4 == 0) {
                    this.generateSpaceship1(world, random, chunkX * 16, chunkZ * 16, DMSchematics.SHIP4, 2, 15, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.SONTARAN, DMSchematics.TRENZALORE_LOOT});
                }
                if (housegen == 3 && chunkX % 4 == 0 && chunkZ % 4 == 0) {
                    this.generateSpaceship1(world, random, chunkX * 16, chunkZ * 16, DMSchematics.SHIP7, 2, 15, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.TRENZALORE_LOOT});
                }
                if (housegen == 4 && chunkX % 4 == 0 && chunkZ % 4 == 0) {
                    this.generateSpaceship1(world, random, chunkX * 16, chunkZ * 16, DMSchematics.SHIP8, -5, 10, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.DALEK_SPAWN});
                }
                if (housegen == 5 && chunkX % 4 == 0 && chunkZ % 4 == 0 && random.nextBoolean()) {
                    this.generateSpaceship1(world, random, chunkX * 16, chunkZ * 16, DMSchematics.SHIP9, 3, 10, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.QUARK_SPAWN});
                }
                if (housegen == 6 && chunkX % 4 == 0 && chunkZ % 4 == 0) {
                    this.generateSpaceship1(world, random, chunkX * 16, chunkZ * 16, DMSchematics.SHIP10, 4, 10, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.TRENZALORE_LOOT});
                }
                if (housegen == 7 && chunkX % 4 == 0 && chunkZ % 4 == 0) {
                    this.generateSpaceship1(world, random, chunkX * 16, chunkZ * 16, DMSchematics.SHIP12, 4, 10, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.CLOCKWORK_SPAWN, DMSchematics.TRENZALORE_LOOT});
                }
                if (housegen == 8 && chunkX % 4 == 0 && chunkZ % 4 == 0) {
                    this.generateSpaceship1(world, random, chunkX * 16, chunkZ * 16, DMSchematics.SHIP13, 2, 10, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.WHITEROBOT_SPAWN, DMSchematics.TRENZALORE_LOOT});
                }
                if (housegen == 9 && chunkX % 4 == 0 && chunkZ % 4 == 0) {
                    this.generateSpaceship1(world, random, chunkX * 16, chunkZ * 16, DMSchematics.SHIP14, 3, 10, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.MONOID_SPAWN, DMSchematics.MUSIC_LOOT});
                }
                this.generatePlant(Blocks.field_150329_H.func_176203_a(1), world, random, chunkX * 16, chunkZ * 16, 62, 80, 5, (Block)Blocks.field_150349_c);
            }
            if (world.func_180494_b(pos) == DMBiomes.BIOME_TRENZALOREGRAVE) {
                this.generateGraves(world, random, chunkX * 16, chunkZ * 16, 3);
            }
            if (world.func_180494_b(pos) == DMBiomes.BIOME_TRENZALORECRATER && random.nextInt(80) == 10 && chunkX % 4 == 0 && chunkZ % 4 == 0) {
                BlockPos posair = new BlockPos(chunkX * 16, 120 + world.field_73012_v.nextInt(30), chunkZ * 16);
                if (random.nextBoolean()) {
                    SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, posair, DMSchematics.SHIP5, SchematicUtils.BlockMap.DM_1_12_2, new IBlockState[]{Blocks.field_150350_a.func_176223_P()}, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.SONTARAN, DMSchematics.TRENZALORE_LOOT});
                } else {
                    SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, posair, DMSchematics.SHIP6, SchematicUtils.BlockMap.DM_1_12_2, new IBlockState[]{Blocks.field_150350_a.func_176223_P()}, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.ZYGON_SPAWN, DMSchematics.ZYGON_LOOT});
                }
            }
            if (world.func_180494_b(pos) == DMBiomes.BIOME_TRENZALOREFOREST) {
                this.generateTrenzaloreTrees(world, random, chunkX * 16, chunkZ * 16, 3);
                this.generatePlant(Blocks.field_150329_H.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 64, 80, 4, (Block)Blocks.field_150349_c);
                this.generatePlant(Blocks.field_150329_H.func_176203_a(1), world, random, chunkX * 16, chunkZ * 16, 62, 80, 5, (Block)Blocks.field_150349_c);
                this.generatePlant(Blocks.field_150321_G.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 62, 80, 1, (Block)Blocks.field_150349_c);
                if (random.nextInt(50) == 10) {
                    this.generatePlant(Blocks.field_150440_ba.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 62, 80, 1, (Block)Blocks.field_150349_c);
                }
            }
        }
        if (dimID == 0) {
            this.generateOre(DMBlocks.cyOre.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 3, 96, 4 + random.nextInt(4), 8);
            this.generateOre(DMBlocks.silicate.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 3, 96, 4 + random.nextInt(3), 6);
            this.generateOre(DMBlocks.SonicCrystalOre.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 2, 96, 1 + random.nextInt(4), 7);
            this.generateOre(DMBlocks.zeitonore.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 3, 96, 2 + random.nextInt(3), 12);
            this.generateOre(DMBlocks.copper_ore.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 3, 96, 2 + random.nextInt(5), 8);
        }
        if (dimID == DMConfig.dimensionIDs.Mars_Dimension_ID) {
            this.generateOreDIM(DMBlocks.bmars_titanium.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 6, 90, 2 + random.nextInt(5), 20, DMBlocks.mars_red_rock);
            this.generateOreDIM(DMBlocks.brusted_iron_ore.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 7, 65, 4 + random.nextInt(3), 30, DMBlocks.mars_red_rock);
            this.generateOreDIM(DMBlocks.bmars_quartz.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 7, 70, 5 + random.nextInt(5), 30, DMBlocks.mars_red_rock);
            this.generateOreDIM(DMBlocks.bmars_emerald.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 15, 70, 2 + random.nextInt(2), 18, DMBlocks.mars_red_rock);
            this.generateOreDIM(DMBlocks.mars_lonsdaleite.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 6, 20, 2 + random.nextInt(2), 20, DMBlocks.mars_red_rock);
        }
        if (dimID == DMConfig.dimensionIDs.Vortis_Dimension_ID) {
            this.generateOreDIM(DMBlocks.vortis_quartz.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 20, 70, 3 + random.nextInt(4), 25, DMBlocks.vortis_rock);
            this.generateOreDIM(DMBlocks.vortis_blue.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 6, 80, 3 + random.nextInt(4), 25, DMBlocks.vortis_rock);
            this.generateOreDIM(DMBlocks.vortis_gold.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 6, 40, 1 + random.nextInt(4), 20, DMBlocks.vortis_rock);
            this.generateOreDIM(DMBlocks.vortis_crystaline.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 6, 90, 1 + random.nextInt(3), 25, DMBlocks.vortis_rock);
            this.generateOreDIM(DMBlocks.vortis_crystal.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 20, 50, 15 + random.nextInt(20), 1, DMBlocks.vortis_rock);
            this.generateOreDIM(DMBlocks.vortis_diamond.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 6, 25, 2 + random.nextInt(2), 2, DMBlocks.vortis_rock);
            pos = new BlockPos(chunkX * 16, 62, chunkZ * 16);
            if (world.func_180494_b(pos) == DMBiomes.BIOME_VORTISDESERT) {
                this.generatePlant(Blocks.field_150361_u.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 40, 80, 1, DMBlocks.vortis_sand);
                if (random.nextInt(10) == 4) {
                    this.generatePlant(DMBlocks.cichorium.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 50, 80, 1, DMBlocks.vortis_sand);
                }
            }
            if (world.func_180494_b(pos) == DMBiomes.BIOME_VORTIS) {
                this.generateCrystaline(world, random, chunkX * 16, chunkZ * 16, 8);
                if (random.nextInt(200) == 4) {
                    this.generateStructure(world, random, chunkX * 16, chunkZ * 16, DMSchematics.PYRAMID, 6, 5, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.WOOLAIR, DMSchematics.ZARBI_LOOT}, DMBlocks.vortis_rock, false, false);
                }
            }
        }
        if (dimID == DMConfig.dimensionIDs.Varos_Dimension_ID) {
            this.generateOreDIM(DMBlocks.ZeitonBlock.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 16, 64, 4 + random.nextInt(4), 1, DMBlocks.varosSand);
            this.generateOreDIM(DMBlocks.varos_plastic.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 10, 100, 5 + random.nextInt(4), 40, Blocks.field_150322_A);
            this.generateOreDIM(Blocks.field_150435_aG.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 10, 60, 9 + random.nextInt(7), 40, Blocks.field_150322_A);
            this.generateOreDIM(Blocks.field_192444_dS.func_176203_a(1), world, random, chunkX * 16, chunkZ * 16, 5, 40, 5 + random.nextInt(3), 10, Blocks.field_150322_A);
            this.generateOreDIM(Blocks.field_192444_dS.func_176203_a(4), world, random, chunkX * 16, chunkZ * 16, 40, 55, 5 + random.nextInt(3), 10, Blocks.field_150322_A);
            this.generateOreDIM(DMBlocks.varos_lapiz.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 10, 120, 2 + random.nextInt(4), 25, Blocks.field_150322_A);
            pos = new BlockPos(chunkX * 16, 62, chunkZ * 16);
            if (world.func_180494_b(pos) == DMBiomes.BIOME_VAROSSAVANNA && random.nextInt(10) == 4) {
                this.generatePlant(DMBlocks.varos_leaves.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 60, 85, 1, (Block)Blocks.field_150349_c);
            }
        }
        if (dimID == DMConfig.dimensionIDs.Minecraft_Classic_Dimension_ID) {
            this.generateClassicTrees(world, random, chunkX * 16, chunkZ * 16);
        }
        if (world.field_73011_w.getDimension() == DMConfig.dimensionIDs.Mondas_Dimension_ID) {
            this.generateOre(DMBlocks.cyOre.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 4, 60, 2 + random.nextInt(3), 6);
            this.generateOre(Blocks.field_150365_q.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 15, 90, 3 + random.nextInt(3), 12);
            this.generateOre(Blocks.field_150366_p.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 2, 70, 3 + random.nextInt(3), 7);
            this.generateOre(Blocks.field_150450_ax.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 20, 90, 3 + random.nextInt(3), 7);
            this.generateOre(DMBlocks.copper_ore.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 2, 60, 2 + random.nextInt(5), 5);
            this.generateOre(DMBlocks.zeitonore.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 3, 50, 2 + random.nextInt(3), 3);
            this.generateOre(DMBlocks.silicate.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 2, 70, 4 + random.nextInt(3), 7);
            pos = new BlockPos(chunkX * 16, 62, chunkZ * 16);
            if (world.func_180494_b(pos) == DMBiomes.BIOME_MONDASFOREST) {
                this.generatePlant(Blocks.field_150347_e.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 62, 90, 1, Blocks.field_150433_aE);
                this.generateMondasTrees(world, random, chunkX * 16, chunkZ * 16, 10);
                this.generateOre(DMBlocks.SonicCrystalOre.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 5, 60, 1 + random.nextInt(4), 7);
            }
            if (world.func_180494_b(pos) == DMBiomes.BIOME_MONDASMOUNTAINS) {
                this.generateOre(Blocks.field_150412_bA.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 65, 115, 2 + random.nextInt(3), 6);
                this.generateOre(Blocks.field_150348_b.func_176203_a(3), world, random, chunkX * 16, chunkZ * 16, 70, 110, 5 + random.nextInt(3), 10);
                if (!(chunkX % 16 != 0 && (chunkX + 2) % 16 != 0 && (chunkX + 4) % 16 != 0 && (chunkX + 6) % 16 != 0 || chunkZ % 16 != 0 && (chunkZ + 2) % 16 != 0 && (chunkZ + 4) % 16 != 0 && (chunkZ + 6) % 16 != 0)) {
                    BlockPos pos2 = new BlockPos(chunkX * 16, 35, chunkZ * 16);
                    SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2, DMSchematics.CITY[random.nextInt(DMSchematics.CITY.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.MONDAS_CITY, DMSchematics.CYBERAID_SPAWN, DMSchematics.WARRIOR_SPAWN, DMSchematics.PATIENT_SPAWN});
                }
            }
            if (world.func_180494_b(pos) == DMBiomes.BIOME_MONDASBLUELANDS) {
                this.generatePlant(Blocks.field_150329_H.func_176203_a(1), world, random, chunkX * 16, chunkZ * 16, 62, 80, 5, (Block)Blocks.field_150349_c);
                this.generateOreDIM(Blocks.field_150348_b.func_176203_a(1), world, random, chunkX * 16, chunkZ * 16, 60, 80, 8 + random.nextInt(5), 10, (Block)Blocks.field_150349_c);
                if (random.nextInt(150) == 4) {
                    this.generatePlant(DMBlocks.awabloom.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 60, 85, 1, (Block)Blocks.field_150349_c);
                }
                if (chunkX % 2 + random.nextInt(2) == 0 && chunkZ % 4 == 0) {
                    this.generatePlant(Blocks.field_150329_H.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 62, 80, 1, (Block)Blocks.field_150349_c);
                }
            }
            if (world.func_180494_b(pos) == DMBiomes.BIOME_MONDASSNOW) {
                this.generateOreDIM(Blocks.field_150348_b.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 60, 80, 3 + random.nextInt(5), 10, Blocks.field_150433_aE);
                int housegen = random.nextInt(150);
                if (housegen == 0) {
                    this.generateMondasHouse(world, random, chunkX * 16, chunkZ * 16, DMSchematics.MONDASHOUSEA);
                }
                if (housegen == 1) {
                    this.generateMondasHouse(world, random, chunkX * 16, chunkZ * 16, DMSchematics.MONDASHOUSEB);
                }
                if (housegen == 2) {
                    this.generateMondasHouse(world, random, chunkX * 16, chunkZ * 16, DMSchematics.MONDASHOUSEC);
                }
                if (housegen == 3) {
                    this.generateMondasHouse(world, random, chunkX * 16, chunkZ * 16, DMSchematics.MONDASHOUSED);
                }
                if (housegen == 4) {
                    this.generateMondasHouse(world, random, chunkX * 16, chunkZ * 16, DMSchematics.MONDASHOUSEE);
                }
                if (housegen == 5) {
                    this.generateMondasHouse(world, random, chunkX * 16, chunkZ * 16, DMSchematics.MONDASHOUSEF);
                }
                if (housegen == 6 && random.nextBoolean()) {
                    this.generateMondasHouse(world, random, chunkX * 16, chunkZ * 16, DMSchematics.MONDASFLAT);
                }
                if (housegen == 10) {
                    this.generateMondasHouse(world, random, chunkX * 16, chunkZ * 16, DMSchematics.MONDASWELL);
                }
                if (housegen == 11 && random.nextBoolean()) {
                    this.generateMondasHouse(world, random, chunkX * 16, chunkZ * 16, DMSchematics.MONDASTOWER);
                }
                if (housegen == 12 || housegen == 22) {
                    this.generateMondasHouse(world, random, chunkX * 16, chunkZ * 16, DMSchematics.MONDASLAMP);
                }
                if (housegen == 13) {
                    this.generateMondasHouse(world, random, chunkX * 16, chunkZ * 16, DMSchematics.MONDASWALL);
                }
            }
        }
        if (dimID == DMConfig.dimensionIDs.Skaro_Dimension_ID) {
            this.generateOreDIM(DMBlocks.skaro_dirt.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 20, 55, 10 + random.nextInt(10), 10, DMBlocks.skaroStone);
            this.generateOreDIM(DMBlocks.dalekaniumOre.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 10, 60, 2 + random.nextInt(4), 23, DMBlocks.skaroStone);
            this.generateOreDIM(DMBlocks.metalert_ore.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 5, 18, 1 + random.nextInt(3), 3, DMBlocks.skaroStone);
            this.generateOreDIM(DMBlocks.skaro_rock.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 15, 50, 10 + random.nextInt(10), 10, DMBlocks.skaroStone);
            this.generateOreDIM(Blocks.field_192444_dS.func_176203_a(9), world, random, chunkX * 16, chunkZ * 16, 6, 35, 10 + random.nextInt(10), 5, DMBlocks.skaroStone);
            this.generateOreDIM(DMBlocks.skaro_coal.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 10, 60, 4 + random.nextInt(5), 14, DMBlocks.skaroStone);
            this.generateOreDIM(DMBlocks.skaro_copper.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 10, 50, 4 + random.nextInt(3), 11, DMBlocks.skaroStone);
            this.generateOreDIM(DMBlocks.skaro_emerald.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 10, 45, 1, 8, DMBlocks.skaroStone);
            this.generateOreDIM(DMBlocks.skaro_diamond.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 5, 20, 1 + random.nextInt(3), 2, DMBlocks.skaroStone);
            if (random.nextInt(550) == 2) {
                this.generateSkaroLakes(world, random, chunkX * 16, chunkZ * 16);
                System.out.println("Generating Skaro lake. Chance of cascading chunk gen lag");
            }
            if (world.func_180494_b(posbiome = new BlockPos(chunkX * 16, 62, chunkZ * 16)) == DMBiomes.BIOME_SKAROFOREST) {
                this.generateSkaroTrees(world, random, chunkX * 16, chunkZ * 16, 2);
                this.generatePlant(DMBlocks.petrified_leaves.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 62, 80, 1, DMBlocks.skaro_grass);
                this.generatePlant(DMBlocks.skaro_rock.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 62, 80, 2, DMBlocks.skaro_grass);
                if (random.nextInt(15) == 2) {
                    this.generatePlant(DMBlocks.petrified_flower.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 62, 80, 2, DMBlocks.skaro_grass);
                }
            }
            if ((chunkX - 1) % 50 == 0 && (chunkZ + 0) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(-48, 0, -32)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianVerticalZ().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p(), true);
            }
            if ((chunkX + 0) % 50 == 0 && (chunkZ + 0) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(-32, 0, -32)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianHorizontal().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p());
                c = new EntityKaled(world);
                c.setSubEntityID(0 + random.nextInt(2));
                c.setupdataManagerAndAI();
                c.func_70012_b((double)pos2.func_177958_n() + 2.5, (double)(pos2.func_177956_o() + 7), (double)pos2.func_177952_p() + 2.5, 0.0f, 0.0f);
                world.func_72838_d((Entity)c);
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2.func_177982_a(0, 5, 0), DMSchematics.KALED3[random.nextInt(DMSchematics.KALED3.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2, DMSchematics.KALED3[random.nextInt(DMSchematics.KALED3.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
            }
            if ((chunkX + 1) % 50 == 0 && (chunkZ + 0) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(-16, 0, -32)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianHorizontal().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p());
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2.func_177982_a(0, 5, 0), DMSchematics.KALED3[random.nextInt(DMSchematics.KALED3.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2, DMSchematics.KALED3[random.nextInt(DMSchematics.KALED3.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
            }
            if ((chunkX + 2) % 50 == 0 && (chunkZ + 0) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(0, 0, -32)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianHorizontal().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p());
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2.func_177982_a(0, 5, 0), DMSchematics.KALED3[random.nextInt(DMSchematics.KALED3.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2, DMSchematics.KALED3[random.nextInt(DMSchematics.KALED3.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                c = new EntityKaled(world);
                c.setSubEntityID(0 + random.nextInt(2));
                c.setupdataManagerAndAI();
                c.func_70012_b((double)pos2.func_177958_n() + 2.5, (double)(pos2.func_177956_o() + 3), (double)pos2.func_177952_p() + 2.5, 0.0f, 0.0f);
                world.func_72838_d((Entity)c);
            }
            if ((chunkX + 3) % 50 == 0 && (chunkZ + 0) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(16, 0, -32)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianHorizontal().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p());
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2.func_177982_a(0, 5, 0), DMSchematics.KALED3[random.nextInt(DMSchematics.KALED3.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2, DMSchematics.KALED3[random.nextInt(DMSchematics.KALED3.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                c = new EntityKaled(world);
                c.setSubEntityID(0 + random.nextInt(2));
                c.setupdataManagerAndAI();
                c.func_70012_b((double)pos2.func_177958_n() + 2.5, (double)(pos2.func_177956_o() + 7), (double)pos2.func_177952_p() + 2.5, 0.0f, 0.0f);
                world.func_72838_d((Entity)c);
            }
            if ((chunkX + 4) % 50 == 0 && (chunkZ + 0) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(32, 0, -32)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianVerticalZ().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p(), false);
            }
            if ((chunkX - 1) % 50 == 0 && (chunkZ + 1) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(-48, 0, -16)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianVerticalZ().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p(), true);
            }
            if (chunkX % 50 == 0 && (chunkZ + 1) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(-32, 0, -16)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianHorizontal().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p());
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2, DMSchematics.KALED2[random.nextInt(DMSchematics.KALED2.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2.func_177982_a(0, 5, 0), DMSchematics.KALED2[random.nextInt(DMSchematics.KALED2.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                c = new EntityKaled(world);
                c.setSubEntityID(0 + random.nextInt(2));
                c.setupdataManagerAndAI();
                c.func_70012_b((double)pos2.func_177958_n() + 2.5, (double)(pos2.func_177956_o() + 7), (double)pos2.func_177952_p() + 2.5, 0.0f, 0.0f);
                world.func_72838_d((Entity)c);
            }
            if ((chunkX + 3) % 50 == 0 && (chunkZ + 1) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(16, 0, -16)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianHorizontal().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p());
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2, DMSchematics.KALED2[random.nextInt(DMSchematics.KALED2.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2.func_177982_a(0, 5, 0), DMSchematics.KALED2[random.nextInt(DMSchematics.KALED2.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                c = new EntityKaled(world);
                c.setSubEntityID(0 + random.nextInt(2));
                c.setupdataManagerAndAI();
                c.func_70012_b((double)pos2.func_177958_n() + 2.5, (double)(pos2.func_177956_o() + 7), (double)pos2.func_177952_p() + 2.5, 0.0f, 0.0f);
                world.func_72838_d((Entity)c);
            }
            if ((chunkX + 4) % 50 == 0 && (chunkZ + 1) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(32, 0, -16)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianVerticalZ().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p(), false);
            }
            if ((chunkX - 1) % 50 == 0 && (chunkZ + 2) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(-48, 0, 0)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianVerticalZ().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p(), true);
            }
            if (chunkX % 50 == 0 && (chunkZ + 2) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(-32, 0, 0)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianHorizontal().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p());
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2, DMSchematics.KALED2[random.nextInt(DMSchematics.KALED2.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2.func_177982_a(0, 5, 0), DMSchematics.KALED2[random.nextInt(DMSchematics.KALED2.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                c = new EntityKaled(world);
                c.setSubEntityID(0 + random.nextInt(2));
                c.setupdataManagerAndAI();
                c.func_70012_b((double)pos2.func_177958_n() + 2.5, (double)(pos2.func_177956_o() + 3), (double)pos2.func_177952_p() + 2.5, 0.0f, 0.0f);
                world.func_72838_d((Entity)c);
            }
            if ((chunkX + 3) % 50 == 0 && (chunkZ + 2) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(16, 0, 0)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianHorizontal().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p());
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2, DMSchematics.KALED2[random.nextInt(DMSchematics.KALED2.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2.func_177982_a(0, 5, 0), DMSchematics.KALED2[random.nextInt(DMSchematics.KALED2.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                c = new EntityKaled(world);
                c.setSubEntityID(0 + random.nextInt(2));
                c.setupdataManagerAndAI();
                c.func_70012_b((double)pos2.func_177958_n() + 2.5, (double)(pos2.func_177956_o() + 7), (double)pos2.func_177952_p() + 2.5, 0.0f, 0.0f);
                world.func_72838_d((Entity)c);
            }
            if ((chunkX + 4) % 50 == 0 && (chunkZ + 2) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(32, 0, 0)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianVerticalZ().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p(), false);
            }
            if ((chunkX - 1) % 50 == 0 && (chunkZ + 3) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(-48, 0, 16)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianVerticalZ().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p(), true);
            }
            if ((chunkX + 0) % 50 == 0 && (chunkZ + 3) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(-32, 0, 16)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianHorizontal().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p());
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2.func_177982_a(0, 5, 0), DMSchematics.KALED1[random.nextInt(DMSchematics.KALED1.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2, DMSchematics.KALED1[random.nextInt(DMSchematics.KALED1.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                c = new EntityKaled(world);
                c.setSubEntityID(0 + random.nextInt(2));
                c.setupdataManagerAndAI();
                c.func_70012_b((double)pos2.func_177958_n() + 2.5, (double)(pos2.func_177956_o() + 7), (double)pos2.func_177952_p() + 2.5, 0.0f, 0.0f);
                world.func_72838_d((Entity)c);
            }
            if ((chunkX + 1) % 50 == 0 && (chunkZ + 3) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(-16, 0, 16)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianHorizontal().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p());
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2.func_177982_a(0, 5, 0), DMSchematics.KALED1[random.nextInt(DMSchematics.KALED1.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2, DMSchematics.KALED1[random.nextInt(DMSchematics.KALED1.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                c = new EntityKaled(world);
                c.setSubEntityID(0 + random.nextInt(2));
                c.setupdataManagerAndAI();
                c.func_70012_b((double)pos2.func_177958_n() + 2.5, (double)(pos2.func_177956_o() + 3), (double)pos2.func_177952_p() + 2.5, 0.0f, 0.0f);
                world.func_72838_d((Entity)c);
            }
            if ((chunkX + 2) % 50 == 0 && (chunkZ + 3) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(0, 0, 16)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianHorizontal().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p());
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2.func_177982_a(0, 5, 0), DMSchematics.KALED1[random.nextInt(DMSchematics.KALED1.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2, DMSchematics.KALED1[random.nextInt(DMSchematics.KALED1.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                c = new EntityKaled(world);
                c.setSubEntityID(0 + random.nextInt(2));
                c.setupdataManagerAndAI();
                c.func_70012_b((double)pos2.func_177958_n() + 2.5, (double)(pos2.func_177956_o() + 7), (double)pos2.func_177952_p() + 2.5, 0.0f, 0.0f);
                world.func_72838_d((Entity)c);
            }
            if ((chunkX + 3) % 50 == 0 && (chunkZ + 3) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(16, 0, 16)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianHorizontal().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p());
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2.func_177982_a(0, 5, 0), DMSchematics.KALED1[random.nextInt(DMSchematics.KALED1.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2, DMSchematics.KALED1[random.nextInt(DMSchematics.KALED1.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
            }
            if ((chunkX + 4) % 50 == 0 && (chunkZ + 3) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(32, 0, 16)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianVerticalZ().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p(), false);
            }
            if ((chunkX + 0) % 50 == 0 && (chunkZ + 4) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(-32, 0, 32)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianVerticalX().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p(), false);
            }
            if ((chunkX + 1) % 50 == 0 && (chunkZ + 4) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(-16, 0, 32)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianVerticalX().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p(), false);
            }
            if ((chunkX + 2) % 50 == 0 && (chunkZ + 4) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(0, 0, 32)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianVerticalX().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p(), false);
            }
            if ((chunkX + 3) % 50 == 0 && (chunkZ + 4) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(16, 0, 32)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianVerticalX().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p(), false);
            }
            if ((chunkX + 0) % 50 == 0 && (chunkZ - 1) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(-32, 0, -48)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianVerticalX().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p(), true);
            }
            if ((chunkX + 1) % 50 == 0 && (chunkZ - 1) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(-16, 0, -48)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianVerticalX().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p(), true);
            }
            if ((chunkX + 2) % 50 == 0 && (chunkZ - 1) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(0, 0, -48)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianVerticalX().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p(), true);
            }
            if ((chunkX + 3) % 50 == 0 && (chunkZ - 1) % 50 == 0 && world.func_180494_b(posbiome.func_177982_a(16, 0, -48)) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianVerticalX().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p(), true);
            }
            if ((chunkX + 2) % 50 == 0 && (chunkZ + 2) % 50 == 0 && world.func_180494_b(posbiome) == DMBiomes.BIOME_SKARODESERT) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                new WorldGenObsidianHorizontal().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p());
                new WorldGenObsidianHorizontal().generate(world, pos2.func_177958_n() + 16, pos2.func_177956_o() - 1, pos2.func_177952_p());
                new WorldGenObsidianHorizontal().generate(world, pos2.func_177958_n() + 16, pos2.func_177956_o() - 1, pos2.func_177952_p() + 16);
                new WorldGenObsidianHorizontal().generate(world, pos2.func_177958_n(), pos2.func_177956_o() - 1, pos2.func_177952_p() + 16);
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2, DMSchematics.KALEDMAIN, SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.KALED_LOOT});
                c = new EntityKaled(world);
                c.setSubEntityID(0 + random.nextInt(2));
                c.setupdataManagerAndAI();
                c.func_70012_b((double)pos2.func_177958_n() + 2.5, (double)(pos2.func_177956_o() + 3), (double)pos2.func_177952_p() + 2.5, 0.0f, 0.0f);
                world.func_72838_d((Entity)c);
                EntityDavros dav = new EntityDavros(world);
                dav.setSubEntityID(0 + random.nextInt(2));
                dav.setupdataManagerAndAI();
                dav.func_70012_b((double)pos2.func_177958_n() + 13.5, pos2.func_177956_o() + 3, (double)pos2.func_177952_p() + 13.5, 0.0f, 0.0f);
                world.func_72838_d((Entity)dav);
                System.out.println("This cascading chunk gen lag is intentional, and should only happen once in a burst of  3/4 per Kaled Dome. This is a rare occurance.");
            }
            if (world.func_180494_b(posbiome) == DMBiomes.BIOME_SKARODESERT) {
                this.generateLandmines(DMBlocks.landmine.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 69, 80, 3, DMBlocks.SkaroSand);
            }
            if (world.func_180494_b(posbiome) == DMBiomes.BIOME_SKAROPLAINS) {
                this.generateOreDIM(DMBlocks.skaro_grass.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 60, 85, 10 + random.nextInt(14), 5, DMBlocks.skaro_rock);
                this.generateOreDIM(DMBlocks.skaroStone.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 60, 85, 20 + random.nextInt(14), 8, DMBlocks.skaro_rock);
                if (chunkX % 35 == 0 && chunkZ % 37 == 0) {
                    BlockPos pos2 = new BlockPos(chunkX * 16, 65, chunkZ * 16);
                    System.out.println("Dalek City being built. Expect lag");
                    SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.CITADEL, world, pos2, DMSchematics.DALEKCITY, SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.ASYLUM_LOOT, DMSchematics.HOVERBOUT});
                }
            }
            if (!(chunkX % 18 != 0 && (chunkX + 1) % 18 != 0 && (chunkX + 2) % 18 != 0 || chunkZ % 18 != 0 && (chunkZ + 1) % 18 != 0 && (chunkZ + 2) % 18 != 0)) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 35, chunkZ * 16);
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2, DMSchematics.ASYLUM[random.nextInt(DMSchematics.ASYLUM.length)], SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.ASYLUM_LOOT});
                c = new EntityDalek(world);
                c.setDalekID(41 + random.nextInt(7));
                c.setupDalek();
                c.func_70012_b((double)pos2.func_177958_n() + 8.5, (double)(pos2.func_177956_o() + 3), (double)pos2.func_177952_p() + 3.5, 0.0f, 0.0f);
                world.func_72838_d((Entity)c);
            }
            if (DMSchematics.DALEK_EMPEROR_SHIP != null && chunkX == 130 && chunkZ == 131) {
                BlockPos pos2 = new BlockPos(chunkX * 16, 130 + world.field_73012_v.nextInt(80), chunkZ * 16);
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos2, DMSchematics.DALEK_EMPEROR_SHIP, SchematicUtils.BlockMap.DM_1_12_2, new IBlockState[]{Blocks.field_150350_a.func_176223_P()}, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.DALEK_EMPEROR_SHIP_SPAWN, DMSchematics.DALEK_EMPEROR_SHIP_SPAWN_BOSS});
            }
            if (world.func_180494_b(posbiome) != DMBiomes.BIOME_SKAROPLAINS && random.nextInt(150) == 10 && chunkX % 8 == 0 && chunkZ % 8 == 0) {
                BlockPos posair = new BlockPos(chunkX * 16, 100 + world.field_73012_v.nextInt(30), chunkZ * 16);
                if (random.nextBoolean()) {
                    SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, posair, DMSchematics.DALEKSHIP[0], SchematicUtils.BlockMap.DM_1_12_2, new IBlockState[]{Blocks.field_150350_a.func_176223_P()}, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.ASYLUM_LOOT});
                } else {
                    SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, posair, DMSchematics.DALEKSHIP[1], SchematicUtils.BlockMap.DM_1_12_2, new IBlockState[]{Blocks.field_150350_a.func_176223_P()}, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.ASYLUM_LOOT});
                }
            }
        }
        if (dimID == DMConfig.dimensionIDs.Mars_Dimension_ID) {
            if (DMSchematics.MARS_ICE_WARRIOR_SHIP != null && random.nextInt(50) == 4 && chunkX % 4 == 0 && chunkZ % 4 == 0) {
                pos = new BlockPos(chunkX * 16, 128 + world.field_73012_v.nextInt(80), chunkZ * 16);
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos, DMSchematics.MARS_ICE_WARRIOR_SHIP, SchematicUtils.BlockMap.DM_1_12_2, new IBlockState[]{Blocks.field_150350_a.func_176223_P()}, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.MARS_ICE_WARRIOR_SPAWN});
            }
            if (random.nextInt(14) == 1 && chunkX % 4 == 0 && chunkZ % 4 == 0) {
                pos = new BlockPos(chunkX * 16, 20 + world.field_73012_v.nextInt(30), chunkZ * 16);
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos, DMSchematics.MARS[random.nextInt(DMSchematics.MARS.length)], SchematicUtils.BlockMap.DM_1_12_2, new IBlockState[]{Blocks.field_150350_a.func_176223_P()}, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.WOOLAIR, DMSchematics.MARS_LOOT});
                this.generateOreDIM(DMBlocks.mars_red_sand_2.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 60, 84, 8 + random.nextInt(7), 12, DMBlocks.mars_red_sand);
            }
        }
        if (dimID == DMConfig.dimensionIDs.Moon_Dimension_ID) {
            if (chunkX == 0 && chunkZ == 0) {
                pos = new BlockPos(-8, 64, -8);
                pos = new BlockPos(pos.func_177958_n(), world.func_175672_r(pos).func_177956_o(), pos.func_177952_p());
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos, DMSchematics.APOLLO, SchematicUtils.BlockMap.DM_1_12_2);
            }
            if (random.nextInt(150) == 4 && (chunkX % 18 == 0 && chunkZ % 21 == 0 || chunkZ != 0)) {
                pos = new BlockPos(chunkX * 16, 32, chunkZ * 16);
                if (world.func_180495_p((pos = new BlockPos(pos.func_177958_n(), world.func_175672_r(pos).func_177956_o() + 1, pos.func_177952_p())).func_177982_a(DMSchematics.JUDOONSHIP.schem_dim_x, -1, DMSchematics.JUDOONSHIP.schem_dim_z)).func_177230_c() != Blocks.field_150350_a) {
                    this.generateSpaceship1(world, random, chunkX * 16, chunkZ * 16, DMSchematics.JUDOONSHIP, 2, 15, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.JUDOON_SPAWN});
                }
            }
            if (DMSchematics.MOON_CYBER_SHIP != null && random.nextInt(400) == 4 && (chunkX % 15 == 0 && chunkZ % 19 == 0 || chunkZ != 0)) {
                pos = new BlockPos(chunkX * 16, 32, chunkZ * 16);
                if (world.func_180495_p((pos = new BlockPos(pos.func_177958_n(), world.func_175672_r(pos).func_177956_o() + 1, pos.func_177952_p())).func_177982_a(DMSchematics.MOON_CYBER_SHIP.schem_dim_x, -1, DMSchematics.MOON_CYBER_SHIP.schem_dim_z)).func_177230_c() != Blocks.field_150350_a) {
                    int i;
                    SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos.func_177982_a(0, -2, 0), DMSchematics.MOON_CYBER_SHIP, SchematicUtils.BlockMap.DM_1_12_2, new IBlockState[]{Blocks.field_150350_a.func_176223_P()}, Blocks.field_150360_v.func_176223_P());
                    for (i = 0; i < 10; ++i) {
                        c = new EntityCyberman(world);
                        c.setSubEntityID(3);
                        c.setupdataManagerAndAI();
                        c.func_70012_b((double)pos.func_177958_n() + 0.5 + (double)random.nextInt(DMSchematics.MOON_CYBER_SHIP.schem_dim_x), (double)(pos.func_177956_o() + 3 + random.nextInt(DMSchematics.MOON_CYBER_SHIP.schem_dim_y)), (double)pos.func_177952_p() + 0.5 + (double)random.nextInt(DMSchematics.MOON_CYBER_SHIP.schem_dim_z), 0.0f, 0.0f);
                        world.func_72838_d((Entity)c);
                    }
                    for (i = 0; i < 10; ++i) {
                        c = new EntityCyberMat(world);
                        c.func_70012_b((double)pos.func_177958_n() + 0.5 + (double)random.nextInt(DMSchematics.MOON_CYBER_SHIP.schem_dim_x), (double)(pos.func_177956_o() + 3 + random.nextInt(DMSchematics.MOON_CYBER_SHIP.schem_dim_y)), (double)pos.func_177952_p() + 0.5 + (double)random.nextInt(DMSchematics.MOON_CYBER_SHIP.schem_dim_z), 0.0f, 0.0f);
                        world.func_72838_d((Entity)c);
                    }
                }
            }
        }
        if (dimID == DMConfig.dimensionIDs.Gallifrey_Dimension_ID) {
            if (DMSchematics.GALLIFREY_CITADEL != null && chunkX == -260 && chunkZ == -278) {
                pos = new BlockPos(-4170, 1, -4454);
                System.out.println("The Citadel is generating. Due to the size, this can cause massive lag and can take several minutes");
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.CITADEL, world, pos, DMSchematics.GALLIFREY_CITADEL, SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.STEEL});
            }
            if (chunkX == 410 && chunkZ == 414) {
                pos = new BlockPos(6560, 62, 6624);
                SchematicUtils.generateSchematic(SchematicUtils.GenerationQueue.DEFAULT, world, pos, DMSchematics.GALLIFREY_SHACK, SchematicUtils.BlockMap.DM_1_12_2, null, null, new SchematicUtils.IReplaceBlockSpawn[0]);
            }
            this.generatePlant(DMBlocks.gallifrey_tallgrass.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 62, 70, 5, DMBlocks.gallifreyGrass);
            this.generateOreDIM(Blocks.field_150406_ce.func_176203_a(1), world, random, chunkX * 16, chunkZ * 16, 6, 55, 9 + random.nextInt(7), 30, DMBlocks.GallifreyStone);
            this.generateOreDIM(Blocks.field_150406_ce.func_176203_a(14), world, random, chunkX * 16, chunkZ * 16, 35, 40, 10 + random.nextInt(7), 70, DMBlocks.GallifreyStone);
            this.generateOreDIM(Blocks.field_150435_aG.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 6, 55, 4 + random.nextInt(7), 50, DMBlocks.GallifreyStone);
            this.generateOreDIM(DMBlocks.zeiton_ore_gallifrey.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 6, 70, 1 + random.nextInt(7), 15, DMBlocks.GallifreyStone);
            this.generateOreDIM(DMBlocks.copper_ore_gallifrey.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 6, 96, 1 + random.nextInt(7), 15, DMBlocks.GallifreyStone);
            this.generateOreDIM(DMBlocks.green_clay_ore.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 6, 96, 4 + random.nextInt(6), 25, DMBlocks.GallifreyStone);
            this.generateOreDIM(DMBlocks.yellow_clay_ore.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 40, 66, 1 + random.nextInt(7), 17, DMBlocks.GallifreyStone);
            this.generateOreDIM(DMBlocks.sillicate_gallifrey.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 6, 70, 1 + random.nextInt(7), 15, DMBlocks.GallifreyStone);
            this.generateOreDIM(DMBlocks.diamond_gallifrey.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 6, 24, 2 + random.nextInt(3), 1, DMBlocks.GallifreyStone);
            this.generateOreDIM(DMBlocks.GallifreySand.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 61, 66, 4 + random.nextInt(5), 1, DMBlocks.gallifreyGrass);
            this.generateOreDIM(DMBlocks.whitepointstar_ore.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 6, 24, 2 + random.nextInt(2), 3, DMBlocks.GallifreyStone);
            this.generateOreDIM(DMBlocks.azbantium.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 10, 35, 4 + random.nextInt(2), 3, DMBlocks.GallifreyStone);
            this.generateGallifreyTrees(world, random, chunkX * 16, chunkZ * 16);
            if (chunkX % 2 + random.nextInt(2) == 0 && chunkZ % 3 == 0) {
                this.generatePlant(DMBlocks.thanaplant.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 62, 70, 1, DMBlocks.gallifreyGrass);
            }
            this.generateWeanskrike(world, random, chunkX * 16, chunkZ * 16, 1);
            this.generatePlant(DMBlocks.gallifrey_tallgrass.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 60, 80, 2, DMBlocks.GallifreySand);
            posbiome = new BlockPos(chunkX * 16, 62, chunkZ * 16);
            if (chunkX % 50 < 3 && chunkX % 50 > -3 && chunkZ % 50 < 3 && chunkZ % 50 > -3) {
                this.generateStructure(world, random, chunkX * 16, chunkZ * 16, DMSchematics.CORAL[random.nextInt(DMSchematics.CORAL.length)], -1, 1, new SchematicUtils.IReplaceBlockSpawn[0], DMBlocks.GallifreySand, false, true);
                this.generateStructure(world, random, chunkX * 16, chunkZ * 16, DMSchematics.CORAL[random.nextInt(DMSchematics.CORAL.length)], -1, 1, new SchematicUtils.IReplaceBlockSpawn[0], DMBlocks.GallifreySand, false, true);
                this.generateStructure(world, random, chunkX * 16, chunkZ * 16, DMSchematics.CORAL[random.nextInt(DMSchematics.CORAL.length)], -1, 1, new SchematicUtils.IReplaceBlockSpawn[0], DMBlocks.gallifreyGrass, false, true);
                this.generateStructure(world, random, chunkX * 16, chunkZ * 16, DMSchematics.CORAL[random.nextInt(DMSchematics.CORAL.length)], -1, 1, new SchematicUtils.IReplaceBlockSpawn[0], DMBlocks.gallifreyGrass, false, true);
            }
            if (world.func_180494_b(posbiome) == DMBiomes.BIOME_GALLIFREYDESERT) {
                int housegen = random.nextInt(700);
                if (housegen == 1) {
                    this.generateStructure(world, random, chunkX * 16, chunkZ * 16, DMSchematics.GALLIFREYWELL, 3, 4, new SchematicUtils.IReplaceBlockSpawn[0], DMBlocks.GallifreySand, true, false);
                }
                if (housegen == 2) {
                    this.generateStructure(world, random, chunkX * 16, chunkZ * 16, DMSchematics.GALLIFREY[0], -1, 4, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.GALLIFREY_LOOT}, DMBlocks.GallifreySand, true, false);
                }
                if (housegen == 3) {
                    this.generateStructure(world, random, chunkX * 16, chunkZ * 16, DMSchematics.GALLIFREY[1], 1, 4, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.GALLIFREY_LOOT}, DMBlocks.GallifreySand, true, false);
                }
                if (housegen == 4) {
                    this.generateStructure(world, random, chunkX * 16, chunkZ * 16, DMSchematics.GALLIFREY[2], 1, 4, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.GALLIFREY_LOOT}, DMBlocks.GallifreySand, true, false);
                }
                if (housegen == 5) {
                    this.generateStructure(world, random, chunkX * 16, chunkZ * 16, DMSchematics.GALLIFREY[3], 0, 4, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.GALLIFREY_LOOT}, DMBlocks.GallifreySand, true, false);
                }
                if (housegen == 6) {
                    this.generateStructure(world, random, chunkX * 16, chunkZ * 16, DMSchematics.GALLIFREY[4], -1, 4, new SchematicUtils.IReplaceBlockSpawn[]{DMSchematics.GALLIFREY_LOOT}, DMBlocks.GallifreySand, true, false);
                }
                if (housegen < 20 && housegen < 45) {
                    this.generateStructure(world, random, chunkX * 16, chunkZ * 16, DMSchematics.CORAL[random.nextInt(DMSchematics.CORAL.length)], -1, 1, new SchematicUtils.IReplaceBlockSpawn[0], DMBlocks.GallifreySand, false, true);
                }
                if (housegen >= 620) {
                    this.generateStructure(world, random, chunkX * 16, chunkZ * 16, DMSchematics.TREE[random.nextInt(DMSchematics.TREE.length)], -1, 4, new SchematicUtils.IReplaceBlockSpawn[0], DMBlocks.GallifreySand, false, false);
                }
            }
        }
    }

    private void generateGallifreyTrees(World world, Random rand, int chunkX, int chunkZ) {
        int randPosZ;
        int randPosY;
        int randPosX;
        if (rand.nextBoolean() && (world.func_180495_p(new BlockPos(randPosX = chunkX + rand.nextInt(10) + 4, randPosY = world.func_175672_r(new BlockPos(randPosX, 0, randPosZ = chunkZ + rand.nextInt(10) + 4)).func_177956_o() - 1, randPosZ)).func_177230_c() == DMBlocks.gallifreyGrass && world.func_180495_p(new BlockPos(randPosX + 1, randPosY, randPosZ + 1)).func_177230_c() == DMBlocks.gallifreyGrass || world.func_180495_p(new BlockPos(randPosX, randPosY, randPosZ)).func_177230_c() == DMBlocks.GallifreyDirt) && world.func_180495_p(new BlockPos(randPosX, randPosY + 1, randPosZ)).func_177230_c() == Blocks.field_150350_a) {
            this.trees.generate(randPosX, randPosY, randPosZ, world);
        }
    }

    public class WorldGeneratorCustom {
        public IBlockState block;
        public int chance = 0;

        public WorldGeneratorCustom(IBlockState state, int chance) {
            this.block = state;
            this.chance = chance;
        }
    }
}

