/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.commands;

import com.swdteam.common.data.PlayerData;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tileentity.tardis.perms.TardisPermission;
import com.swdteam.main.TheDalekMod;
import com.swdteam.utils.EnumDefaultResponse;
import com.swdteam.utils.PlayerUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.server.command.CommandTreeBase;

public class CommandTardisCompanions
extends CommandTreeBase {
    public String func_71517_b() {
        return "tardis-companions";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " [add/remove] [player]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (!(sender instanceof EntityPlayer)) return;
        EntityPlayer player = (EntityPlayer)sender;
        if (player.func_130014_f_().field_73011_w.getDimension() != DMDimensions.DIM_TARDIS_ID) {
            PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.CANNOT_EXECUTE_IN_DIMENSION);
            return;
        }
        TardisData data = DMTardis.getTardis(player.func_180425_c());
        if (data != null) {
            if (data.getCurrentOwner() == null) return;
            if (!data.getCurrentOwner().equals(player.func_110124_au())) {
                PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.NOT_YOUR_TARDIS);
                return;
            }
            if (args.length < 1) {
                if (data.getCompanions() == null || data.getCompanions() != null && data.getCompanions().size() < 1) {
                    PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.GREEN + "You have no companions.");
                    return;
                }
                PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.GREEN + "Your current companions are:");
                StringBuilder b = new StringBuilder();
                for (PlayerData pData : data.getCompanions()) {
                    b.append(pData.getUsername() + ", ");
                }
                PlayerUtils.Messaging.sendMessageToPlayer(player, b.toString());
                return;
            } else if (args.length == 2) {
                if (args[0].toLowerCase().equals("add") || args[0].toLowerCase().equals("remove")) {
                    EntityPlayerMP cmPlayer = TheDalekMod.FML.getMinecraftServerInstance().func_184103_al().func_152612_a(args[1]);
                    if (cmPlayer != null) {
                        if (args[0].toLowerCase().equals("add")) {
                            data.setTardisPermissions(TardisPermission.COMPANIONS);
                            data.addCompanion((EntityPlayer)cmPlayer);
                            TardisSaveHandler.saveTardis(data);
                            PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.GREEN + "Player " + args[1] + " has been added.");
                            return;
                        }
                        if (!args[0].toLowerCase().equals("remove")) return;
                        if (!data.removeCompanion(args[1])) return;
                        TardisSaveHandler.saveTardis(data);
                        PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.GREEN + "Player " + args[1] + " has been removed.");
                        return;
                    }
                    PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.RED + "Player " + args[1] + " does not exist.");
                    return;
                }
                PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.INVALID_COMMAND_PARAMS);
                return;
            } else {
                PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.INVALID_COMMAND_PARAMS);
            }
            return;
        } else {
            PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.TARDIS_DOES_NOT_EXIST);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            return CommandTardisCompanions.func_71530_a((String[])args, (String[])new String[]{"add", "remove"});
        }
        if (args.length == 2) {
            return CommandTardisCompanions.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

