/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.dimensions.world;

import com.swdteam.common.dimensions.world.WorldProviderDMBase;
import com.swdteam.common.init.DMBiomes;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.planets.sky.SkyRendererMars;
import com.swdteam.common.world.gen.chunk.ChunkGeneratorMars;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderMars
extends WorldProviderDMBase {
    public static SkyRendererMars SKY = new SkyRendererMars();
    Vec3d skyColor = new Vec3d(0.9411764740943909, 0.7843137383460999, 0.5882353186607361);
    private final float[] colorsSunriseSunset = new float[4];

    public WorldProviderMars() {
        super(true);
        this.field_76578_c = new BiomeProviderSingle(DMBiomes.BIOME_MARS);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float p_76562_1_, float p_76562_2_) {
        return new Vec3d(1.0, 0.6, 0.6);
    }

    public String getSaveFolder() {
        return "dm_mars";
    }

    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorMars(this.field_76579_a);
    }

    public DimensionType func_186058_p() {
        return DMDimensions.DIM_MARS;
    }

    public boolean func_76569_d() {
        return true;
    }

    public boolean func_76566_a(int x, int z) {
        return false;
    }

    public boolean func_76567_e() {
        return false;
    }

    public int func_76557_i() {
        return 60;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76568_b(int par1, int par2) {
        return true;
    }

    public int func_76559_b(long worldTime) {
        return 7;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76561_g() {
        return true;
    }

    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        return this.skyColor;
    }

    protected void func_76556_a() {
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            this.field_76573_f[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * 1.0f + 0.0f;
        }
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        int i = (int)(worldTime % 25000L);
        float f = ((float)i + partialTicks) / 25000.0f - 0.25f;
        if (f < 0.0f) {
            f += 1.0f;
        }
        if (f > 1.0f) {
            f -= 1.0f;
        }
        float f1 = 1.0f - (float)((Math.cos((double)f * Math.PI) + 1.0) / 2.0);
        f += (f1 - f) / 3.0f;
        return f;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public float[] func_76560_a(float celestialAngle, float partialTicks) {
        float f = 0.4f;
        float f1 = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) - 0.0f;
        float f2 = -0.0f;
        if (f1 >= -0.4f && f1 <= 0.4f) {
            float f3 = (f1 - -0.0f) / 0.4f * 0.5f + 0.5f;
            float f4 = 1.0f - (1.0f - MathHelper.func_76126_a((float)(f3 * (float)Math.PI))) * 0.99f;
            f4 *= f4;
            this.colorsSunriseSunset[0] = f3 * 0.3f + 0.1f;
            this.colorsSunriseSunset[1] = f3 * f3 * 0.7f + 0.2f;
            this.colorsSunriseSunset[2] = f3 * 0.3f + 0.65f;
            this.colorsSunriseSunset[3] = f4;
            return this.colorsSunriseSunset;
        }
        return null;
    }

    public float getSunBrightnessFactor(float par1) {
        return 0.0f;
    }

    public Biome getBiomeForCoords(BlockPos pos) {
        return DMBiomes.BIOME_MARS;
    }
}

