/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.entity;

import com.swdteam.common.entity.DMEntityUtils;
import com.swdteam.common.entity.EntityBaseModelID;
import com.swdteam.common.entity.EntityCyberMat;
import com.swdteam.common.entity.EntityDalekHuman;
import com.swdteam.common.entity.EntityLaser;
import com.swdteam.common.entity.EntityTimelord;
import com.swdteam.common.entity.ai.DalekLaserAttack;
import com.swdteam.common.entity.dalek.EntityDalek;
import com.swdteam.common.init.DMDamageSources;
import com.swdteam.common.init.DMItems;
import com.swdteam.common.init.DMSounds;
import com.swdteam.utils.DMUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="thedalekmod")
public class EntityCybermanWarrior
extends EntityBaseModelID
implements IRangedAttackMob {
    private final DalekLaserAttack aiArrowAttack = new DalekLaserAttack(this, 0.35, 20, 60, 50.0f);
    private static final DataParameter<Boolean> IS_SHOOTING = EntityDataManager.func_187226_a(EntityCybermanWarrior.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TARGET_ENTITY = EntityDataManager.func_187226_a(EntityCybermanWarrior.class, (DataSerializer)DataSerializers.field_187192_b);
    private final SoundEvent[] modernSounds = new SoundEvent[]{DMSounds.cyberDelete, DMSounds.cyberDeleted, DMSounds.CyberWillBecome};
    private int shootTime = 0;

    public EntityCybermanWarrior(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.3));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityDalek.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityTimelord.class, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityDalekHuman.class, true));
        this.setupdataManagerAndAI();
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
    }

    @Override
    public int getEntityTypes() {
        return 1;
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(6.0);
    }

    public boolean func_70652_k(Entity entity) {
        entity.func_70097_a((DamageSource)DMDamageSources.CYBERMAN, 4.0f);
        return super.func_70652_k(entity);
    }

    @Override
    public void setupdataManagerAndAI() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiArrowAttack);
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        super.func_70665_d((DamageSource)DMDamageSources.CYBERMAN, damageAmount);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_SHOOTING, (Object)false);
        this.func_184212_Q().func_187214_a(TARGET_ENTITY, (Object)-1);
    }

    public boolean isShooting() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_SHOOTING);
    }

    public void setShooting(boolean b) {
        this.func_184212_Q().func_187227_b(IS_SHOOTING, (Object)b);
    }

    public int getTarget() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY);
    }

    @Override
    public String getEntityName() {
        return "Cyberiad Cyberman";
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        if (!this.func_174814_R()) {
            this.func_184185_a(DMSounds.cyberStomp, 0.15f, 1.0f);
        }
        super.func_180429_a(pos, block);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isShooting()) {
            ++this.shootTime;
            if (this.shootTime == 100) {
                this.setShooting(false);
                this.shootTime = 0;
            }
        }
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.shootTime = 0;
        this.func_184212_Q().func_187227_b(IS_SHOOTING, (Object)true);
        EntityLaser laser = new EntityLaser(this.field_70170_p, (EntityLivingBase)this, EnumParticleTypes.REDSTONE);
        laser.setDamageSource(DMDamageSources.CYBERMAN_LASER);
        laser.setDamage(4.0f + (float)this.field_70170_p.func_175659_aa().func_151525_a());
        double X = target.field_70165_t - this.field_70165_t;
        double Y = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - laser.field_70163_u + 1.0;
        double Z = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(X * X + Z * Z));
        laser.func_70186_c(X, Y, Z, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
        SoundEvent sound = DMSounds.cyberman_shoot;
        this.func_184185_a(sound, 1.0f, 1.0f);
        this.field_70170_p.func_72838_d((Entity)laser);
    }

    protected SoundEvent func_184639_G() {
        SoundEvent sound = null;
        sound = this.modernSounds[this.field_70146_Z.nextInt(this.modernSounds.length)];
        return sound;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187602_cF;
    }

    public void func_70645_a(DamageSource cause) {
        if (DMUtils.RANDOM.nextInt(100) == 1) {
            EntityCyberMat cyberMat = new EntityCyberMat(this.field_70170_p);
            cyberMat.func_82149_j((Entity)this);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)cyberMat);
            }
        }
        super.func_70645_a(cause);
    }

    public void func_184724_a(boolean swingingArms) {
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        this.func_145779_a(DMItems.STEEL_INGOT, this.func_70681_au().nextInt(3));
        this.func_145779_a(DMItems.iAMMO, this.func_70681_au().nextInt(15));
        this.func_145779_a(DMItems.iCircuit, this.func_70681_au().nextInt(2));
        DMEntityUtils.dropRareItem((EntityLiving)this, DMItems.steelSword, 40, 1);
        super.func_70628_a(wasRecentlyHit, lootingModifier);
    }
}

