/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.regeneration.skinchanging.packet;

import com.swdteam.common.capability.CapabilityRegeneration;
import com.swdteam.common.capability.interfaces.IRegenerationCapability;
import com.swdteam.common.regeneration.skinchanging.SkinChangingHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class Packet_RegenSync
implements IMessage {
    public String uuid;
    public BufferedImage image;

    public Packet_RegenSync() {
    }

    public Packet_RegenSync(EntityPlayer player, BufferedImage image) {
        this.uuid = player.func_110124_au().toString();
        this.image = image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromBytes(ByteBuf buf) {
        this.uuid = ByteBufUtils.readUTF8String((ByteBuf)buf);
        ByteBufInputStream in = new ByteBufInputStream(buf);
        try {
            this.image = ImageIO.read((InputStream)in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.uuid);
        ByteBufOutputStream out = new ByteBufOutputStream(buf);
        try {
            if (this.image != null) {
                ImageIO.write((RenderedImage)this.image, "png", (OutputStream)out);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class Handler
    implements IMessageHandler<Packet_RegenSync, IMessage> {
        public IMessage onMessage(final Packet_RegenSync message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayer player = Minecraft.func_71410_x().field_71441_e.func_152378_a(UUID.fromString(message.uuid));
                    if (player != null) {
                        IRegenerationCapability capability = (IRegenerationCapability)player.getCapability(CapabilityRegeneration.REGEN_CAP, null);
                        capability.getSkinData().createLocation(player.func_174793_f().func_70005_c_());
                        SkinChangingHandler.addPlayer(player, capability.getSkinData().getBufferedImage());
                        SkinChangingHandler.changeSkin(player, capability.getSkinData().getLocation(), capability.getSkinData().getSkinChoice());
                    }
                }
            });
            return null;
        }
    }
}

