/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.network.packets;

import com.swdteam.common.tileentity.TileEntitySafe;
import com.swdteam.network.packets.AbstractServerMessageHandler;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_SafeConfirmMessage;
import com.swdteam.network.packets.Packet_SyncTileEntity;
import com.swdteam.utils.Player;
import com.swdteam.utils.WorldUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class Packet_AddSafeUser
implements IMessage {
    public String username;
    public String UUID;
    public BlockPos pos;
    public boolean addUser;

    public Packet_AddSafeUser() {
    }

    public Packet_AddSafeUser(BlockPos pos, String username, String UUID2, boolean add) {
        this.username = username;
        this.UUID = UUID2;
        this.pos = pos;
        this.addUser = add;
    }

    public void fromBytes(ByteBuf buf) {
        this.username = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.UUID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.addUser = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.username);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.UUID);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeBoolean(this.addUser);
    }

    public static class Handler
    extends AbstractServerMessageHandler<Packet_AddSafeUser> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, Packet_AddSafeUser message, MessageContext ctx) {
            player.func_184102_h().func_152344_a(() -> {
                World w = player.func_130014_f_();
                TileEntity te = w.func_175625_s(message.pos);
                EntityPlayerMP playerToAdd = player.func_184102_h().func_184103_al().func_152612_a(message.username);
                if (playerToAdd != null) {
                    Player playerCheck = new Player(playerToAdd.func_70005_c_(), playerToAdd.func_110124_au().toString());
                    if (te != null && te instanceof TileEntitySafe) {
                        TileEntitySafe safe = (TileEntitySafe)te;
                        if (player.func_110124_au().toString().equals(safe.getOwnerUUID())) {
                            if (message.addUser) {
                                if (safe.getUsers().contains(playerCheck)) {
                                    PacketHandler.INSTANCE.sendTo(new Packet_SafeConfirmMessage(TextFormatting.RED + message.username + " is already added."), (EntityPlayerMP)player);
                                } else if (safe.getUsers().size() >= 24) {
                                    PacketHandler.INSTANCE.sendTo(new Packet_SafeConfirmMessage(TextFormatting.RED + "Maximum of 24 users reached."), (EntityPlayerMP)player);
                                } else {
                                    safe.getUsers().add(new Player(playerToAdd.func_70005_c_(), playerToAdd.func_110124_au().toString()));
                                    PacketHandler.INSTANCE.sendTo(new Packet_SafeConfirmMessage(TextFormatting.GREEN + message.username + " has been added."), (EntityPlayerMP)player);
                                }
                            } else if (safe.getUsers().contains(playerCheck)) {
                                safe.getUsers().remove(playerCheck);
                                PacketHandler.INSTANCE.sendTo(new Packet_SafeConfirmMessage(TextFormatting.GREEN + message.username + " has been removed."), (EntityPlayerMP)player);
                            } else {
                                PacketHandler.INSTANCE.sendTo(new Packet_SafeConfirmMessage(TextFormatting.RED + message.username + " was not found."), (EntityPlayerMP)player);
                            }
                        } else {
                            PacketHandler.INSTANCE.sendTo(new Packet_SafeConfirmMessage(TextFormatting.RED + "You do not have permission."), (EntityPlayerMP)player);
                        }
                    } else {
                        PacketHandler.INSTANCE.sendTo(new Packet_SafeConfirmMessage(TextFormatting.RED + "Error"), (EntityPlayerMP)player);
                    }
                } else {
                    Player playerCheck = new Player(message.username, message.UUID);
                    if (te != null && te instanceof TileEntitySafe) {
                        TileEntitySafe safe = (TileEntitySafe)te;
                        if (safe.getUsers().contains(playerCheck)) {
                            safe.getUsers().remove(playerCheck);
                            PacketHandler.INSTANCE.sendTo(new Packet_SafeConfirmMessage(TextFormatting.GREEN + message.username + " has been removed."), (EntityPlayerMP)player);
                        } else {
                            PacketHandler.INSTANCE.sendTo(new Packet_SafeConfirmMessage(TextFormatting.RED + message.username + " was not found."), (EntityPlayerMP)player);
                        }
                    } else {
                        PacketHandler.INSTANCE.sendTo(new Packet_SafeConfirmMessage(TextFormatting.RED + message.username + " cannot be found."), (EntityPlayerMP)player);
                    }
                }
                te.func_70296_d();
                WorldUtils.markBlockForUpdate(te.func_145831_w(), te.func_174877_v());
                PacketHandler.INSTANCE.sendTo(new Packet_SyncTileEntity(te), (EntityPlayerMP)player);
            });
            return null;
        }
    }
}

