/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.network.packets;

import com.swdteam.common.data.WaypointData;
import com.swdteam.common.init.DMWaypoints;
import com.swdteam.network.packets.AbstractServerMessageHandler;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_SendWaypoints;
import com.swdteam.utils.Vector3;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class Packet_SaveWaypoint
implements IMessage {
    public WaypointData data;
    public int tardisID;

    public Packet_SaveWaypoint() {
    }

    public Packet_SaveWaypoint(int tardisID, WaypointData data) {
        this.data = data;
        this.tardisID = tardisID;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.tardisID);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.data.getWaypointName());
        buf.writeInt(this.data.getPos().x);
        buf.writeInt(this.data.getPos().y);
        buf.writeInt(this.data.getPos().z);
        buf.writeInt(this.data.getDimension());
        buf.writeFloat(this.data.getRotation());
    }

    public void fromBytes(ByteBuf buf) {
        this.tardisID = buf.readInt();
        this.data = new WaypointData(ByteBufUtils.readUTF8String((ByteBuf)buf), new Vector3(buf.readInt(), buf.readInt(), buf.readInt()), buf.readInt(), buf.readFloat());
    }

    public static class Handler
    extends AbstractServerMessageHandler<Packet_SaveWaypoint> {
        @Override
        public IMessage handleServerMessage(final EntityPlayer player, final Packet_SaveWaypoint message, MessageContext ctx) {
            player.func_184102_h().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    DMWaypoints.saveWaypoint(message.tardisID, message.data, null);
                    NBTTagCompound wp = DMWaypoints.getWaypointsAsNBT(message.tardisID, 0);
                    PacketHandler.INSTANCE.sendTo(new Packet_SendWaypoints(wp, DMWaypoints.getTotalWaypoints(message.tardisID)), (EntityPlayerMP)player);
                }
            });
            return null;
        }
    }
}

