/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.data;

import com.swdteam.common.dimensions.world.WorldProviderTardis;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_RequestTardisDataSync;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;

public class ClientTardisCache {
    private static Map<Integer, TardisData> data = new HashMap<Integer, TardisData>();
    public static TardisData DEFAULT_DATA = new TardisData(0);

    public static void requestData(int tardisID) {
        PacketHandler.INSTANCE.sendToServer(new Packet_RequestTardisDataSync(tardisID));
    }

    public static TardisData getTardisData(int id) {
        if (data.containsKey(id)) {
            return data.get(id);
        }
        ClientTardisCache.requestData(id);
        data.put(id, DEFAULT_DATA);
        return DEFAULT_DATA;
    }

    public static boolean hasTardisData(int id) {
        return data.containsKey(id);
    }

    public static boolean hasTardisData(BlockPos p) {
        return ClientTardisCache.hasTardisData(DMTardis.getIDForXZ(p.func_177958_n(), p.func_177952_p()));
    }

    public static TardisData getTardisData(BlockPos p) {
        return ClientTardisCache.getTardisData(DMTardis.getIDForXZ(p.func_177958_n(), p.func_177952_p()));
    }

    public static void requestCallback(TardisData tardisData) {
        if (tardisData != null) {
            data.put(tardisData.getTardisID(), tardisData);
            if (Minecraft.func_71410_x().field_71439_g.field_70170_p != null && Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73011_w instanceof WorldProviderTardis) {
                ((WorldProviderTardis)Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73011_w).brightnessTableUpdate(tardisData);
            }
        }
    }

    public static void clearTardisData() {
        data.clear();
    }
}

