/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.regeneration.skinchanging;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.swdteam.common.capability.CapabilityRegeneration;
import com.swdteam.common.capability.interfaces.IRegenerationCapability;
import com.swdteam.common.regeneration.RegenerationHandler;
import com.swdteam.common.regeneration.skinchanging.DMRegenBuffered;
import com.swdteam.common.regeneration.skinchanging.packet.Packet_RegenSkinSettings;
import com.swdteam.common.regeneration.skinchanging.packet.Packet_RegenSync;
import com.swdteam.common.regeneration.skinchanging.packet.Packet_RemovePlayerRegen;
import com.swdteam.common.regeneration.skinchanging.packet.Packet_SkinChangeRequest;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.utils.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SkinChangingHandler {
    public static ResourceLocation BACKUP_SKIN;
    public static String BACKUP_TYPE;
    @SideOnly(value=Side.CLIENT)
    public static Map<UUID, BufferedImage> skins;

    @SideOnly(value=Side.CLIENT)
    public static void changeSkin(EntityPlayer player, ResourceLocation location, SkinChoice choice) {
        if (location.toString().equalsIgnoreCase("minecraft:")) {
            return;
        }
        Object i = ReflectionHelper.getPrivateValue(AbstractClientPlayer.class, (Object)((AbstractClientPlayer)player), (int)0);
        if (i != null && i instanceof NetworkPlayerInfo) {
            try {
                Field[] fields = ((NetworkPlayerInfo)i).getClass().getDeclaredFields();
                Method[] methods = ((NetworkPlayerInfo)i).getClass().getDeclaredMethods();
                for (Field f : fields) {
                    if (f.getName().equalsIgnoreCase("field_187107_a") || f.getName().equalsIgnoreCase("playerTextures")) {
                        f.setAccessible(true);
                        Map t = (Map)f.get(i);
                        t.put(MinecraftProfileTexture.Type.SKIN, location);
                    }
                    if (!f.getName().equalsIgnoreCase("skinType") && !f.getName().equalsIgnoreCase("field_178863_g")) continue;
                    f.setAccessible(true);
                    String s = SkinChangingHandler.getSkinType(choice);
                    f.set(i, s);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void reset() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        IRegenerationCapability cap = RegenerationHandler.get((EntityPlayer)player);
        cap.getSkinData().reset();
        SkinChangingHandler.setupSkinReset((EntityPlayer)player, BACKUP_TYPE);
        PacketHandler.INSTANCE.sendToServer(new Packet_RegenSkinSettings("reset_skin", (EntityPlayer)player, player.func_110124_au().toString(), BACKUP_TYPE));
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean checkAndNotify(SkinChoice choice, EntityPlayer player) {
        if (choice == SkinChoice.ALEX) {
            if (DMRegenBuffered.alexSkins.size() <= 0) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("message.regen.fail.nextskin.alex", new Object[0]), true);
                return false;
            }
        } else if (choice == SkinChoice.STEVE && DMRegenBuffered.steveSkins.size() <= 0) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("message.regen.fail.nextskin.steve", new Object[0]), true);
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void addPlayer(EntityPlayer player, BufferedImage location) {
        if (!skins.containsKey(player.func_110124_au())) {
            skins.put(player.func_110124_au(), location);
        } else {
            skins.replace(player.func_110124_au(), location);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void shiftSkins(SkinChoice choice, BufferedImage f) {
        if (choice == SkinChoice.ALEX) {
            if (DMRegenBuffered.alexSkins.size() > 0) {
                DMRegenBuffered.alexSkins.remove(f);
                DMRegenBuffered.alexSkins.add(f);
            }
        } else if (choice == SkinChoice.STEVE && DMRegenBuffered.steveSkins.size() > 0) {
            DMRegenBuffered.steveSkins.remove(f);
            DMRegenBuffered.steveSkins.add(f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getBackupSkin() {
        return BACKUP_SKIN;
    }

    public static BufferedImage getMcSkin(String name) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new URL("https://minotar.net/download/" + name));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bufferedImage;
    }

    public static ResourceLocation getResourceImage(String name) {
        DynamicTexture dynamicTexture = new DynamicTexture(SkinChangingHandler.getMcSkin(name));
        dynamicTexture.func_110564_a();
        return Minecraft.func_71410_x().func_110434_K().func_110578_a(Minecraft.func_71410_x().field_71439_g.func_70005_c_(), dynamicTexture);
    }

    @SideOnly(value=Side.CLIENT)
    public static void setupSkinReset(EntityPlayer player, String backup) {
        Object i = ReflectionHelper.getPrivateValue(AbstractClientPlayer.class, (Object)((AbstractClientPlayer)player), (int)0);
        if (i != null && i instanceof NetworkPlayerInfo) {
            try {
                Field[] fields = ((NetworkPlayerInfo)i).getClass().getDeclaredFields();
                Method[] methods = ((NetworkPlayerInfo)i).getClass().getDeclaredMethods();
                for (Field field : fields) {
                    if (!field.getName().equalsIgnoreCase("playerTexturesLoaded") && !field.getName().equalsIgnoreCase("field_178864_d")) continue;
                    field.setAccessible(true);
                    field.setBoolean(i, false);
                }
                for (AccessibleObject accessibleObject : methods) {
                    if (!((Method)accessibleObject).getName().equalsIgnoreCase("loadPlayerTextures") && !((Method)accessibleObject).getName().equalsIgnoreCase("func_178841_j")) continue;
                    ((Method)accessibleObject).setAccessible(true);
                    ((Method)accessibleObject).invoke(i, new Object[0]);
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        try {
            SkinChangingHandler.changeSkin(player, Graphics.getTextureForPlayer(player.func_70005_c_()), SkinChangingHandler.getSkinTypeRevert(backup));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        player.func_146105_b((ITextComponent)new TextComponentString("You have succesfully reset your skin!"), false);
    }

    @SideOnly(value=Side.CLIENT)
    public static BufferedImage getRandomNextSkin(SkinChoice choice, BufferedImage last) {
        Object image = null;
        Random r = Minecraft.func_71410_x().field_71441_e.field_73012_v;
        if (choice == SkinChoice.ALEX) {
            if (DMRegenBuffered.alexSkins.size() > 0) {
                image = DMRegenBuffered.alexSkins.get(r.nextInt(DMRegenBuffered.alexSkins.size()));
            }
        } else if (choice == SkinChoice.STEVE && DMRegenBuffered.steveSkins.size() > 0) {
            image = DMRegenBuffered.steveSkins.get(r.nextInt(DMRegenBuffered.steveSkins.size()));
        }
        if (image.equals(last)) {
            if (choice == SkinChoice.ALEX) {
                if (DMRegenBuffered.alexSkins.size() > 1) {
                    image = DMRegenBuffered.alexSkins.get(1);
                }
            } else if (choice == SkinChoice.STEVE && DMRegenBuffered.steveSkins.size() > 1) {
                image = DMRegenBuffered.steveSkins.get(1);
            }
        }
        return image;
    }

    public static SkinChoice genSkinChoice(SkinChoice choice) {
        Random random = new Random();
        if (choice == SkinChoice.RANDOM) {
            int r = random.nextInt(2);
            choice = r == 1 ? SkinChoice.STEVE : SkinChoice.ALEX;
        }
        return choice;
    }

    public static String getSkinType(SkinChoice choice) {
        return choice == SkinChoice.ALEX ? "slim" : "default";
    }

    public static SkinChoice getSkinTypeRevert(String type) {
        if (type.equalsIgnoreCase("default")) {
            return SkinChoice.STEVE;
        }
        if (type.equalsIgnoreCase("slim")) {
            return SkinChoice.ALEX;
        }
        return SkinChoice.STEVE;
    }

    static {
        BACKUP_TYPE = "default";
        skins = new HashMap<UUID, BufferedImage>();
    }

    @Mod.EventBusSubscriber
    public static class SkinChangeEvents {
        @SubscribeEvent
        public static void onPlayerLeaveWorld(PlayerEvent.PlayerLoggedOutEvent e) {
            if (e.player.field_70170_p.field_72995_K) {
                skins.clear();
            }
            if (e.player instanceof EntityPlayerMP) {
                PacketHandler.INSTANCE.sendToAll(new Packet_RemovePlayerRegen(e.player.func_110124_au().toString()));
            }
        }

        @SubscribeEvent
        public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent e) {
            IRegenerationCapability capa;
            if (e.player instanceof EntityPlayerMP && (capa = (IRegenerationCapability)e.player.getCapability(CapabilityRegeneration.REGEN_CAP, null)).hasChangedSkin()) {
                PacketHandler.INSTANCE.sendToAll(new Packet_RemovePlayerRegen(e.player.func_110124_au().toString()));
                if (capa.hasChangedSkin()) {
                    capa.skinUpdate();
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerJoinWorld(PlayerEvent.PlayerLoggedInEvent e) {
            IRegenerationCapability capa;
            if (e.player instanceof EntityPlayerMP && (capa = (IRegenerationCapability)e.player.getCapability(CapabilityRegeneration.REGEN_CAP, null)).hasChangedSkin()) {
                PacketHandler.INSTANCE.sendTo(new Packet_RemovePlayerRegen(true), (EntityPlayerMP)e.player);
                PacketHandler.INSTANCE.sendToAll(new Packet_RemovePlayerRegen(e.player.func_110124_au().toString()));
                if (capa.hasChangedSkin()) {
                    capa.skinUpdate();
                }
            }
        }

        @SubscribeEvent
        public static void respawn(PlayerEvent.PlayerRespawnEvent e) {
            PacketHandler.INSTANCE.sendToAll(new Packet_RemovePlayerRegen(e.player.func_110124_au().toString()));
        }

        @SubscribeEvent
        public static void onLivingTick(LivingEvent.LivingUpdateEvent e) {
            if (e.getEntity() instanceof EntityPlayer && e.getEntityLiving().field_70173_aa % 10 == 0) {
                if (e.getEntity().field_70170_p.field_72995_K) {
                    IRegenerationCapability capability;
                    EntityPlayer player = (EntityPlayer)e.getEntity();
                    if (player != null && (capability = (IRegenerationCapability)player.getCapability(CapabilityRegeneration.REGEN_CAP, null)).hasChangedSkin() && !skins.containsKey(player.func_110124_au()) && !e.getEntity().field_70128_L) {
                        PacketHandler.INSTANCE.sendToServer(new Packet_SkinChangeRequest(player));
                    }
                } else {
                    EntityPlayer player = (EntityPlayer)e.getEntity();
                    IRegenerationCapability capability = (IRegenerationCapability)player.getCapability(CapabilityRegeneration.REGEN_CAP, null);
                    if (capability.hasChangedSkin() && capability.isSkinUpdate() && player.field_70170_p.func_72820_D() % 100L == 0L) {
                        PacketHandler.INSTANCE.sendToAll(new Packet_RegenSync(player, capability.getSkinData().getBufferedImage()));
                        capability.resetSkinUpdate();
                        capability.syncToPlayer();
                    }
                }
            }
            if (e.getEntity().field_70170_p.field_72995_K && e.getEntityLiving().field_70170_p.func_72820_D() % 1000L == 0L && skins.size() > 0) {
                skins.clear();
            }
        }
    }

    public static enum SkinChoice {
        NONE("none"),
        STEVE("steve"),
        ALEX("alex"),
        RANDOM("random");

        String choice;
        String directory;

        private SkinChoice(String s) {
            this.choice = s;
        }

        public String getChoice() {
            return this.choice;
        }

        public static SkinChoice getSkinChoice(String s) {
            for (SkinChoice choice : SkinChoice.values()) {
                if (!choice.getChoice().equalsIgnoreCase(s)) continue;
                return choice;
            }
            return NONE;
        }
    }
}

