/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.gui.tardis.screens;

import com.swdteam.client.gui.elements.GuiButtonImage;
import com.swdteam.client.gui.elements.GuiTextBox;
import com.swdteam.client.gui.elements.PlanetRenders;
import com.swdteam.client.gui.tardis.GuiTardisMonitorNew;
import com.swdteam.client.gui.tardis.screens.AbstractTardisScreen;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.planets.IPlanet;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_UpdateTardisDataField;
import com.swdteam.network.packets.Packet_UpdateTardisSettings;
import com.swdteam.utils.Graphics;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class TardisScreenCoordTravel
extends AbstractTardisScreen {
    public double travelFuelPercent = 0.0;
    private String facingText = "North";
    private int extrot = 0;
    public IPlanet selectedPlanetObject = null;
    public int selectedPlanet = 0;
    public GuiTextBox xCoord;
    public GuiTextBox yCoord;
    public GuiTextBox zCoord;
    private Vec3d pos1;
    private Vec3d pos2;

    @Override
    public void show(GuiScreen screen) {
        TardisData data = ((GuiTardisMonitorNew)screen).data;
        if (data.getTravelRotation() > 360.0f) {
            data.setTravelRotation(360.0f);
        }
        String tardisfacing = "Facing (N)";
        switch ((int)(data.getTravelRotation() / 45.0f)) {
            case 0: {
                tardisfacing = "Facing (N)";
                break;
            }
            case 1: {
                tardisfacing = "Facing (NE)";
                break;
            }
            case 2: {
                tardisfacing = "Facing (E)";
                break;
            }
            case 3: {
                tardisfacing = "Facing (SE)";
                break;
            }
            case 4: {
                tardisfacing = "Facing (S)";
                break;
            }
            case 5: {
                tardisfacing = "Facing (SW)";
                break;
            }
            case 6: {
                tardisfacing = "Facing (W)";
                break;
            }
            case 7: {
                tardisfacing = "Facing (NW)";
            }
        }
        this.extrot = (int)(data.getTravelRotation() / 45.0f);
        this.facingText = tardisfacing;
    }

    @Override
    public void init(GuiScreen screen) {
        this.xCoord = new GuiTextBox(0, this.fontRenderer, screen.field_146294_l / 2 + 10, screen.field_146295_m / 2 - 44, 100, 12);
        this.xCoord.func_146193_g(-1381654);
        this.xCoord.borderColor = 0x444444FF;
        this.xCoord.backgroundColor = 0x44FFFFFF;
        this.xCoord.func_146180_a("0");
        this.yCoord = new GuiTextBox(1, this.fontRenderer, screen.field_146294_l / 2 + 10, screen.field_146295_m / 2 - 14, 100, 12);
        this.yCoord.func_146193_g(-1381654);
        this.yCoord.borderColor = 0x444444FF;
        this.yCoord.backgroundColor = 0x44FFFFFF;
        this.yCoord.func_146180_a("64");
        this.zCoord = new GuiTextBox(2, this.fontRenderer, screen.field_146294_l / 2 + 10, screen.field_146295_m / 2 + 16, 100, 12);
        this.zCoord.func_146193_g(-1381654);
        this.zCoord.borderColor = 0x444444FF;
        this.zCoord.backgroundColor = 0x44FFFFFF;
        this.zCoord.func_146180_a("0");
        if (screen instanceof GuiTardisMonitorNew) {
            GuiTardisMonitorNew s = (GuiTardisMonitorNew)screen;
            s.getButtonList().add(new GuiButtonImage(10, s.field_146294_l / 2 - 100, s.field_146295_m / 2 - 28, 0, 136, 10, 20).setTooltip("Previous"));
            s.getButtonList().add(new GuiButtonImage(11, s.field_146294_l / 2 - 21, s.field_146295_m / 2 - 28, 10, 136, 10, 20).setTooltip("Next"));
            s.getButtonList().add(new GuiButtonImage(12, s.field_146294_l / 2 + 9, s.field_146295_m / 2 + 34, 20, 136, 42, 14).setTooltip("Save Location"));
            s.getButtonList().add(new GuiButtonImage(13, s.field_146294_l / 2 + 55, s.field_146295_m / 2 + 34, 20, 164, 42, 14).setTooltip("Rotate Tardis"));
            this.selectedPlanet = DMDimensions.getPlanetOrderedList().indexOf(s.data.getTardisDestinationDimension());
            if (s.data.getTravelToLocation() != null) {
                this.xCoord.func_146180_a(s.data.getTravelToLocation().x + "");
                this.yCoord.func_146180_a(s.data.getTravelToLocation().y + "");
                this.zCoord.func_146180_a(s.data.getTravelToLocation().z + "");
            }
        }
        this.selectedPlanetObject = DMDimensions.getPlanetForDimension(DMDimensions.getIDOfDimensionAtIndex(this.selectedPlanet));
    }

    @Override
    public void render(GuiScreen screen, float mouseX, float mouseY, float partialTicks) {
        float width = screen.field_146294_l;
        float height = screen.field_146295_m;
        this.fontRenderer.func_175065_a("Travel", width / 2.0f - (float)(this.fontRenderer.func_78256_a("Travel") / 2), height / 2.0f - 72.0f, -6710785, false);
        this.fontRenderer.func_175065_a("X Coord:", width / 2.0f + 9.0f, height / 2.0f - 56.0f, -6710785, false);
        this.fontRenderer.func_175065_a("Y Coord:", width / 2.0f + 9.0f, height / 2.0f - 26.0f, -6710785, false);
        this.fontRenderer.func_175065_a("Z Coord:", width / 2.0f + 9.0f, height / 2.0f + 4.0f, -6710785, false);
        this.xCoord.func_146194_f();
        this.yCoord.func_146194_f();
        this.zCoord.func_146194_f();
        if (this.selectedPlanetObject != null) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ResourceLocation renderer = this.selectedPlanetObject.getPlanetRenderer();
            Graphics.draw(renderer != null ? renderer : PlanetRenders.TEMPLATE, width / 2.0f - 88.0f, height / 2.0f - 48.0f, 64.0f, 64.0f, 0);
            this.fontRenderer.func_175065_a(this.selectedPlanetObject.getPlanetName(), width / 2.0f - (float)(this.fontRenderer.func_78256_a(this.selectedPlanetObject.getPlanetName()) / 2) - 55.0f, height / 2.0f + 22.0f, -6710785, false);
        }
        this.fontRenderer.func_175065_a(this.facingText, width / 2.0f - (float)(this.fontRenderer.func_78256_a(this.facingText) / 2) - 55.0f, height / 2.0f + 34.0f, -6710785, false);
        String fuel = "Fuel Usage " + this.travelFuelPercent + "%";
        this.fontRenderer.func_175065_a(fuel, width / 2.0f - (float)(this.fontRenderer.func_78256_a(fuel) / 2) + 60.0f, height / 2.0f + 54.0f, -6710785, false);
    }

    @Override
    public void update(GuiScreen screen) {
        this.xCoord.func_146178_a();
        this.yCoord.func_146178_a();
        this.zCoord.func_146178_a();
        GuiTardisMonitorNew gui = (GuiTardisMonitorNew)screen;
        try {
            int xP = Integer.parseInt(this.xCoord.func_146179_b());
            int yP = Integer.parseInt(this.yCoord.func_146179_b());
            int zP = Integer.parseInt(this.zCoord.func_146179_b());
            this.pos1 = new Vec3d((double)xP, (double)yP, (double)zP);
            this.pos2 = new Vec3d((double)gui.data.getCurrentTardisPosition().x, (double)gui.data.getCurrentTardisPosition().y, (double)gui.data.getCurrentTardisPosition().z);
            Vec3d v = new Vec3d((double)xP, (double)yP, (double)zP);
            this.travelFuelPercent = DMTardis.calculateFuel(v, this.pos2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void keyTyped(char ch, int keyCode) {
        if (Character.isDigit(ch) || keyCode == 203 || keyCode == 205 || (keyCode == 12 || keyCode == 74) && this.xCoord.func_146179_b().length() <= 0 || keyCode == 14) {
            this.xCoord.func_146201_a(ch, keyCode);
        }
        if (Character.isDigit(ch) || keyCode == 203 || keyCode == 205 || keyCode == 14) {
            this.yCoord.func_146201_a(ch, keyCode);
        }
        if (Character.isDigit(ch) || keyCode == 203 || keyCode == 205 || (keyCode == 12 || keyCode == 74) && this.zCoord.func_146179_b().length() <= 0 || keyCode == 14) {
            this.zCoord.func_146201_a(ch, keyCode);
        }
    }

    @Override
    public void mouseClicked(GuiScreen screen, int button, int mX, int mY) {
        this.xCoord.func_146192_a(mX, mY, button);
        this.yCoord.func_146192_a(mX, mY, button);
        this.zCoord.func_146192_a(mX, mY, button);
    }

    @Override
    public void actionPerformed(GuiScreen screen, GuiButton button) {
        GuiTardisMonitorNew gui = (GuiTardisMonitorNew)screen;
        if (button.field_146127_k == 11) {
            this.selectedPlanet = this.selectedPlanet + 1 >= DMDimensions.getPlanetOrderedList().size() ? 0 : ++this.selectedPlanet;
            this.selectedPlanetObject = DMDimensions.getPlanetForDimension(DMDimensions.getIDOfDimensionAtIndex(this.selectedPlanet));
        }
        if (button.field_146127_k == 10) {
            this.selectedPlanet = this.selectedPlanet - 1 < 0 ? DMDimensions.getPlanetOrderedList().size() - 1 : --this.selectedPlanet;
            this.selectedPlanetObject = DMDimensions.getPlanetForDimension(DMDimensions.getIDOfDimensionAtIndex(this.selectedPlanet));
        }
        if (button.field_146127_k == 12) {
            PacketHandler.INSTANCE.sendToServer(new Packet_UpdateTardisDataField(gui.data.getTardisID(), "tardisDIM", DMDimensions.getIDOfDimensionAtIndex(this.selectedPlanet) + ""));
            PacketHandler.INSTANCE.sendToServer(new Packet_UpdateTardisDataField(gui.data.getTardisID(), "position", this.xCoord.func_146179_b() + ":" + this.yCoord.func_146179_b() + ":" + this.zCoord.func_146179_b()));
            gui.field_146297_k.func_147108_a(null);
        }
        if (button.field_146127_k == 13) {
            String tardisfacing = "Facing (N)";
            ++this.extrot;
            if (this.extrot > 7) {
                this.extrot = 0;
            }
            switch (this.extrot) {
                case 0: {
                    tardisfacing = "Facing (N)";
                    break;
                }
                case 1: {
                    tardisfacing = "Facing (NE)";
                    break;
                }
                case 2: {
                    tardisfacing = "Facing (E)";
                    break;
                }
                case 3: {
                    tardisfacing = "Facing (SE)";
                    break;
                }
                case 4: {
                    tardisfacing = "Facing (S)";
                    break;
                }
                case 5: {
                    tardisfacing = "Facing (SW)";
                    break;
                }
                case 6: {
                    tardisfacing = "Facing (W)";
                    break;
                }
                case 7: {
                    tardisfacing = "Facing (NW)";
                }
            }
            this.facingText = tardisfacing;
            PacketHandler.INSTANCE.sendToServer(new Packet_UpdateTardisSettings(gui.data.getTardisID(), "tardislanding", "" + this.extrot));
        }
    }
}

