/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.init.skinpacks.skinpack;

import com.swdteam.client.init.skinpacks.DMSkinpack;
import com.swdteam.utils.FileUtils;
import com.swdteam.utils.Graphics;
import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class Skin {
    private String skinName;
    private String modelName;
    private FileLocation textureLocation;
    private String texture;
    private Object skinTexture;
    private ModelBase model;
    private BufferedImage texture_buffered;

    public void render(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netheadYaw, float headPitch, float scaleFactor) {
        this.bindTexture();
        GlStateManager.func_179109_b((float)0.0f, (float)-0.1f, (float)0.0f);
        if (this.model != null) {
            if (this.model instanceof ModelBiped) {
                ModelBiped biped = (ModelBiped)this.model;
                biped.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netheadYaw, headPitch, scaleFactor, entity);
            }
            this.model.func_78088_a(entity, limbSwing, limbSwingAmount, ageInTicks, netheadYaw, headPitch, scaleFactor);
        }
    }

    public void bindTexture() {
        if (this.skinTexture != null) {
            if (this.skinTexture instanceof ResourceLocation) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a((ResourceLocation)this.skinTexture);
            } else if (this.skinTexture instanceof Integer && this.texture_buffered != null) {
                Graphics.bindTexture((Integer)this.skinTexture);
            }
        }
    }

    public void setup() {
        this.model = DMSkinpack.models.get(this.modelName);
        if (this.textureLocation != null && this.texture != null) {
            if (this.textureLocation == FileLocation.INTERNAL) {
                this.skinTexture = FileUtils.newResourceLocation("thedalekmod:" + this.texture + ".png");
            } else {
                this.skinTexture = 0;
                this.texture_buffered = DMSkinpack.textures.get(this.texture);
                if (this.texture_buffered != null) {
                    this.skinTexture = Graphics.loadTexture(this.texture_buffered);
                }
            }
        }
    }

    public void setTexture(String texture) {
        this.texture = texture;
    }

    public void setModel(ModelBase model) {
        this.model = model;
    }

    public void setSkinTexture(Object skinTexture) {
        this.skinTexture = skinTexture;
    }

    public ModelBase getModel() {
        return this.model;
    }

    public String getSkinName() {
        return this.skinName;
    }

    public void setSkinName(String skinName) {
        this.skinName = skinName;
    }

    public FileLocation getTextureLocation() {
        return this.textureLocation;
    }

    public void setTextureLocation(FileLocation textureLocation) {
        this.textureLocation = textureLocation;
    }

    public Object getSkinTexture() {
        return this.skinTexture;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public static enum FileLocation {
        INTERNAL,
        EXTERNAL;

    }
}

