/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.block.tardis.console_controls;

import com.swdteam.common.block.BlockDMTileEntityBase;
import com.swdteam.common.block.tardis.console_controls.IPanelControl;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMSounds;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTardisDoorLock
extends BlockDMTileEntityBase
implements IPanelControl {
    public BlockTardisDoorLock(Supplier<TileEntity> tClass) {
        super(tClass);
    }

    @Override
    public String getDesc() {
        return "Door Lock";
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TardisData data;
        if (hand == EnumHand.MAIN_HAND && !worldIn.field_72995_K && worldIn.field_73011_w.getDimension() == DMDimensions.DIM_TARDIS_ID && (data = DMTardis.getTardis(pos)) != null) {
            if (data.isLocked()) {
                data.setLocked(false);
                worldIn.func_184133_a(null, pos, DMSounds.circuit_added, SoundCategory.BLOCKS, 1.0f, 1.0f);
                playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "The Tardis doors are now unlocked!"));
            } else {
                if (data.isDoorOpen()) {
                    data.setDoorOpen(false);
                }
                data.setLocked(true);
                worldIn.func_184133_a(null, pos, DMSounds.tardisKeyLock, SoundCategory.BLOCKS, 1.0f, 1.0f);
                playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "The Tardis doors are now locked!"));
            }
            TardisSaveHandler.saveTardis(data);
        }
        return true;
    }
}

