/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.event;

import com.google.common.collect.Lists;
import com.swdteam.common.block.BlockTardisDoorBase;
import com.swdteam.common.block.BlockTileEntityDoorBase;
import com.swdteam.common.block.tardis.BlockSotoDoor;
import com.swdteam.common.block.tardis.BlockTardis;
import com.swdteam.common.data.BlockData;
import com.swdteam.common.dimensions.world.WorldProviderTardis;
import com.swdteam.common.entity.EntityAuton;
import com.swdteam.common.entity.EntityBaseModelID;
import com.swdteam.common.entity.EntityClockworkDroid;
import com.swdteam.common.entity.EntityCyberman;
import com.swdteam.common.entity.EntityCybermanCyberaid;
import com.swdteam.common.entity.EntityGasmaskZombie;
import com.swdteam.common.entity.EntityIceWarrior;
import com.swdteam.common.entity.EntitySlitheen;
import com.swdteam.common.entity.EntitySontaran;
import com.swdteam.common.entity.EntityYeti;
import com.swdteam.common.init.DMSchematics;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tileentity.DMTileEntityBase;
import com.swdteam.common.tileentity.TileEntityMoment;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.common.world.gen.structures.global.OreGeneration;
import com.swdteam.main.TheDalekMod;
import com.swdteam.main.config.DMConfig;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_SyncEntityFlattening;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.WorldUtils;
import com.swdteam.utils.world.SchematicUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class ServerTickEvent {
    public static List<BlockData> blockData = new ArrayList<BlockData>();
    public static Map<String, EntitySizeData> entityChangeSizes = new HashMap<String, EntitySizeData>();
    private static int bl = DMSchematics.TARDISBoundary.blocks.size();
    static int halfdays = DMConfig.serverSide.invasiondays * 2;

    public static void addEntitySize(EntityLivingBase base, float size, EntitySizeData.VARIANT sizeData) {
        EntitySizeData data = new EntitySizeData(size, sizeData);
        entityChangeSizes.put(base.func_110124_au().toString(), data);
        PacketHandler.INSTANCE.sendToAll(new Packet_SyncEntityFlattening("add", base.func_110124_au().toString(), TheDalekMod.GSON.toJson((Object)data)));
    }

    public static void addEntitySizeToServer(EntityLivingBase base, float size, EntitySizeData.VARIANT sizeData) {
        EntitySizeData data = new EntitySizeData(size, sizeData);
        PacketHandler.INSTANCE.sendToServer(new Packet_SyncEntityFlattening("add", base.func_110124_au().toString(), TheDalekMod.GSON.toJson((Object)data)));
    }

    public static float getSizeEntity(EntityLivingBase base) {
        if (entityChangeSizes.containsKey(base.func_110124_au().toString())) {
            return ServerTickEvent.entityChangeSizes.get((Object)base.func_110124_au().toString()).size;
        }
        return 1.0f;
    }

    public static void removeEntitySize(EntityLivingBase base) {
        PacketHandler.INSTANCE.sendToAll(new Packet_SyncEntityFlattening("remove", base.func_110124_au().toString()));
    }

    public static void syncAllEntitySizesPlayer(EntityPlayerMP player) {
        if (entityChangeSizes.size() > 0) {
            for (Map.Entry<String, EntitySizeData> dataEntry : entityChangeSizes.entrySet()) {
                PacketHandler.INSTANCE.sendTo(new Packet_SyncEntityFlattening("add", dataEntry.getKey(), TheDalekMod.GSON.toJson((Object)dataEntry.getValue())), player);
            }
        }
    }

    @SubscribeEvent
    public static void playerConnect(PlayerEvent.PlayerLoggedInEvent e) {
        if (!e.player.field_70170_p.field_72995_K) {
            ServerTickEvent.syncAllEntitySizesPlayer((EntityPlayerMP)e.player);
        }
    }

    @SubscribeEvent
    public static void playerDisconnect(PlayerEvent.PlayerLoggedOutEvent e) {
        if (e.player.field_70170_p.field_72995_K) {
            entityChangeSizes.clear();
        }
    }

    @SubscribeEvent
    public static void stopTARDISGrief(PlayerInteractEvent event) {
        if (DMConfig.tardis.stopTARDISGriefing && !event.getEntityPlayer().field_70170_p.field_72995_K && event.getEntityPlayer().field_70170_p.field_73011_w instanceof WorldProviderTardis) {
            EntityPlayer player = event.getEntityPlayer();
            if (event.getHand() == EnumHand.MAIN_HAND || event.getHand() == EnumHand.OFF_HAND) {
                Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
                if (block instanceof BlockTardisDoorBase || block instanceof BlockTardisDoorBase || block instanceof BlockSotoDoor || block instanceof BlockTileEntityDoorBase) {
                    return;
                }
                if (!DMTardis.hasPermission(event.getPos(), player)) {
                    PlayerUtils.Messaging.sendStatusMessageToPlayer(player, TextFormatting.RED + "Cannot Interact outside of your TARDIS", true);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent e) {
        World w = e.getWorld();
        BlockPos p = new BlockPos(e.getExplosion().getPosition().field_72450_a, e.getExplosion().getPosition().field_72448_b, e.getExplosion().getPosition().field_72449_c);
        int d = 6;
        for (BlockPos pos : BlockPos.func_191532_a((int)(p.func_177958_n() - d), (int)(p.func_177956_o() - d), (int)(p.func_177952_p() - d), (int)(p.func_177958_n() + d), (int)(p.func_177956_o() + d), (int)(p.func_177952_p() + d))) {
            TileEntityTardis tile;
            if (!(w.func_180495_p(pos).func_177230_c() instanceof BlockTardis) || !(w.func_175625_s(pos) instanceof TileEntityTardis) || (tile = (TileEntityTardis)w.func_175625_s(pos)).getTardisData() == null) continue;
            int f1 = 1;
            if (e.getExplosion().func_94613_c() instanceof EntityWither) {
                f1 = 6;
            } else if (e.getExplosion().func_94613_c() instanceof EntityCreeper) {
                f1 = ((EntityCreeper)e.getExplosion().func_94613_c()).func_70830_n() ? 6 : 3;
            } else if (e.getExplosion().func_94613_c() instanceof EntityPlayer) {
                f1 = 4;
            }
            double x = e.getExplosion().getPosition().field_72450_a - (double)tile.func_174877_v().func_177958_n();
            double y = e.getExplosion().getPosition().field_72448_b - (double)tile.func_174877_v().func_177956_o();
            double z = e.getExplosion().getPosition().field_72449_c - (double)tile.func_174877_v().func_177952_p();
            double distance = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
            int damage = (int)((double)(200 * f1) / (distance + 1.0));
            int health = tile.getTardisData().getTardisHealth();
            if (!tile.getTardisData().areForcefieldsEnabled()) {
                tile.getTardisData().setTardisHealth(health - damage);
                continue;
            }
            tile.getTardisData().setTardisHealth(health - 20);
        }
    }

    @SubscribeEvent
    public static void onMobDrops(LivingDropsEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            EntityPlayerMP e = (EntityPlayerMP)event.getEntity();
            if (e.func_174793_f().func_70005_c_().equals("RedDash16")) {
                e.func_145779_a(Item.func_150898_a((Block)Blocks.field_150330_I), 64);
            }
            if (e.func_174793_f().func_70005_c_().equals("1WTC")) {
                e.func_145779_a(Item.func_150898_a((Block)Blocks.field_150335_W), 3);
            }
        }
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent e) {
        for (int i = 0; i < blockData.size(); ++i) {
            TileEntity t;
            BlockData tempData = blockData.get(i);
            if (tempData.getTime() + 2500L >= System.currentTimeMillis()) continue;
            WorldServer w = TheDalekMod.FML.getMinecraftServerInstance().func_71218_a(tempData.getDimension());
            w.func_175656_a(tempData.getPos(), tempData.getBlock());
            if (tempData.getTileEntityData() != null && tempData.getPos() != null && (t = w.func_175625_s(tempData.getPos())) != null && tempData.getTileEntityData() != null) {
                t.func_145839_a(tempData.getTileEntityData());
            }
            blockData.remove(i);
        }
    }

    @SubscribeEvent
    public static void TARDISboundary(TickEvent.WorldTickEvent e) {
        if (DMSchematics.TARDIS_BOUNDARIES != null && DMSchematics.TARDIS_BOUNDARIES.size() > 0 && DMSchematics.TARDISBoundary.blocks != null && DMSchematics.TARDISBoundary.blocks.size() > 0 && DMSchematics.TARDIS_BOUNDARIES.get(0) != null) {
            if (bl > 0) {
                for (int i = 0; i < DMSchematics.TARDISBoundary.blocks.size() / 8 && bl != 0; ++i) {
                    IBlockState block = TheDalekMod.FML.getMinecraftServerInstance().func_71218_a(DMConfig.dimensionIDs.Tardis_Dimension_ID).func_180495_p(DMSchematics.TARDISBoundary.blocks.get(--bl).getPos().func_177982_a(DMSchematics.TARDIS_BOUNDARIES.get(0).func_177958_n(), DMSchematics.TARDIS_BOUNDARIES.get(0).func_177956_o(), DMSchematics.TARDIS_BOUNDARIES.get(0).func_177952_p()));
                    if (block == DMSchematics.TARDISBoundary.blocks.get(bl).getState()) continue;
                    WorldUtils.setBlockFast((World)TheDalekMod.FML.getMinecraftServerInstance().func_71218_a(DMConfig.dimensionIDs.Tardis_Dimension_ID), DMSchematics.TARDISBoundary.blocks.get(bl).getPos().func_177982_a(DMSchematics.TARDIS_BOUNDARIES.get(0).func_177958_n(), DMSchematics.TARDIS_BOUNDARIES.get(0).func_177956_o(), DMSchematics.TARDIS_BOUNDARIES.get(0).func_177952_p()), DMSchematics.TARDISBoundary.blocks.get(bl).getState(), 2);
                }
            } else {
                bl = DMSchematics.TARDISBoundary.blocks.size();
                DMSchematics.TARDIS_BOUNDARIES.remove(0);
            }
        }
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.WorldTickEvent e) {
        if (DMConfig.serverSide.dalekInvasions && e.world.func_82736_K().func_82766_b("doMobSpawning") && e.world.func_175659_aa() != EnumDifficulty.PEACEFUL) {
            int day = (int)Math.ceil(e.world.func_72820_D() / 12000L);
            if (e.world.field_73011_w.getDimension() == 0 && day % halfdays == halfdays - 2 && e.world.func_72863_F() instanceof ChunkProviderServer) {
                ChunkProviderServer chunkProvider = (ChunkProviderServer)e.world.func_72863_F();
                for (Chunk chunk : Lists.newArrayList((Iterable)chunkProvider.func_189548_a())) {
                    EntityClockworkDroid Droid;
                    EntitySlitheen Slitheen;
                    EntitySontaran Sontaran;
                    EntityAuton Auton;
                    EntityBaseModelID Cyberman;
                    if (e.world.field_73012_v.nextInt(1008 / e.world.func_175659_aa().func_151525_a()) != 2 || WorldUtils.getEntityLivingCountInChunk(e.world, chunk) >= 3 || WorldUtils.getPlayerCountInChunk(e.world, chunk) > 0) continue;
                    if (day == halfdays - 2 + halfdays * 0) {
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 12, 11, false, 69);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 1) {
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 4, 3, true, 1);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 2) {
                        Cyberman = new EntityCyberman(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)Cyberman, 3, 3, false, 1);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 3) {
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 4, 5, true, 9);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 4) {
                        EntityYeti Yeti = new EntityYeti(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)Yeti, 0, 0, false, 0);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 5) {
                        Cyberman = new EntityCyberman(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)Cyberman, 5, 5, false, 1);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 6) {
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 25, 24, true, 26);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 7) {
                        EntityIceWarrior IceWarrior = new EntityIceWarrior(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)IceWarrior, 0, 0, false, 0);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 8) {
                        Auton = new EntityAuton(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)Auton, e.world.field_73012_v.nextInt(9), 0, false, 10);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 9) {
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 6, 7, true, 69);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 10) {
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 14, 14, false, 69);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 11) {
                        Sontaran = new EntitySontaran(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)Sontaran, 0, 0, false, 0);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 12) {
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 15, 17, true, 13);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 13) {
                        Cyberman = new EntityCyberman(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)Cyberman, 0, 0, true, 12);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 14) {
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 19, 19, true, 20);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 15) {
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 16, 18, true, 19);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 16) {
                        Auton = new EntityAuton(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)Auton, e.world.field_73012_v.nextInt(9), 0, false, 10);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 17) {
                        Slitheen = new EntitySlitheen(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)Slitheen, 0, 0, false, 10);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 18) {
                        EntityGasmaskZombie EmptyChild = new EntityGasmaskZombie(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)EmptyChild, e.world.field_73012_v.nextInt(9), 0, false, 10);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 19) {
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 27, 66, true, 27);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 20) {
                        Droid = new EntityClockworkDroid(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)Droid, 0, 1, true, 2);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 21) {
                        Cyberman = new EntityCyberman(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)Cyberman, 1, 6, true, 4);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 22) {
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 27, 28, false, 27);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 23) {
                        Sontaran = new EntitySontaran(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)Sontaran, 2, 2, false, 0);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 24) {
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 27, 31, false, 27);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 25) {
                        Cyberman = new EntityCyberman(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)Cyberman, 1, 6, true, 4);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 26) {
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 32, 35, true, 33);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 27) {
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 37, 38, true, 36);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 28) {
                        Cyberman = new EntityCybermanCyberaid(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)Cyberman, 0, 0, false, 0);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 29) {
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 27, 27, true, 68);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 30) {
                        Cyberman = new EntityCybermanCyberaid(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)Cyberman, 0, 0, false, 0);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 31) {
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 9, 10, true, 2);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 32) {
                        Cyberman = new EntityCyberman(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)Cyberman, 3, 1, true, 7);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 33) {
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 39, 48, true, 49);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 34) {
                        Cyberman = new EntityCyberman(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)Cyberman, 7, 6, false, 7);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 40 || day == halfdays - 2 + halfdays * 145 || day == halfdays - 2 + halfdays * 400) {
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 53, 54, true, 55);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 70 || day == halfdays - 2 + halfdays * 295) {
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 58, 59, true, 60);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 50 || day == halfdays - 2 + halfdays * 110 || day == halfdays - 2 + halfdays * 260) {
                        Cyberman = new EntityCyberman(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)Cyberman, 7, 6, false, 7);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 80 || day == halfdays - 2 + halfdays * 160) {
                        OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 82, 83, true, 84);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 60 || day == halfdays - 2 + halfdays * 130 || day == halfdays - 2 + halfdays * 250) {
                        Auton = new EntityAuton(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)Auton, e.world.field_73012_v.nextInt(9), 0, false, 10);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 100 || day == halfdays - 2 + halfdays * 210) {
                        Slitheen = new EntitySlitheen(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)Slitheen, 0, 0, false, 10);
                        continue;
                    }
                    if (day == halfdays - 2 + halfdays * 90 || day == halfdays - 2 + halfdays * 190 || day == halfdays - 2 + halfdays * 270) {
                        Droid = new EntityClockworkDroid(e.world);
                        OreGeneration.spawnMonster(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, (Entity)Droid, 0, 1, true, 2);
                        continue;
                    }
                    if (e.world.field_73012_v.nextInt(4) != 1) continue;
                    OreGeneration.spawnDaleks(e.world, e.world.field_73012_v, chunk.field_76635_g, chunk.field_76647_h, 27, 28, true, 31);
                }
            }
        }
        if (TileEntityMoment.waveDataList.size() > 0) {
            for (int x = 0; x < TileEntityMoment.waveDataList.size(); ++x) {
                TileEntityMoment.MomentWaveData data = TileEntityMoment.waveDataList.get(x);
                data.grow(e.world);
            }
        }
        for (SchematicUtils.GenerationQueue queue : SchematicUtils.GenerationQueue.values()) {
            if (queue.getList() == null || queue.getList().size() <= 0) continue;
            SchematicUtils.SchematicChunk chunk = queue.getList().get(0);
            WorldServer w = e.world.func_73046_m().func_71218_a(chunk.getWorld());
            for (SchematicUtils.SchematicChunk.SchematicChunkBlockState bs : chunk.getBlocks()) {
                if (bs.getBlockUpdater() != null) {
                    bs.getBlockUpdater().replaceBlock((World)w, bs.getPos());
                    continue;
                }
                if (bs.getBlock() != null && bs.getBlock().func_177230_c().func_176223_P() == w.func_180495_p(bs.getPos()).func_177230_c().func_176223_P()) continue;
                if (bs.getBlock() != null) {
                    WorldUtils.setBlockFast((World)w, bs.getPos(), bs.getBlock(), 2);
                    continue;
                }
                if (bs.getNbt() == null || bs.getNbt().length() <= 0) continue;
                TileEntity t = w.func_175625_s(bs.getPos());
                NBTTagCompound tag = new NBTTagCompound();
                try {
                    tag = JsonToNBT.func_180713_a((String)bs.getNbt());
                }
                catch (NBTException e1) {
                    TheDalekMod.LOG.error((Object)e1);
                }
                boolean setup = true;
                if (t instanceof DMTileEntityBase) {
                    boolean bl = setup = !((DMTileEntityBase)t).ignoreSetup;
                }
                if (t == null || !setup) continue;
                if (tag != null) {
                    tag.func_74768_a("x", bs.getPos().func_177958_n());
                    tag.func_74768_a("y", bs.getPos().func_177956_o());
                    tag.func_74768_a("z", bs.getPos().func_177952_p());
                    t.func_145839_a(tag);
                }
                t.func_70296_d();
                WorldUtils.markBlockForUpdate((World)w, bs.getPos());
            }
            queue.getList().remove(0);
        }
    }

    public static class EntitySizeData {
        public float size;
        public VARIANT variant;

        public EntitySizeData(float size, VARIANT variant) {
            this.size = size;
            this.variant = variant;
        }

        public static enum VARIANT {
            Y,
            X;

        }
    }
}

