/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.init;

import com.swdteam.client.gui.elements.PlanetRenders;
import com.swdteam.common.dimensions.world.WorldProviderGallifrey;
import com.swdteam.common.dimensions.world.WorldProviderMCClassic;
import com.swdteam.common.dimensions.world.WorldProviderMars;
import com.swdteam.common.dimensions.world.WorldProviderMondas;
import com.swdteam.common.dimensions.world.WorldProviderMoon;
import com.swdteam.common.dimensions.world.WorldProviderSkaro;
import com.swdteam.common.dimensions.world.WorldProviderTardis;
import com.swdteam.common.dimensions.world.WorldProviderTrenzalore;
import com.swdteam.common.dimensions.world.WorldProviderVaros;
import com.swdteam.common.dimensions.world.WorldProviderVortis;
import com.swdteam.common.planets.IPlanet;
import com.swdteam.main.config.DMConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DMDimensions {
    private static final List<Integer> planet_ordered_list = new ArrayList<Integer>();
    private static final HashMap<Integer, IPlanet> planets = new HashMap();
    public static DimensionType DIM_TARDIS;
    public static int DIM_TARDIS_ID;
    public static DimensionType DIM_SKARO;
    public static int DIM_SKARO_ID;
    public static DimensionType DIM_TRENZALORE;
    public static int DIM_TRENZALORE_ID;
    public static DimensionType DIM_MOON;
    public static int DIM_MOON_ID;
    public static DimensionType DIM_VAROS;
    public static int DIM_VAROS_ID;
    public static DimensionType DIM_GALLIFREY;
    public static int DIM_GALLIFREY_ID;
    public static DimensionType DIM_MC_CLASSIC;
    public static int DIM_MC_CLASSIC_ID;
    public static DimensionType DIM_MARS;
    public static int DIM_MARS_ID;
    public static DimensionType DIM_VORTIS;
    public static int DIM_VORTIS_ID;
    public static DimensionType DIM_MONDAS;
    public static int DIM_MONDAS_ID;

    public static void init() {
        if (!DMConfig.dimensionIDs.useCustomIDs) {
            DIM_TARDIS_ID = DimensionManager.getNextFreeDimId();
            DIM_MOON_ID = DimensionManager.getNextFreeDimId();
            DIM_MC_CLASSIC_ID = DimensionManager.getNextFreeDimId();
            DIM_SKARO_ID = DimensionManager.getNextFreeDimId();
            DIM_GALLIFREY_ID = DimensionManager.getNextFreeDimId();
            DIM_VAROS_ID = DimensionManager.getNextFreeDimId();
            DIM_MARS_ID = DimensionManager.getNextFreeDimId();
            DIM_VORTIS_ID = DimensionManager.getNextFreeDimId();
            DIM_MONDAS_ID = DimensionManager.getNextFreeDimId();
        }
        DIM_TARDIS = DimensionType.register((String)"TARDIS", (String)"_tardis", (int)DIM_TARDIS_ID, WorldProviderTardis.class, (boolean)false);
        DimensionManager.registerDimension((int)DIM_TARDIS_ID, (DimensionType)DIM_TARDIS);
        DIM_SKARO = DimensionType.register((String)"SKARO", (String)"_skaro", (int)DIM_SKARO_ID, WorldProviderSkaro.class, (boolean)false);
        DimensionManager.registerDimension((int)DIM_SKARO_ID, (DimensionType)DIM_SKARO);
        DIM_TRENZALORE = DimensionType.register((String)"TRENZALORE", (String)"_trenzalore", (int)DIM_TRENZALORE_ID, WorldProviderTrenzalore.class, (boolean)false);
        DimensionManager.registerDimension((int)DIM_TRENZALORE_ID, (DimensionType)DIM_TRENZALORE);
        DIM_MOON = DimensionType.register((String)"MOON", (String)"_moon", (int)DIM_MOON_ID, WorldProviderMoon.class, (boolean)false);
        DimensionManager.registerDimension((int)DIM_MOON_ID, (DimensionType)DIM_MOON);
        DIM_VAROS = DimensionType.register((String)"VAROS", (String)"_varos", (int)DIM_VAROS_ID, WorldProviderVaros.class, (boolean)false);
        DimensionManager.registerDimension((int)DIM_VAROS_ID, (DimensionType)DIM_VAROS);
        DIM_GALLIFREY = DimensionType.register((String)"GALLIFREY", (String)"_gallifrey", (int)DIM_GALLIFREY_ID, WorldProviderGallifrey.class, (boolean)false);
        DimensionManager.registerDimension((int)DIM_GALLIFREY_ID, (DimensionType)DIM_GALLIFREY);
        DIM_MC_CLASSIC = DimensionType.register((String)"MINECRAFT CLASSIC", (String)"_mc_classic", (int)DIM_MC_CLASSIC_ID, WorldProviderMCClassic.class, (boolean)false);
        DimensionManager.registerDimension((int)DIM_MC_CLASSIC_ID, (DimensionType)DIM_MC_CLASSIC);
        DIM_MARS = DimensionType.register((String)"MARS", (String)"_mars", (int)DIM_MARS_ID, WorldProviderMars.class, (boolean)false);
        DimensionManager.registerDimension((int)DIM_MARS_ID, (DimensionType)DIM_MARS);
        DIM_VORTIS = DimensionType.register((String)"VORTIS", (String)"_vortis", (int)DIM_VORTIS_ID, WorldProviderVortis.class, (boolean)false);
        DimensionManager.registerDimension((int)DIM_VORTIS_ID, (DimensionType)DIM_VORTIS);
        DIM_MONDAS = DimensionType.register((String)"MONDAS", (String)"_mondas", (int)DIM_MONDAS_ID, WorldProviderMondas.class, (boolean)false);
        DimensionManager.registerDimension((int)DIM_MONDAS_ID, (DimensionType)DIM_MONDAS);
        DMDimensions.addPlanet(0, new IPlanet(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public ResourceLocation getPlanetRenderer() {
                return PlanetRenders.EARTH;
            }

            @Override
            public String getPlanetName() {
                return "Overworld";
            }
        });
        DMDimensions.addPlanet(-1, new IPlanet(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public ResourceLocation getPlanetRenderer() {
                return PlanetRenders.NETHER;
            }

            @Override
            public String getPlanetName() {
                return "Nether";
            }
        });
        DMDimensions.addPlanet(1, new IPlanet(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public ResourceLocation getPlanetRenderer() {
                return PlanetRenders.END;
            }

            @Override
            public String getPlanetName() {
                return "End";
            }
        });
        DMDimensions.addPlanet(DIM_VAROS_ID, new IPlanet(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public ResourceLocation getPlanetRenderer() {
                return PlanetRenders.VAROS;
            }

            @Override
            public String getPlanetName() {
                return "Varos";
            }
        });
        DMDimensions.addPlanet(DIM_MOON_ID, new IPlanet(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public ResourceLocation getPlanetRenderer() {
                return PlanetRenders.MOON;
            }

            @Override
            public String getPlanetName() {
                return "Moon";
            }
        });
        DMDimensions.addPlanet(DIM_SKARO_ID, new IPlanet(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public ResourceLocation getPlanetRenderer() {
                return PlanetRenders.SKARO;
            }

            @Override
            public String getPlanetName() {
                return "Skaro";
            }
        });
        DMDimensions.addPlanet(DIM_TRENZALORE_ID, new IPlanet(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public ResourceLocation getPlanetRenderer() {
                return PlanetRenders.TRENZALORE;
            }

            @Override
            public String getPlanetName() {
                return "Trenzalore";
            }
        });
        DMDimensions.addPlanet(DIM_GALLIFREY_ID, new IPlanet(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public ResourceLocation getPlanetRenderer() {
                return PlanetRenders.GALLIFREY;
            }

            @Override
            public String getPlanetName() {
                return "Gallifrey";
            }
        });
        DMDimensions.addPlanet(DIM_MC_CLASSIC_ID, new IPlanet(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public ResourceLocation getPlanetRenderer() {
                return PlanetRenders.CLASSIC;
            }

            @Override
            public String getPlanetName() {
                return "Minecraft Classic";
            }
        });
        DMDimensions.addPlanet(DIM_MARS_ID, new IPlanet(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public ResourceLocation getPlanetRenderer() {
                return PlanetRenders.MARS;
            }

            @Override
            public String getPlanetName() {
                return "Mars";
            }
        });
        DMDimensions.addPlanet(DIM_VORTIS_ID, new IPlanet(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public ResourceLocation getPlanetRenderer() {
                return PlanetRenders.VORTIS;
            }

            @Override
            public String getPlanetName() {
                return "Vortis";
            }
        });
        DMDimensions.addPlanet(DIM_MONDAS_ID, new IPlanet(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public ResourceLocation getPlanetRenderer() {
                return PlanetRenders.MONDAS;
            }

            @Override
            public String getPlanetName() {
                return "Mondas";
            }
        });
        for (int i : DMConfig.serverSide.DISABLED_DIMENSIONS) {
            if (!DimensionManager.isDimensionRegistered((int)i)) continue;
            DimensionManager.unregisterDimension((int)i);
            System.out.println("Unregistered: " + i);
        }
    }

    public static void addPlanet(int dimID, IPlanet planet) {
        planets.put(dimID, planet);
        planet_ordered_list.add(dimID);
    }

    public static IPlanet getPlanetForDimension(int id) {
        if (planets.containsKey(id)) {
            return planets.get(id);
        }
        return planets.get(0);
    }

    public static int getIndexOfDimension(int id) {
        if (planet_ordered_list.contains(id)) {
            return planet_ordered_list.indexOf(id);
        }
        return 0;
    }

    public static int getIDOfDimensionAtIndex(int id) {
        if (id >= 0 && id < planet_ordered_list.size()) {
            return planet_ordered_list.get(id);
        }
        return 0;
    }

    public static HashMap<Integer, IPlanet> getPlanets() {
        return planets;
    }

    public static List<Integer> getPlanetOrderedList() {
        return planet_ordered_list;
    }

    static {
        DIM_TARDIS_ID = DMConfig.dimensionIDs.Tardis_Dimension_ID;
        DIM_SKARO_ID = DMConfig.dimensionIDs.Skaro_Dimension_ID;
        DIM_TRENZALORE_ID = DMConfig.dimensionIDs.Trenzalore_Dimension_ID;
        DIM_MOON_ID = DMConfig.dimensionIDs.Moon_Dimension_ID;
        DIM_VAROS_ID = DMConfig.dimensionIDs.Varos_Dimension_ID;
        DIM_GALLIFREY_ID = DMConfig.dimensionIDs.Gallifrey_Dimension_ID;
        DIM_MC_CLASSIC_ID = DMConfig.dimensionIDs.Minecraft_Classic_Dimension_ID;
        DIM_MARS_ID = DMConfig.dimensionIDs.Mars_Dimension_ID;
        DIM_VORTIS_ID = DMConfig.dimensionIDs.Vortis_Dimension_ID;
        DIM_MONDAS_ID = DMConfig.dimensionIDs.Mondas_Dimension_ID;
    }
}

