/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.regeneration.skinchanging.packet;

import com.swdteam.common.capability.CapabilityRegeneration;
import com.swdteam.common.capability.interfaces.IRegenerationCapability;
import com.swdteam.common.regeneration.skinchanging.SkinChangingHandler;
import com.swdteam.common.regeneration.skinchanging.packet.Packet_RemovePlayerRegen;
import com.swdteam.network.packets.PacketHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class Packet_RegenSkinChange
implements IMessage {
    public String uuid;
    public BufferedImage image;
    public SkinChangingHandler.SkinChoice choice;

    public Packet_RegenSkinChange() {
    }

    public Packet_RegenSkinChange(String player, BufferedImage image, SkinChangingHandler.SkinChoice choice) {
        this.uuid = player;
        this.image = image;
        this.choice = choice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromBytes(ByteBuf buf) {
        this.uuid = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.choice = SkinChangingHandler.SkinChoice.getSkinChoice(ByteBufUtils.readUTF8String((ByteBuf)buf));
        ByteBufInputStream in = new ByteBufInputStream(buf);
        try {
            this.image = ImageIO.read((InputStream)in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.uuid);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.choice.getChoice());
        ByteBufOutputStream out = new ByteBufOutputStream(buf);
        try {
            if (this.image != null) {
                ImageIO.write((RenderedImage)this.image, "png", (OutputStream)out);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class Handler
    implements IMessageHandler<Packet_RegenSkinChange, IMessage> {
        public IMessage onMessage(final Packet_RegenSkinChange message, final MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_71121_q().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayer player = ctx.getServerHandler().field_147369_b.field_70170_p.func_152378_a(UUID.fromString(message.uuid));
                    if (player != null) {
                        IRegenerationCapability cap = (IRegenerationCapability)player.getCapability(CapabilityRegeneration.REGEN_CAP, null);
                        cap.getSkinData().setBufferedImage(message.image);
                        cap.getSkinData().setSkinType(message.choice);
                        cap.setSkinChanged(true);
                        cap.syncToPlayer();
                        for (Object o : ctx.getServerHandler().field_147369_b.field_70170_p.field_73010_i) {
                            PacketHandler.INSTANCE.sendTo(new Packet_RemovePlayerRegen(message.uuid), (EntityPlayerMP)o);
                        }
                    }
                }
            });
            return null;
        }
    }
}

