/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.network.packets;

import com.swdteam.common.init.DMWaypoints;
import com.swdteam.network.packets.AbstractServerMessageHandler;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_SendWaypoints;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class Packet_DeleteWaypoint
implements IMessage {
    public int tardisID;
    public int pageID;
    public String wpID;

    public Packet_DeleteWaypoint() {
    }

    public Packet_DeleteWaypoint(int tardisID, int pageID, String wpID) {
        this.tardisID = tardisID;
        this.pageID = pageID;
        this.wpID = wpID;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.tardisID);
        buf.writeInt(this.pageID);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.wpID);
    }

    public void fromBytes(ByteBuf buf) {
        this.tardisID = buf.readInt();
        this.pageID = buf.readInt();
        this.wpID = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public static class Handler
    extends AbstractServerMessageHandler<Packet_DeleteWaypoint> {
        @Override
        public IMessage handleServerMessage(final EntityPlayer player, final Packet_DeleteWaypoint message, MessageContext ctx) {
            player.func_184102_h().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    DMWaypoints.deleteWaypoint(message.tardisID, message.wpID);
                    NBTTagCompound wp = DMWaypoints.getWaypointsAsNBT(message.tardisID, message.pageID);
                    PacketHandler.INSTANCE.sendTo(new Packet_SendWaypoints(wp, DMWaypoints.getTotalWaypoints(message.tardisID)), (EntityPlayerMP)player);
                }
            });
            return null;
        }
    }
}

