/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.Collection;
import java.util.Comparator;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientListElement;
import mezz.jei.ingredients.IngredientListElementComparator;
import mezz.jei.startup.IModIdHelper;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.ProgressManager;

public final class IngredientListElementFactory {
    private IngredientListElementFactory() {
    }

    public static NonNullList<IIngredientListElement> createBaseList(IIngredientRegistry ingredientRegistry, IModIdHelper modIdHelper) {
        NonNullList ingredientListElements = NonNullList.func_191196_a();
        for (Class ingredientClass : ingredientRegistry.getRegisteredIngredientClasses()) {
            IngredientListElementFactory.addToBaseList((NonNullList<IIngredientListElement>)ingredientListElements, ingredientRegistry, ingredientClass, modIdHelper);
        }
        ingredientListElements.sort((Comparator)IngredientListElementComparator.INSTANCE);
        return ingredientListElements;
    }

    public static <V> NonNullList<IIngredientListElement<V>> createList(IIngredientRegistry ingredientRegistry, Class<? extends V> ingredientClass, Collection<V> ingredients, IModIdHelper modIdHelper) {
        IIngredientHelper<? extends V> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientClass);
        IIngredientRenderer<? extends V> ingredientRenderer = ingredientRegistry.getIngredientRenderer(ingredientClass);
        NonNullList list = NonNullList.func_191196_a();
        for (V ingredient : ingredients) {
            IngredientListElement<? extends V> ingredientListElement;
            if (ingredient == null || (ingredientListElement = IngredientListElement.create(ingredient, ingredientHelper, ingredientRenderer, modIdHelper)) == null) continue;
            list.add(ingredientListElement);
        }
        return list;
    }

    @Nullable
    public static <V> IIngredientListElement<V> createElement(IIngredientRegistry ingredientRegistry, Class<? extends V> ingredientClass, V ingredient, IModIdHelper modIdHelper) {
        IIngredientHelper<? extends V> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientClass);
        IIngredientRenderer<? extends V> ingredientRenderer = ingredientRegistry.getIngredientRenderer(ingredientClass);
        return IngredientListElement.create(ingredient, ingredientHelper, ingredientRenderer, modIdHelper);
    }

    private static <V> void addToBaseList(NonNullList<IIngredientListElement> baseList, IIngredientRegistry ingredientRegistry, Class<V> ingredientClass, IModIdHelper modIdHelper) {
        IIngredientHelper<V> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientClass);
        IIngredientRenderer<V> ingredientRenderer = ingredientRegistry.getIngredientRenderer(ingredientClass);
        Collection<V> ingredients = ingredientRegistry.getAllIngredients(ingredientClass);
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)("Registering ingredients: " + ingredientClass.getSimpleName()), (int)ingredients.size());
        for (V ingredient : ingredients) {
            IngredientListElement<V> ingredientListElement;
            progressBar.step("");
            if (ingredient == null || (ingredientListElement = IngredientListElement.create(ingredient, ingredientHelper, ingredientRenderer, modIdHelper)) == null) continue;
            baseList.add(ingredientListElement);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }
}

