/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.gui;

import com.swdteam.client.gui.elements.GuiButtonImage;
import com.swdteam.client.init.DMTCNModelLoader;
import com.swdteam.common.tileentity.TileEntityTCNLoader;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_UpdateTcnData;
import com.swdteam.utils.Graphics;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiSlider;
import org.lwjgl.opengl.GL11;

public class GuiTCNLoader
extends GuiScreen {
    private String popupText = "";
    private static final ResourceLocation LOGO_MDL = new ResourceLocation("thedalekmod", "gui/model_loader/mdl.png");
    GuiTextField searchBox;
    GuiSlider scaleBox;
    float tileSize = 44.0f;
    float tilePadding = 2.0f;
    private int pageID = 0;
    private int selectedID = -1;
    private TileEntityTCNLoader.ModelPath path = TileEntityTCNLoader.ModelPath.MODELS;
    private TileEntityTCNLoader tempTileEntity;
    private DMTCNModelLoader.ModelLoaderModel[] models;
    private DMTCNModelLoader.ModelLoaderModel[] searchResults;
    private final List<String> tooltips = new ArrayList<String>();

    public GuiTCNLoader(TileEntity t) {
        if (!(t instanceof TileEntityTCNLoader)) {
            Minecraft.func_71410_x().func_147108_a(null);
            return;
        }
        this.tempTileEntity = (TileEntityTCNLoader)t;
        this.path = this.tempTileEntity.getModelPath();
        HashMap<String, DMTCNModelLoader.ModelLoaderModel> modelMap = DMTCNModelLoader.getModels(this.path);
        this.models = new DMTCNModelLoader.ModelLoaderModel[modelMap.size()];
        int i = 0;
        Iterator iterator = modelMap.values().iterator();
        while (iterator.hasNext()) {
            DMTCNModelLoader.ModelLoaderModel v;
            this.models[i] = v = (DMTCNModelLoader.ModelLoaderModel)iterator.next();
            ++i;
        }
        this.searchResults = this.models;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 + 100, this.field_146295_m / 2 - 82, 39, 20, "<"));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 140, this.field_146295_m / 2 - 82, 39, 20, ">"));
        this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 + 100, this.field_146295_m / 2 - 60, 80, 20, "View Model"));
        this.field_146292_n.add(new GuiButton(3, this.field_146294_l / 2 + 100, this.field_146295_m / 2 - 38, 80, 20, "Lock GUI"));
        this.field_146292_n.add(new GuiButton(4, this.field_146294_l / 2 + 100, this.field_146295_m / 2 - 16, 80, 20, "Reload Models"));
        this.field_146292_n.add(new GuiButton(5, this.field_146294_l / 2 + 100, this.field_146295_m / 2 + 6, 80, 20, "Open Folder"));
        this.field_146292_n.add(new GuiButton(6, this.field_146294_l / 2 + 100, this.field_146295_m / 2 + 52, 58, 20, "Search"));
        this.field_146292_n.add(new GuiButton(7, this.field_146294_l / 2 + 100, this.field_146295_m / 2 + 74, 80, 20, "Save Changes"));
        this.field_146292_n.add(new GuiButtonImage(8, this.field_146294_l / 2 + 160, this.field_146295_m / 2 + 52, 20, 0, 20, 20));
        this.searchBox = new GuiTextField(8, this.field_146289_q, this.field_146294_l / 2 + 101, this.field_146295_m / 2 + 29, 78, 20);
        this.searchBox.func_146184_c(true);
        this.searchBox.func_146203_f(64);
        this.scaleBox = new GuiSlider(9, this.field_146294_l / 2 - 177, this.field_146295_m / 2 + 60, 135, 20, "Scale: ", "", 0.0, 5.0, 1.0, true, true);
        this.field_146292_n.add(new GuiSlider(10, this.field_146294_l / 2 - 39, this.field_146295_m / 2 + 60, 135, 20, "Rotation: ", "", 0.0, 360.0, 1.0, true, true));
        this.field_146292_n.add(this.scaleBox);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.tooltips.clear();
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, "Model Loader", this.field_146294_l / 2, 12, -1);
        this.func_73732_a(this.field_146289_q, this.popupText, this.field_146294_l / 2, 25, -1);
        for (int i = 0; i < 18; ++i) {
            DMTCNModelLoader.ModelLoaderModel model = null;
            if (i + 18 * this.pageID >= 0 && i + 18 * this.pageID < this.searchResults.length) {
                model = this.searchResults[i + 18 * this.pageID];
            }
            float x = (float)(this.field_146294_l / 2) - (this.tileSize + this.tilePadding) * 6.0f / 2.0f + (float)(i % 6) * (this.tileSize + this.tilePadding) - 40.0f;
            float y = (float)(this.field_146295_m / 2) - (this.tilePadding + this.tileSize) * 4.0f / 2.0f + (float)(i / 6) * (this.tileSize + this.tilePadding) + 10.0f;
            Graphics.FillRect((double)x, (double)y, (double)this.tileSize, (double)this.tileSize, 1.0, -15658735);
            if (i == this.selectedID) {
                Graphics.FillRect((double)x, (double)y, (double)this.tileSize, (double)this.tileSize, 1.0, -8947713);
            }
            Graphics.FillRect((double)(x + 1.0f), (double)(y + 1.0f), (double)(this.tileSize - 2.0f), (double)(this.tileSize - 2.0f), 1.0, -14540254);
            Graphics.bindTexture(LOGO_MDL);
            Graphics.drawNoBind(x + (this.tileSize - 32.0f) / 2.0f, y + (this.tileSize - 32.0f) / 2.0f, 32.0f, 32.0f, 1);
            int currentTex = GL11.glGetInteger((int)32873);
            if (model != null) {
                int texID = model.getTextureID();
                if (texID >= 0) {
                    Graphics.bindTexture(texID);
                    Graphics.drawNoBind(x + 1.0f, y + 1.0f, this.tileSize - 2.0f, this.tileSize - 2.0f, 1);
                    Graphics.bindTexture(currentTex);
                } else {
                    Graphics.bindTexture(model.getModelType().getTexture());
                    Graphics.drawNoBind(x + (this.tileSize - 32.0f) / 2.0f, y + (this.tileSize - 32.0f) / 2.0f, 32.0f, 32.0f, 1);
                    Graphics.bindTexture(currentTex);
                }
            }
            if (!((float)mouseX > x) || !((float)mouseX < x + this.tileSize) || !((float)mouseY > y) || !((float)mouseY < y + this.tileSize) || model == null) continue;
            this.tooltips.add(model.getName());
            this.tooltips.add(TextFormatting.YELLOW + "Type: " + TextFormatting.RESET + model.getModelType().getModelName());
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, "X", this.field_146294_l / 2 + 170, this.field_146295_m / 2 + 58, -1);
        this.field_146289_q.func_175065_a("Page: " + (this.pageID + 1) + "/" + (int)Math.ceil((float)this.searchResults.length / 18.0f), (float)(this.field_146294_l / 2 - 177), 26.0f, -1, true);
        this.field_146289_q.func_175065_a("Current Model: " + this.tempTileEntity.getModelName(), (float)(this.field_146294_l / 2 - 177), (float)(this.field_146295_m / 2 + 86), -1, true);
        this.searchBox.func_146194_f();
        this.func_146283_a(this.tooltips, mouseX, mouseY);
    }

    public void func_73876_c() {
        this.searchBox.func_146178_a();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            this.pageID = this.pageID - 1 < 0 ? 0 : --this.pageID;
            this.selectedID = -1;
        }
        if (button.field_146127_k == 1) {
            if (this.pageID + 1 < (int)Math.ceil((float)this.searchResults.length / 18.0f)) {
                ++this.pageID;
            }
            this.selectedID = -1;
        }
        if (button.field_146127_k == 6) {
            DMTCNModelLoader.ModelLoaderModel[] m = this.searchModels(this.searchBox.func_146179_b());
            if (m != null) {
                this.searchResults = m;
            }
            this.selectedID = -1;
        }
        if (button.field_146127_k == 8) {
            this.searchResults = this.models;
            this.searchBox.func_146180_a("");
            this.popupText = "";
            this.selectedID = -1;
        }
        if (button.field_146127_k == 4) {
            DMTCNModelLoader.getModels(this.path).clear();
            DMTCNModelLoader.initModels(this.path);
            HashMap<String, DMTCNModelLoader.ModelLoaderModel> modelMap = DMTCNModelLoader.getModels(this.path);
            this.models = new DMTCNModelLoader.ModelLoaderModel[modelMap.size()];
            int i = 0;
            Iterator iterator = modelMap.values().iterator();
            while (iterator.hasNext()) {
                DMTCNModelLoader.ModelLoaderModel v;
                this.models[i] = v = (DMTCNModelLoader.ModelLoaderModel)iterator.next();
                ++i;
            }
            this.searchResults = this.models;
            this.selectedID = -1;
        }
        if (button.field_146127_k == 7 && this.selectedID >= 0 && this.selectedID < this.searchResults.length) {
            PacketHandler.INSTANCE.sendToServer(new Packet_UpdateTcnData("exterior", this.searchResults[this.selectedID].getName(), this.tempTileEntity.func_174877_v(), this.tempTileEntity.func_145831_w().field_73011_w.getDimension()));
            this.selectedID = -1;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.searchBox.func_146201_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.searchBox.func_146192_a(mouseX, mouseY, mouseButton);
        for (int i = 0; i < 18; ++i) {
            DMTCNModelLoader.ModelLoaderModel model = null;
            if (i + 18 * this.pageID >= 0 && i + 18 * this.pageID < this.searchResults.length) {
                model = this.searchResults[i + 18 * this.pageID];
            }
            float x = (float)(this.field_146294_l / 2) - (this.tileSize + this.tilePadding) * 6.0f / 2.0f + (float)(i % 6) * (this.tileSize + this.tilePadding) - 40.0f;
            float y = (float)(this.field_146295_m / 2) - (this.tilePadding + this.tileSize) * 4.0f / 2.0f + (float)(i / 6) * (this.tileSize + this.tilePadding) + 10.0f;
            if (!((float)mouseX > x) || !((float)mouseX < x + this.tileSize) || !((float)mouseY > y) || !((float)mouseY < y + this.tileSize) || model == null) continue;
            this.selectedID = i;
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    public DMTCNModelLoader.ModelLoaderModel[] searchModels(String term) {
        if (term.length() < 3) {
            this.popupText = TextFormatting.RED + "Search term must be 3 or more characters.";
            return null;
        }
        ArrayList<DMTCNModelLoader.ModelLoaderModel> mdls = new ArrayList<DMTCNModelLoader.ModelLoaderModel>();
        for (int i = 0; i < this.models.length; ++i) {
            DMTCNModelLoader.ModelLoaderModel m = this.models[i];
            if (!m.getName().contains(term)) continue;
            mdls.add(m);
        }
        this.popupText = TextFormatting.GREEN + "" + mdls.size() + " results found for: " + term;
        return mdls.toArray(new DMTCNModelLoader.ModelLoaderModel[mdls.size()]);
    }

    public boolean func_73868_f() {
        return false;
    }
}

