/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.dimensions.world;

import com.swdteam.common.dimensions.world.WorldProviderDMBase;
import com.swdteam.common.init.DMBiomes;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.planets.weather.IRain;
import com.swdteam.common.planets.weather.RainType;
import com.swdteam.common.world.gen.chunk.ChunkGeneratorSkaro;
import com.swdteam.common.world.multibiome.BiomeProviderBaseMulti;
import com.swdteam.main.ClientProxy;
import javax.annotation.Nullable;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderSkaro
extends WorldProviderDMBase
implements IRain {
    private static Biome[] biomes = new Biome[]{DMBiomes.BIOME_SKARO, DMBiomes.BIOME_SKAROFOREST, DMBiomes.BIOME_SKAROOCEAN, DMBiomes.BIOME_SKAROJUNGLE, DMBiomes.BIOME_SKARODESERT, DMBiomes.BIOME_SKAROPLAINS};
    public Vec3d fogColor = new Vec3d(0.96, 0.847, 1.0);
    MusicTicker.MusicType muziek = null;
    Vec3d cloudColor = new Vec3d(1.0, 0.9019607901573181, 0.9019607901573181);
    private final float[] colorsSunriseSunset = new float[4];

    public WorldProviderSkaro() {
        super(true);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float p_76562_1_, float p_76562_2_) {
        return this.fogColor;
    }

    public String getSaveFolder() {
        return "dm_skaro";
    }

    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorSkaro(this.field_76579_a, 666L);
    }

    public BiomeProvider func_177499_m() {
        if (!(this.field_76578_c instanceof BiomeProviderBaseMulti)) {
            this.field_76578_c = new BiomeProviderBaseMulti(666L, biomes);
        }
        return this.field_76578_c;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public MusicTicker.MusicType getMusicType() {
        if (ClientProxy.getCurrentMusic() == null) {
            this.muziek = ClientProxy.getRandomMusicType(DMBiomes.BIOME_SKARO);
            return this.muziek;
        }
        return this.muziek;
    }

    public DimensionType func_186058_p() {
        return DMDimensions.DIM_SKARO;
    }

    public boolean func_76566_a(int x, int z) {
        return false;
    }

    public boolean func_76567_e() {
        return false;
    }

    public int func_76557_i() {
        return 60;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76568_b(int par1, int par2) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76561_g() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getCloudColor(float partialTicks) {
        return this.cloudColor;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        return 140.0f;
    }

    protected void func_76556_a() {
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            this.field_76573_f[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * 1.0f + 0.0f;
        }
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        int i = (int)(worldTime % 24000L);
        float f = ((float)i + partialTicks) / 24000.0f - 0.25f;
        if (f < 0.0f) {
            f += 1.0f;
        }
        if (f > 1.0f) {
            f -= 1.0f;
        }
        float f1 = 1.0f - (float)((Math.cos((double)f * Math.PI) + 1.0) / 2.0);
        f += (f1 - f) / 3.0f;
        return f;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public float[] func_76560_a(float celestialAngle, float partialTicks) {
        float f = 0.4f;
        float f1 = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) - 0.0f;
        float f2 = -0.0f;
        if (f1 >= -0.4f && f1 <= 0.4f) {
            float f3 = (f1 - -0.0f) / 0.4f * 0.5f + 0.5f;
            float f4 = 1.0f - (1.0f - MathHelper.func_76126_a((float)(f3 * (float)Math.PI))) * 0.99f;
            f4 *= f4;
            this.colorsSunriseSunset[0] = f3 * 0.3f + 0.1f;
            this.colorsSunriseSunset[1] = f3 * f3 * 0.5f + 0.6f;
            this.colorsSunriseSunset[2] = f3 * 0.3f + 0.45f;
            this.colorsSunriseSunset[3] = f4;
            return this.colorsSunriseSunset;
        }
        return null;
    }

    @Override
    public boolean isDaytime() {
        return this.getWorldTime() > 1L && this.getWorldTime() < 12000L;
    }

    public float getSunBrightnessFactor(float par1) {
        return 1.0f;
    }

    public boolean isBlockHighHumidity(BlockPos pos) {
        return false;
    }

    public boolean canDoLightning(Chunk chunk) {
        return true;
    }

    public void calculateInitialWeather() {
        this.field_76579_a.field_73017_q = 1.0f;
        this.field_76579_a.field_73004_o = 0.0f;
        this.field_76579_a.func_72912_H().func_76069_a(true);
        this.field_76579_a.func_72912_H().func_76084_b(false);
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return false;
    }

    @Override
    public RainType getRainType() {
        return RainType.ACIDIC;
    }

    @Override
    public float getRainDamage() {
        return 0.5f;
    }
}

