/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.tardis.command;

import com.swdteam.dmapi.command.ITardisCommand;
import com.swdteam.main.TheDalekMod;
import com.swdteam.main.config.DMConfig;
import com.swdteam.utils.EnumDefaultResponse;
import com.swdteam.utils.PlayerUtils;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;

public class CommandProcessor {
    private static HashMap<String, ITardisCommand> commands = new HashMap();

    public static void processCommand(EntityPlayer playey, String cmd, BlockPos pos) {
        String[] commandsArray = cmd.split(";");
        for (int i = 0; i < commandsArray.length; ++i) {
            if (commandsArray[i].startsWith(" ")) {
                commandsArray[i] = commandsArray[i].substring(1);
            }
            String[] commandData = commandsArray[i].split(" ");
            String command = commandData[0].replaceFirst("/", "");
            String[] data = commandsArray[i].replaceFirst("/" + command + " ", "").split(" ");
            if (Arrays.asList(DMConfig.tardis.blockedCommands).contains(command)) {
                PlayerUtils.Messaging.sendMessageToPlayer(playey, EnumDefaultResponse.NO_PERMISSION);
                return;
            }
            if (commands.containsKey(command)) {
                ITardisCommand cmdExecute = commands.get(command);
                cmdExecute.executeCommand(playey, pos, data);
                continue;
            }
            PlayerUtils.Messaging.sendMessageToPlayer(playey, EnumDefaultResponse.COMMAND_NOT_FOUND);
        }
    }

    public static void registerCommand(ITardisCommand cmd) {
        if (commands.containsKey(cmd.getCommandName())) {
            commands.remove(cmd.getCommandName());
            TheDalekMod.LOG.info("Tardis Command " + cmd.getCommandName() + " is being overwritten");
        }
        commands.put(cmd.getCommandName(), cmd);
        TheDalekMod.LOG.info("Tardis Command " + cmd.getCommandName() + " has been registered.");
    }
}

