/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.init;

import com.swdteam.utils.FileUtils;
import com.swdteam.utils.Graphics;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class DMFontRenderer {
    public static int[] charWidth = new int[256];
    private static ResourceLocation tex = FileUtils.newResourceLocation("textures/font/ascii.png");

    public static void init() {
        BufferedImage bufferedimage;
        IResource iresource = null;
        try {
            iresource = DMFontRenderer.getResource(tex);
            bufferedimage = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        finally {
            IOUtils.closeQuietly((Closeable)iresource);
        }
        int lvt_3_2_ = bufferedimage.getWidth();
        int lvt_4_1_ = bufferedimage.getHeight();
        int[] lvt_5_1_ = new int[lvt_3_2_ * lvt_4_1_];
        bufferedimage.getRGB(0, 0, lvt_3_2_, lvt_4_1_, lvt_5_1_, 0, lvt_3_2_);
        int lvt_6_1_ = lvt_4_1_ / 16;
        int lvt_7_1_ = lvt_3_2_ / 16;
        boolean lvt_8_1_ = true;
        float lvt_9_1_ = 8.0f / (float)lvt_7_1_;
        for (int lvt_10_1_ = 0; lvt_10_1_ < 256; ++lvt_10_1_) {
            int l1;
            int j1 = lvt_10_1_ % 16;
            int k1 = lvt_10_1_ / 16;
            if (lvt_10_1_ == 32) {
                DMFontRenderer.charWidth[lvt_10_1_] = 4;
            }
            for (l1 = lvt_7_1_ - 1; l1 >= 0; --l1) {
                int i2 = j1 * lvt_7_1_ + l1;
                boolean flag1 = true;
                for (int j2 = 0; j2 < lvt_6_1_ && flag1; ++j2) {
                    int k2 = (k1 * lvt_7_1_ + j2) * lvt_3_2_;
                    if ((lvt_5_1_[i2 + k2] >> 24 & 0xFF) == 0) continue;
                    flag1 = false;
                }
                if (!flag1) break;
            }
            DMFontRenderer.charWidth[lvt_10_1_] = (int)(0.5 + (double)((float)(++l1) * lvt_9_1_)) + 1;
        }
    }

    public static void drawString(String s, float x, float y, float ... rgba) {
        GlStateManager.func_179129_p();
        Graphics.bindTexture(tex);
        FloatBuffer color = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2816, (FloatBuffer)color);
        float alphaValue = color.get(3);
        float rValue = color.get(0);
        float gValue = color.get(1);
        float bValue = color.get(2);
        int previousTexture = GL11.glGetInteger((int)32873);
        Graphics.bindTexture(TextureMap.field_110575_b);
        if (rgba.length >= 3) {
            float alpha = 1.0f;
            if (rgba.length >= 4) {
                alpha = rgba[3];
            }
            GlStateManager.func_179131_c((float)rgba[0], (float)rgba[1], (float)rgba[2], (float)alpha);
        }
        for (int i = 0; i < s.length(); ++i) {
            int c = s.charAt(i);
            if (c < 0 || c > 255) {
                c = 63;
            }
            DMFontRenderer.renderDefaultChar(x, y, c, false);
            x += (float)charWidth[c] + (c == 32 ? 3.0f : 0.1f);
        }
        GlStateManager.func_179131_c((float)rValue, (float)gValue, (float)bValue, (float)alphaValue);
        Graphics.bindTexture(previousTexture);
        GlStateManager.func_179089_o();
    }

    public static void drawCenteredString(String s, float x, float y, float ... rgba) {
        DMFontRenderer.drawString(s, x - DMFontRenderer.getStringWidth(s) / 2.0f, y + 0.5f, rgba);
    }

    public static void drawCenteredMiddleString(String s, float x, float y, float ... rgba) {
        DMFontRenderer.drawString(s, x - DMFontRenderer.getStringWidth(s) / 2.0f, y - DMFontRenderer.getStringHeight(s) / 2.0f, rgba);
    }

    public static void drawCenteredTopString(String s, float x, float y, float ... rgba) {
        DMFontRenderer.drawString(s, x - DMFontRenderer.getStringWidth(s) / 2.0f, y - 0.5f - DMFontRenderer.getStringHeight(s), rgba);
    }

    public static void drawStringWithShadow(String s, float x, float y, float ... rgba) {
        float alpha = 1.0f;
        if (rgba.length >= 4) {
            alpha = rgba[3];
        }
        DMFontRenderer.drawString(s, x + 1.0f, y + 1.0f, 0.1f, 0.1f, 0.1f, alpha);
        DMFontRenderer.drawString(s, x, y, rgba);
    }

    public static float getStringWidth(String s) {
        float width = 0.0f;
        for (int i = 0; i < s.length(); ++i) {
            int c = s.charAt(i);
            if (c < 0 || c > 255) {
                c = 63;
            }
            width += (float)charWidth[c] + (c == 32 ? 3.0f : 0.1f);
        }
        return width;
    }

    public static float getStringHeight(String s) {
        float height = 7.0f;
        return height;
    }

    protected static float renderDefaultChar(float posX, float posY, int ch, boolean italic) {
        int i = ch % 16 * 8;
        int j = ch / 16 * 8;
        boolean k = italic;
        Graphics.bindTexture(tex);
        int l = charWidth[ch];
        float f = (float)l - 0.01f;
        Gui.func_152125_a((int)((int)posX), (int)((int)posY), (float)i, (float)j, (int)8, (int)8, (int)8, (int)8, (float)128.0f, (float)128.0f);
        return l;
    }

    protected static IResource getResource(ResourceLocation location) throws IOException {
        return Minecraft.func_71410_x().func_110442_L().func_110536_a(location);
    }
}

