/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.event;

import com.swdteam.common.block.actions.ActionList;
import com.swdteam.common.capability.CapabilityRegeneration;
import com.swdteam.common.capability.CapabilityTardis;
import com.swdteam.common.capability.interfaces.IRegenerationCapability;
import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.custom_events.EventRegeneration;
import com.swdteam.common.dimensions.world.WorldProviderTardis;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMSounds;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.main.config.DMConfig;
import com.swdteam.utils.CapabilityUtils;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.FileUtils;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.Vector3;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class RegenerationHandler {
    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof EntityPlayer) || ((Entity)event.getObject()).hasCapability(CapabilityRegeneration.REGEN_CAP, null)) {
            return;
        }
        event.addCapability(FileUtils.newResourceLocation("thedalekmod:regeneration"), (ICapabilityProvider)new CapabilityRegeneration.CapabilityTimelordProvider(new CapabilityRegeneration((EntityPlayer)event.getObject())));
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget().hasCapability(CapabilityRegeneration.REGEN_CAP, null)) {
            ((IRegenerationCapability)event.getTarget().getCapability(CapabilityRegeneration.REGEN_CAP, null)).syncToPlayer();
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        NBTTagCompound nbt = (NBTTagCompound)CapabilityRegeneration.REGEN_CAP.getStorage().writeNBT(CapabilityRegeneration.REGEN_CAP, event.getOriginal().getCapability(CapabilityRegeneration.REGEN_CAP, null), null);
        CapabilityRegeneration.REGEN_CAP.getStorage().readNBT(CapabilityRegeneration.REGEN_CAP, event.getEntityPlayer().getCapability(CapabilityRegeneration.REGEN_CAP, null), null, (NBTBase)nbt);
    }

    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP && CapabilityUtils.canRegenerate((EntityPlayer)event.getEntity())) {
            IRegenerationCapability capability = (IRegenerationCapability)event.getEntity().getCapability(CapabilityRegeneration.REGEN_CAP, null);
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            int arrowCount = player.func_85035_bI();
            if (capability.getTicksExisted() == 1) {
                arrowCount = player.func_85035_bI();
            }
            if (capability.getTicksExisted() > 0 && capability.getTicksExisted() < 200) {
                MinecraftForge.EVENT_BUS.post((Event)new EventRegeneration((EntityPlayer)player, capability));
            }
            if (capability.getTicksExisted() > 0 && player.field_70163_u >= 0.0) {
                if (player.field_70170_p.field_73011_w instanceof WorldProviderTardis && capability.getTicksExisted() == 1) {
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, DMSounds.CloisterBell, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    ITardisCapability capa = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
                    int tardisID = capa.getTARDISID();
                    TardisData data = DMTardis.getTardis(tardisID);
                    if (data != null && data.isInFlight()) {
                        data.setTardisDimensionLocation(DMUtils.RANDOM.nextInt(DimensionManager.getStaticDimensionIDs().length));
                        if (data.getTardisDimensionLocation() == DMDimensions.DIM_TARDIS_ID || !DimensionManager.isDimensionRegistered((int)data.getTardisDimensionLocation())) {
                            data.setTardisDimensionLocation(0);
                        }
                        Vector3 vec = new Vector3(DMUtils.RANDOM.nextInt(player.func_130014_f_().func_175723_af().func_177722_l()), DMUtils.RANDOM.nextInt(100), DMUtils.RANDOM.nextInt(player.func_130014_f_().func_175723_af().func_177722_l()));
                        data.setTravelToLocation(vec);
                        ActionList.tardisDematRemat(player.field_70170_p, player.func_180425_c(), (EntityPlayer)player, true);
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "Your Tardis is crash landing!");
                    }
                }
                capability.setTicksExisted(capability.getTicksExisted() + 1);
                capability.syncToPlayer();
                if (!player.field_70170_p.field_72995_K && capability.getTicksExisted() > 100 && DMConfig.regeneration.Explosions && DMUtils.RANDOM.nextInt(5) <= 2) {
                    player.func_70066_B();
                    if (player.field_70170_p.func_180495_p(player.func_180425_c()).func_177230_c() instanceof BlockFire) {
                        player.field_70170_p.func_175698_g(player.func_180425_c());
                    }
                    double x = player.field_70165_t + player.func_70681_au().nextGaussian() * 2.0;
                    double y = player.field_70163_u + 0.5 + player.func_70681_au().nextGaussian() * 2.0;
                    double z = player.field_70161_v + player.func_70681_au().nextGaussian() * 2.0;
                    player.field_70170_p.func_72885_a((Entity)player, x, y, z, 0.0f, player.func_70011_f(x, y, z) >= 4.0, false);
                }
            }
            if (capability.getTicksExisted() >= 200) {
                capability.setTicksExisted(0);
                player.func_70606_j(player.func_110138_aP());
                player.func_85034_r(0);
                player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, (double)(player.func_180425_c().func_177958_n() + DMUtils.RANDOM.nextInt(3)), (double)player.func_180425_c().func_177956_o(), (double)(player.func_180425_c().func_177952_p() + DMUtils.RANDOM.nextInt(3)), new ItemStack(Items.field_185166_h, arrowCount, 0)));
                player.func_70674_bp();
                player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 3600, 3, false, false));
                capability.setRegenCount(capability.getRegenAmount() + 1);
                capability.syncToPlayer();
                player.func_184224_h(false);
            }
        }
    }

    @SubscribeEvent
    public static void onAttacked(LivingAttackEvent event) {
        if (event.getEntity() instanceof EntityPlayer && CapabilityUtils.canRegenerate((EntityPlayer)event.getEntity())) {
            IRegenerationCapability capability = (IRegenerationCapability)event.getEntity().getCapability(CapabilityRegeneration.REGEN_CAP, null);
            if ((event.getSource().func_94541_c() || event.getSource().func_76347_k()) && capability.getTicksExisted() >= 100) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayer && CapabilityUtils.canRegenerate((EntityPlayer)event.getEntity())) {
            IRegenerationCapability capability = (IRegenerationCapability)event.getEntity().getCapability(CapabilityRegeneration.REGEN_CAP, null);
            capability.setTicksExisted(0);
        }
    }

    @SubscribeEvent
    public static void playerPoseFix(PlayerInteractEvent.RightClickBlock e) {
        if (CapabilityUtils.isRegenerating(e.getEntityPlayer()) || CapabilityUtils.isInFlight(e.getEntityPlayer())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        EntityPlayer player;
        if (event.getEntity() instanceof EntityPlayer && CapabilityUtils.canRegenerate(player = (EntityPlayer)event.getEntity())) {
            IRegenerationCapability capability = (IRegenerationCapability)event.getEntity().getCapability(CapabilityRegeneration.REGEN_CAP, null);
            if (player.func_110143_aJ() - event.getAmount() <= 0.0f) {
                if (capability.getRegenAmount() < 12 && capability.getTicksExisted() == 0) {
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, DMSounds.Regeneration, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    player.func_184224_h(true);
                    event.setCanceled(true);
                    player.func_70606_j(1.5f);
                    player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)10), 200, 1, false, false));
                    if (capability.getTicksExisted() == 0) {
                        capability.setTicksExisted(1);
                    }
                    player.func_146105_b((ITextComponent)new TextComponentString("You've now regenerated " + (capability.getRegenAmount() + 1) + " times, you have " + (11 - capability.getRegenAmount()) + " regenerations left."), true);
                } else if (capability.getRegenAmount() >= 12) {
                    player.func_146105_b((ITextComponent)new TextComponentString("You're out of regenerations. You're dying this time."), true);
                }
            }
            capability.syncToPlayer();
        }
    }
}

